/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jxta.exception.ConfiguratorException;
import net.jxta.ext.config.Configurator;
import net.jxta.impl.peergroup.PlatformConfigurator;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.protocol.ConfigParams;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractConfigurator
implements PlatformConfigurator {
    public static final String PROFILE_KEY = "profile.xml";
    public static final String JXTA_PROPERTIES_KEY = "jxta.properties";
    private static final String DEFAULT_PROFILE = "/net/jxta/ext/config/resources/edge.xml";
    private static final String DEFAULT_JXTA_PROPERTIES = "/jxta.properties";
    private static final Logger LOG = Logger.getLogger((String)AbstractConfigurator.class.getName());
    private static final Map resources = new HashMap();

    public static void register(Class configurator) {
        Configurator.setConfigurator(configurator);
    }

    public static Iterator getResourceKeys() {
        return resources.keySet().iterator();
    }

    public static String getResource(String key) {
        return (String)resources.get(key);
    }

    public static String addResource(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("invalid key|value");
        }
        return resources.put(key, value);
    }

    public static void addResources(Map resources) {
        if (resources == null) {
            throw new IllegalArgumentException("invalid resources");
        }
        resources.putAll(resources);
    }

    public static String removeResource(String key) {
        return (String)resources.remove(key);
    }

    public static Map clearResources() {
        HashMap r = new HashMap(resources);
        resources.clear();
        return r;
    }

    public AbstractConfigurator(PlatformConfigurator configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("null configurator");
        }
        ConfiguratorWrapper.configurator = configurator;
    }

    public abstract PlatformConfig createPlatformConfig(PlatformConfigurator var1) throws ConfiguratorException;

    public PlatformConfig updatePlatformConfig(PlatformConfigurator configurator) throws ConfiguratorException {
        if (configurator == null) {
            throw new ConfiguratorException("null configurator");
        }
        return configurator.getPlatformConfig();
    }

    public URI getJXTAHome() {
        return ConfiguratorWrapper.configurator.getJXTAHome();
    }

    public PlatformConfig getPlatformConfig() throws ConfiguratorException {
        PlatformConfig pc;
        File cf;
        PlatformConfigurator configurator;
        block12: {
            this.manageResources();
            configurator = ConfiguratorWrapper.configurator;
            cf = new File(this.getJXTAHomeFile(), "PlatformConfig");
            pc = null;
            try {
                pc = configurator.load(cf);
            }
            catch (ConfiguratorException ce) {
                if (!LOG.isEnabledFor((Priority)Level.INFO)) break block12;
                LOG.info((Object)("invalid platform config: " + (cf != null ? cf.getAbsoluteFile() : null)), (Throwable)ce);
            }
        }
        if (pc == null) {
            try {
                pc = this.createPlatformConfig(configurator);
            }
            catch (ConfiguratorException ce) {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"invalid PlatformConfig creation", (Throwable)ce);
                }
                throw ce;
            }
        }
        configurator.setPlatformConfig(pc);
        try {
            pc = this.updatePlatformConfig(configurator);
        }
        catch (ConfiguratorException ce) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"invalid PlatformConfig update", (Throwable)ce);
            }
            throw ce;
        }
        try {
            configurator.save(cf);
        }
        catch (ConfiguratorException ce) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("unable to persist PlatformConfig: " + (cf != null ? cf.toString() : null)), (Throwable)ce);
            }
            throw ce;
        }
        return pc;
    }

    public void setPlatformConfig(PlatformConfig config) {
        ConfiguratorWrapper.configurator.setPlatformConfig(config);
    }

    public ConfigParams getConfigParams() throws ConfiguratorException {
        return ConfiguratorWrapper.configurator.getConfigParams();
    }

    public void setConfigParams(ConfigParams cp) {
        this.setPlatformConfig((PlatformConfig)cp);
    }

    public void setReconfigure(boolean reconfigure) {
        ConfiguratorWrapper.configurator.setReconfigure(reconfigure);
    }

    public ConfigParams load() throws ConfiguratorException {
        return ConfiguratorWrapper.configurator.load();
    }

    public PlatformConfig load(File pc) throws ConfiguratorException {
        return ConfiguratorWrapper.configurator.load(pc);
    }

    public boolean isReconfigure() {
        return ConfiguratorWrapper.configurator.isReconfigure();
    }

    public boolean save() throws ConfiguratorException {
        return ConfiguratorWrapper.configurator.save();
    }

    public boolean save(File f) throws ConfiguratorException {
        return ConfiguratorWrapper.configurator.save(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void manageResources() {
        Iterator r = AbstractConfigurator.getResourceKeys();
        while (r.hasNext()) {
            IOException ioe2222;
            Object var9_9;
            BufferedOutputStream bos;
            InputStream is;
            File f;
            block18: {
                String key = (String)r.next();
                String value = AbstractConfigurator.getResource(key);
                f = new File(this.getJXTAHomeFile(), key);
                if (f.exists() || (is = this.getClass().getResourceAsStream(value)) == null) continue;
                bos = null;
                f.createNewFile();
                bos = new BufferedOutputStream(new FileOutputStream(f));
                int c = -1;
                while ((c = is.read()) > -1) {
                    bos.write(c);
                }
                bos.flush();
                var9_9 = null;
                if (is == null) break block18;
                try {
                    is.close();
                }
                catch (IOException ioe2222) {
                    // empty catch block
                }
            }
            if (bos == null) continue;
            try {
                bos.close();
            }
            catch (IOException ioe2222) {}
            continue;
            {
                catch (IOException ioe3) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)("can't persist resource: " + f.getName()), (Throwable)ioe3);
                    }
                    var9_9 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe2222) {
                            // empty catch block
                        }
                    }
                    if (bos == null) continue;
                    try {
                        bos.close();
                    }
                    catch (IOException ioe2222) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var9_9 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe2222) {
                        // empty catch block
                    }
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ioe2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private File getJXTAHomeFile() {
        return new File(this.getJXTAHome());
    }

    static {
        resources.put(PROFILE_KEY, DEFAULT_PROFILE);
        resources.put(JXTA_PROPERTIES_KEY, DEFAULT_JXTA_PROPERTIES);
    }

    static class ConfiguratorWrapper {
        static PlatformConfigurator configurator = new Configurator();

        ConfiguratorWrapper() {
        }
    }
}

