/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.GraphicShell;
import madkit.kernel.Kernel;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.pluginmanager.HelpViewer;
import madkit.pluginmanager.InstallIndex;
import madkit.pluginmanager.InstallStep;
import madkit.pluginmanager.ManagerAgent;
import madkit.pluginmanager.SelectedPluginMessage;
import madkit.pluginmanager.SettingsFrame;

public class PluginInstaller
extends JFrame
implements GraphicShell {
    private Kernel _kernel;
    private HelpViewer _help = null;
    private JPanel cards;
    private JButton _btnNext;
    private InstallIndex _index;
    private Hashtable _context;
    private Hashtable _guis = null;

    public PluginInstaller(File file) {
        Object object2;
        this.setTitle("Plugin Installer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PluginInstaller.this.askAndExit();
            }
        });
        URL uRL = this.getClass().getResource("/images/madkit_logo32.gif");
        if (uRL != null) {
            this.setIconImage(new ImageIcon(uRL).getImage());
        }
        this._context = new Hashtable();
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        this._kernel = new Kernel("Plugin Installer");
        this._kernel.registerGUI((GraphicShell)this);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(246, 247, 233));
        JLabel jLabel = new JLabel();
        URL uRL2 = this.getClass().getResource("/images/title.jpg");
        if (uRL2 != null) {
            jLabel.setIcon(new ImageIcon(uRL2));
        }
        jPanel.add(jLabel);
        this.getContentPane().add((Component)jPanel, "North");
        this._index = new InstallIndex();
        this.createComponents();
        this.getContentPane().add((Component)this._index, "West");
        this.cards = new JPanel();
        this.cards.setLayout(new CardLayout());
        for (Object object2 : this._index.getSteps()) {
            ((InstallStep)object2).initPanel();
            this.cards.add((Component)((InstallStep)object2).getPanel(), ((InstallStep)object2).getName());
        }
        this.getContentPane().add((Component)this.cards, "Center");
        JPanel jPanel2 = new JPanel();
        this._btnNext = new JButton("Next >");
        this._btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginInstaller.this.next();
            }
        });
        object2 = new JButton("< Back");
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginInstaller.this.back();
            }
        });
        JButton jButton = new JButton("Exit");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginInstaller.this.askAndExit();
            }
        });
        JButton jButton2 = new JButton("Help");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PluginInstaller.this._help == null) {
                    PluginInstaller.this._help = new HelpViewer();
                }
                PluginInstaller.this._help.setPage(PluginInstaller.this._index.getCurrentStep().getHelpURL());
                PluginInstaller.this._help.show();
            }
        });
        jPanel2.add((Component)object2);
        jPanel2.add(this._btnNext);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.setSize(700, 450);
        this.show();
    }

    private void askAndExit() {
        int n = JOptionPane.showConfirmDialog(this, "Do you really want to Exit ?", "Exit", 0);
        if (n == 0) {
            System.exit(0);
        }
    }

    private void createComponents() {
        this._index.addInstallStep(new InstallStep(0, "intro", "Introduction"){

            public void initPanel() {
                JLabel jLabel = new JLabel();
                jLabel.setText("<html><body><h1>MadKit -<i> Multi Agent Development Kit</i></h1><h2>Version 4.0 </h2><p>This installer will guide you through the installation of MadKit.</p><p>Click <b>Help</b> for instructions on any of the Installation Steps</p></body></html>");
                this._panel.setLayout(new BorderLayout());
                this._panel.add((Component)jLabel, "Center");
            }

            public URL getHelpURL() {
                return this.getClass().getResource("help-intro.html");
            }
        });
        this._index.addInstallStep(new InstallStep(1, "license", "Madkit's License"){

            public void initPanel() {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                JTextPane jTextPane = new JTextPane();
                jTextPane.setEditable(false);
                try {
                    jTextPane.setPage(this.getClass().getResource("/madkit/pluginmanager/gpl.html"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.setViewportView(jTextPane);
                jPanel.add((Component)jScrollPane, "Center");
                this._panel = jPanel;
            }

            public URL getHelpURL() {
                return this.getClass().getResource("help-license.html");
            }
        });
        this._index.addInstallStep(new InstallStep(2, "installdir", "Select install Directory"){
            File dir;
            private JTextField _installDir;
            {
                this.dir = null;
            }

            public void initPanel() {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)new JLabel("Select the Directory where you want to install Madkit"), "North");
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.weightx = 0.1;
                this._installDir = new JTextField();
                this._installDir.setEditable(false);
                jPanel2.add((Component)this._installDir, gridBagConstraints);
                JButton jButton = new JButton("Browse");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                        jFileChooser.setFileSelectionMode(1);
                        int n = jFileChooser.showOpenDialog(new JFrame());
                        if (n == 0) {
                            dir = jFileChooser.getSelectedFile();
                            if (dir != null) {
                                if (!dir.exists()) {
                                    int n2 = JOptionPane.showConfirmDialog(PluginInstaller.this, "The Selected Directory does not exists. Do you want to create it?", "Create Directory", 0);
                                    if (n2 == 0) {
                                        dir.mkdirs();
                                    } else {
                                        dir = null;
                                        return;
                                    }
                                }
                                if (!dir.canWrite()) {
                                    JOptionPane.showMessageDialog(PluginInstaller.this, "Can't write in the selected directory", "Can not Write", 0);
                                    dir = null;
                                } else {
                                    _installDir.setText(dir.getAbsolutePath());
                                    _installDir.setEditable(false);
                                    PluginInstaller.this._context.put("madkitDir", dir.getAbsoluteFile());
                                }
                            }
                        }
                        PluginInstaller.this.checkNextEnable();
                    }
                });
                jPanel2.add(jButton);
                jPanel.add((Component)jPanel2, "Center");
                this._panel = jPanel;
            }

            public boolean isStepFinished() {
                return this.dir != null;
            }

            public URL getHelpURL() {
                return this.getClass().getResource("help-madkitdir.html");
            }
        });
        this._index.addInstallStep(new InstallStep(3, "installfrom", "Select install Source"){

            public void initPanel() {
                this._panel = new JPanel();
                this._panel.setLayout(new FlowLayout(0));
                PluginInstaller.this._context.put("installSource", new Boolean(true));
                JRadioButton jRadioButton = new JRadioButton("Install from Internet (Recommended)", true);
                jRadioButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PluginInstaller.this._context.put("installSource", new Boolean(true));
                    }
                });
                JRadioButton jRadioButton2 = new JRadioButton("Install from Local File", false);
                jRadioButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PluginInstaller.this._context.put("installSource", new Boolean(false));
                    }
                });
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(jRadioButton);
                buttonGroup.add(jRadioButton2);
                this._panel.add(jRadioButton);
                this._panel.add(new JLabel("<html>Downloads the latests version from http://www.madkit.net/plugins <br> Requires an Internet Connection</html>"));
                this._panel.add(jRadioButton2);
                this._panel.add(new JLabel("<html>Installs the plugins from a local file<br>You have to download the zip bundle from http://www.madkit.org</html>"));
            }

            public URL getHelpURL() {
                return this.getClass().getResource("help-source.html");
            }
        });
        this._index.addInstallStep(new InstallStep(4, "installconfig", "Configure Installation"){
            JPanel config;
            boolean inet;
            Properties _props;
            JTextField _username;
            JTextField _email;
            {
                this.config = new JPanel();
                this._props = new Properties();
            }

            public void initPanel() {
                this._panel = new JPanel();
                this._panel.setLayout(new GridLayout(2, 1));
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout(0));
                jPanel.setBorder(new TitledBorder("Install Type"));
                PluginInstaller.this._context.put("installType", new Boolean(true));
                jPanel.setLayout(new FlowLayout(0));
                JRadioButton jRadioButton = new JRadioButton("Full Install", true);
                jRadioButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PluginInstaller.this._context.put("installType", new Boolean(true));
                    }
                });
                JRadioButton jRadioButton2 = new JRadioButton("Custom Install");
                jRadioButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PluginInstaller.this._context.put("installType", new Boolean(false));
                    }
                });
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(jRadioButton);
                buttonGroup.add(jRadioButton2);
                jPanel.add(jRadioButton);
                jPanel.add(new JLabel("Installs all Madkit Plugins, including sources and Documentation"));
                jPanel.add(jRadioButton2);
                jPanel.add(new JLabel("Lets you select the plugins to install"));
                this._panel.add(jPanel);
                this.config.setBorder(new TitledBorder("Install Source"));
                this._panel.add(this.config);
            }

            public void activate() {
                this.inet = (Boolean)PluginInstaller.this._context.get("installSource");
                this.config.removeAll();
                if (this.inet) {
                    this.config.setLayout(new GridLayout(4, 2));
                    JTextField jTextField = new JTextField("http://www.madkit.net/plugins");
                    jTextField.setEditable(false);
                    PluginInstaller.this._context.put("inetSource", "http://www.madkit.net/plugins");
                    this.config.add(new JLabel("Download Server"));
                    this.config.add(jTextField);
                    JLabel jLabel = new JLabel("Name");
                    this.config.add(jLabel);
                    this._username = new JTextField();
                    this._username.setText(this._props.getProperty("madkit.user.name", ""));
                    this._username.addKeyListener(new KeyListener(){

                        public void keyPressed(KeyEvent keyEvent) {
                        }

                        public void keyReleased(KeyEvent keyEvent) {
                            _props.put("madkit.user.name", _username.getText());
                            PluginInstaller.this.checkNextEnable();
                        }

                        public void keyTyped(KeyEvent keyEvent) {
                        }
                    });
                    this.config.add(this._username);
                    this.config.add(new JLabel("Email"));
                    this._email = new JTextField();
                    this._email.setText(this._props.getProperty("madkit.user.email", ""));
                    this._email.addKeyListener(new KeyListener(){

                        public void keyPressed(KeyEvent keyEvent) {
                        }

                        public void keyReleased(KeyEvent keyEvent) {
                            _props.put("madkit.user.email", _email.getText());
                            PluginInstaller.this.checkNextEnable();
                        }

                        public void keyTyped(KeyEvent keyEvent) {
                        }
                    });
                    this.config.add(this._email);
                    JButton jButton = new JButton("Set Proxy");
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SettingsFrame settingsFrame = new SettingsFrame();
                            int n = settingsFrame.showSettings(_props);
                            if (n == 0) {
                                _props = settingsFrame.getSelectedConfig();
                            }
                            PluginInstaller.this.checkNextEnable();
                        }
                    });
                    this.config.add(jButton);
                } else {
                    this.config.setLayout(new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    final JTextField jTextField = new JTextField();
                    jTextField.setEditable(false);
                    if (PluginInstaller.this._context.get("localFile") != null) {
                        jTextField.setText(PluginInstaller.this._context.get("localFile").toString());
                    }
                    this.config.add(new JLabel("Select Madkit's bundle file"));
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.gridwidth = 3;
                    gridBagConstraints.weightx = 0.1;
                    this.config.add((Component)jTextField, gridBagConstraints);
                    JButton jButton = new JButton("Browse");
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            File file;
                            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                            jFileChooser.setFileSelectionMode(0);
                            int n = jFileChooser.showOpenDialog(new JFrame());
                            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                                if (!file.canRead()) {
                                    JOptionPane.showMessageDialog(PluginInstaller.this, "Can't read in the selected File", "Can not Read", 0);
                                    file = null;
                                } else {
                                    jTextField.setText(file.getAbsolutePath());
                                    jTextField.setEditable(false);
                                    PluginInstaller.this._context.put("localFile", file.getAbsoluteFile());
                                }
                            }
                            PluginInstaller.this.checkNextEnable();
                        }
                    });
                    this.config.add(jButton);
                }
            }

            public URL getHelpURL() {
                return this.getClass().getResource("help-type.html");
            }

            public void end() {
                PluginInstaller.this._context.put("config", this._props);
            }

            public boolean isStepFinished() {
                if (this.inet) {
                    if (this._props == null) {
                        return false;
                    }
                    String string = this._props.getProperty("madkit.user.name");
                    if (string == null || string.equals("")) {
                        return false;
                    }
                    String string2 = this._props.getProperty("madkit.user.email");
                    if (string2 == null || string2.equals("")) {
                        return false;
                    }
                    if (string2.indexOf(64) < 0) {
                        this.setWarningMessage("A valid email address is required");
                        return false;
                    }
                    this.setWarningMessage(null);
                    return true;
                }
                File file = (File)PluginInstaller.this._context.get("localFile");
                return file != null && file.canRead();
            }
        });
        this._index.addInstallStep(new InstallStep(5, "done", "Install"){
            JLabel label;
            URL help;
            {
                this.label = new JLabel();
            }

            public void initPanel() {
                this._panel = new JPanel();
                this._panel.add(this.label);
            }

            public void activate() {
                boolean bl = (Boolean)PluginInstaller.this._context.get("installSource");
                boolean bl2 = (Boolean)PluginInstaller.this._context.get("installType");
                String string = "<html>Summary <br><hr>";
                string = string + "Install Directory: <b>" + PluginInstaller.this._context.get("madkitDir") + "</b><br>";
                string = string + "Install Source: <b>" + (bl ? "Internet</b> (" + PluginInstaller.this._context.get("inetSource") + ")" : "Local File</b>") + "<br>";
                string = string + "Install: <b>" + (bl2 ? "Full" : "Custom") + "</b><br>";
                string = string + "<br><br>";
                if (!bl2) {
                    string = string + "<hr>You selected a custom install, to select the plugins click <b>Launch Plugin Manager</b><br>Click <b>Help</b> for futher information";
                    this.help = this.getClass().getResource("help-finish-custom.html");
                } else {
                    string = string + "<hr>You selected a Full Madkit Install, click <b>Install</b>";
                    this.help = this.getClass().getResource("help-finish-full.html");
                }
                string = string + "</html>";
                this.label.setFont(new Font("Serial", 0, 12));
                this.label.setText(string);
            }

            public URL getHelpURL() {
                return this.help;
            }

            public void end() {
                System.out.println("Launching Manager");
                System.out.println("_context:" + PluginInstaller.this._context);
                File file = (File)PluginInstaller.this._context.get("madkitDir");
                boolean bl = (Boolean)PluginInstaller.this._context.get("installSource");
                boolean bl2 = (Boolean)PluginInstaller.this._context.get("installType");
                File file2 = (File)PluginInstaller.this._context.get("localFile");
                Object v = PluginInstaller.this._context.get("inetSource");
                String string = v == null ? null : v.toString();
                ManagerAgent managerAgent = new ManagerAgent(file, (Properties)PluginInstaller.this._context.get("config"));
                if (bl) {
                    managerAgent.setDownloadSource(string);
                } else {
                    try {
                        managerAgent.installFromBigLocalDistribution(file2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (bl2) {
                    managerAgent.setFullInstallRequest();
                }
                if (!bl && bl2) {
                    try {
                        PluginInstaller.this._kernel.launchAgent((AbstractAgent)managerAgent, "PluginManagerAgent", (Object)PluginInstaller.this._kernel, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    try {
                        PluginInstaller.this._kernel.launchAgent((AbstractAgent)managerAgent, "PluginManagerAgent", (Object)PluginInstaller.this._kernel, true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (bl) {
                    managerAgent.refreshPluginsFromSources();
                }
                PluginInstaller.this._btnNext.setEnabled(false);
                if (!bl && bl2) {
                    AgentAddress agentAddress = managerAgent.getAddress();
                    managerAgent.sendMessage(agentAddress, new SelectedPluginMessage("madkit-full"));
                    managerAgent.sendMessage(agentAddress, (Message)new StringMessage("startInstall"));
                }
                System.out.println("Installation starts, please wait...");
            }
        });
        this._index.init();
    }

    private void next() {
        InstallStep installStep = this._index.getCurrentStep();
        if (installStep.isStepFinished()) {
            installStep.end();
            this._index.next();
            if (this._index.isLastStep()) {
                if (((Boolean)this._context.get("installType")).booleanValue()) {
                    this._btnNext.setText("Install");
                } else {
                    this._btnNext.setText("Launch Plugin Manager");
                }
            }
            installStep = this._index.getCurrentStep();
            this.checkNextEnable();
            CardLayout cardLayout = (CardLayout)this.cards.getLayout();
            cardLayout.show(this.cards, installStep.getName());
            if (this._help != null) {
                this._help.setPage(installStep.getHelpURL());
            }
        }
    }

    private void checkNextEnable() {
        InstallStep installStep = this._index.getCurrentStep();
        if (installStep.isStepFinished()) {
            this._btnNext.setEnabled(true);
        } else {
            this._btnNext.setEnabled(false);
        }
    }

    private void back() {
        InstallStep installStep = this._index.getCurrentStep();
        if (this._index.isLastStep()) {
            this._btnNext.setText("Next >");
        }
        this._index.back();
        installStep = this._index.getCurrentStep();
        if (installStep.isStepFinished()) {
            this._btnNext.setEnabled(true);
        } else {
            this._btnNext.setEnabled(false);
        }
        CardLayout cardLayout = (CardLayout)this.cards.getLayout();
        cardLayout.show(this.cards, installStep.getName());
        if (this._help != null) {
            this._help.setPage(installStep.getHelpURL());
        }
    }

    private void informFailureAndExit() {
        JOptionPane.showMessageDialog(new JFrame(), "Starting the Plugin Installer failed", "Error", 0);
        System.exit(-1);
    }

    private File askInstallDir() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(new JFrame());
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new PluginInstaller(null);
    }

    public void setupGUI(AbstractAgent abstractAgent) {
        abstractAgent.initGUI();
        Object object = abstractAgent.getGUIObject();
        if (object != null && object instanceof Component) {
            if (this._guis == null) {
                this._guis = new Hashtable();
            }
            JFrame jFrame = new JFrame();
            jFrame.setSize(400, 500);
            jFrame.setTitle(abstractAgent.getName());
            jFrame.getContentPane().add((Component)object);
            URL uRL = this.getClass().getResource("/images/madkit_logo32.gif");
            if (uRL != null) {
                jFrame.setIconImage(new ImageIcon(uRL).getImage());
            }
            this._guis.put(abstractAgent, jFrame);
            jFrame.show();
        }
    }

    public void setupGUI(AbstractAgent abstractAgent, Point point, Dimension dimension) {
        this.setupGUI(abstractAgent);
    }

    public void disposeGUI(AbstractAgent abstractAgent) {
        this.disposeGUIImmediatly(abstractAgent);
    }

    public void disposeGUIImmediatly(AbstractAgent abstractAgent) {
        JFrame jFrame = (JFrame)this._guis.get(abstractAgent);
        if (jFrame != null) {
            jFrame.dispose();
        }
    }

    public Object getDefaultGUIObject(AbstractAgent abstractAgent) {
        return System.out;
    }
}

