/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import madkit.pluginmanager.Dependency;
import madkit.pluginmanager.DetailsAgent;
import madkit.pluginmanager.PluginInformation;

class DetailsGUI
extends JPanel {
    private final DetailsAgent _agent;

    public DetailsGUI(DetailsAgent detailsAgent) {
        this._agent = detailsAgent;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Select");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailsGUI.this._agent.informSelection();
            }
        });
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailsGUI.this._agent.disposeMyGUI();
                ((DetailsGUI)DetailsGUI.this)._agent._alive = false;
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.add((Component)jPanel, "South");
        String string = this.formatDetails();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKit(new HTMLEditorKit());
        jEditorPane.setEditable(false);
        jEditorPane.setText(string);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jEditorPane);
        this.add((Component)jScrollPane, "Center");
        this.setSize(300, 300);
    }

    private String formatDetails() {
        PluginInformation pluginInformation = this._agent.getPluginInformation();
        if (pluginInformation == null) {
            String string = "<html><body>";
            string = string + "<font color=red > No Plugin Information available. <br> May be a parse error. <br> Please report this to the server Maintaner</font>";
            string = string + "</body></html>";
            return string;
        }
        String string = "<html><body>";
        string = string + "<b>Name:</b>" + pluginInformation.getName() + "<br>";
        string = string + "<b>Version:</b> " + pluginInformation.getVersion().toString();
        string = string + "<br>";
        string = string + "<b>Author:</b><br>" + pluginInformation.getAuthorName() + "<br>" + pluginInformation.getAuthorEmail() + "<br>" + pluginInformation.getAuthorWeb() + "<br>";
        if (pluginInformation.getFileName() != null) {
            string = string + "<br><b>File:</b> " + pluginInformation.getFileName() + "<br>";
            string = string + "<b>Size</b> " + pluginInformation.getSize() + "<br>";
        } else {
            string = string + "<br><b>File:</b> None <br>";
        }
        string = string + "<br><b>Depends: </b><br>";
        for (Dependency dependency : pluginInformation.getDependencies()) {
            string = string + dependency.name + " ( " + dependency.version.toString() + " ) <br>";
        }
        string = string + "<b><br>Description</b>";
        string = string + "<p>";
        string = string + pluginInformation.getDescription();
        string = string + "</p>";
        string = string + "</body></html>";
        return string;
    }
}

