/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import warbot.kernel.Brain;
import warbot.kernel.Food;
import warbot.kernel.Percept;

public class HomeKiller
extends Brain {
    String groupName = "warbot-";
    String roleName = "launcher";
    int waitingForRocket = 0;
    int waitingMax = 3;

    public void activate() {
        this.groupName = this.groupName + this.getTeam();
        this.randomHeading();
        this.println("I am a home killer robot");
        this.createGroup(false, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
        this.requestRole(this.groupName, "mobile", null);
    }

    void decrWaitingForRocket() {
        --this.waitingForRocket;
        if (this.waitingForRocket < 0) {
            this.waitingForRocket = 0;
        }
    }

    public void doIt() {
        Percept percept;
        int n;
        Percept[] perceptArray;
        this.decrWaitingForRocket();
        if (!this.isMoving()) {
            this.randomHeading();
        }
        if ((perceptArray = this.getPercepts()).length > 0) {
            n = 0;
            while (n < perceptArray.length) {
                Percept percept2 = perceptArray[n];
                if (percept2.getPerceptType().equals("Home") && !percept2.getTeam().equals(this.getTeam())) {
                    this.launchRocket(this.towards(percept2.getX(), percept2.getY()));
                    this.setHeading(this.towards(percept2.getX(), percept2.getY()));
                    this.waitingForRocket = this.waitingMax;
                    return;
                }
                if ((percept2.getPerceptType().equals("RocketLauncher") || percept2.getPerceptType().equals("Explorer")) && this.waitingForRocket <= 0 && !percept2.getTeam().equals(this.getTeam())) {
                    this.launchRocket(this.towards(percept2.getX(), percept2.getY()));
                    this.waitingForRocket = this.waitingMax;
                    return;
                }
                ++n;
            }
        }
        n = 0;
        int n2 = 0;
        while (n2 < perceptArray.length) {
            percept = perceptArray[n2];
            if (this.distanceTo(percept) < this.distanceTo(perceptArray[n]) && percept.getPerceptType().equals("Food")) {
                n = n2;
            }
            ++n2;
        }
        if (perceptArray.length > 0 && perceptArray[n].getPerceptType().equals("Food")) {
            if (this.distanceTo(perceptArray[n]) < 2.0) {
                this.eat((Food)perceptArray[n]);
                return;
            }
            this.setHeading(this.towards(perceptArray[n].getX(), perceptArray[n].getY()));
            this.move();
            return;
        }
        percept = null;
        Percept percept3 = null;
        while ((percept = this.readMessage()) != null) {
            percept3 = percept;
        }
        if (percept3 != null) {
            String string = percept3.getAct();
            if (string.equals("homeposition")) {
                double d = percept3.getFromX();
                double d2 = percept3.getFromY();
                this.setHeading(this.towards(d, d2));
            } else if (string.equals("help")) {
                double d = percept3.getFromX();
                double d3 = percept3.getFromY();
                this.setHeading(this.towards(d, d3));
            }
        }
        this.move();
    }
}

