/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktopbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import madkit.desktopbar.DesktopBar;

public class ButtonBar
extends JToggleButton
implements ActionListener,
InternalFrameListener,
MouseListener {
    Component component;
    boolean visible;
    Color defaultColor;
    DesktopBar dBar;
    JPopupMenu popupMenu;
    JMenuItem reduce;
    JMenuItem enlarge;
    JMenuItem close;
    JMenuItem restore;

    public ButtonBar(DesktopBar desktopBar, Component component, String string) {
        super(string);
        this.component = component;
        this.addActionListener(this);
        this.dBar = desktopBar;
        this.visible = true;
        this.defaultColor = this.getBackground();
        if (component instanceof JInternalFrame) {
            this.addMouseListener(this);
            this.popupMenu = new JPopupMenu();
            this.restore = this.popupMenu.add("Restore");
            this.restore.addActionListener(this);
            this.reduce = this.popupMenu.add("Reduce");
            this.reduce.addActionListener(this);
            this.enlarge = this.popupMenu.add("Enlarge");
            this.enlarge.addActionListener(this);
            this.popupMenu.addSeparator();
            this.close = this.popupMenu.add("Close");
            this.close.addActionListener(this);
            ((JInternalFrame)component).addInternalFrameListener(this);
        }
    }

    protected void setActive(boolean bl) {
        if (bl) {
            this.setBackground(Color.ORANGE);
            this.setSelected(true);
        } else {
            this.setBackground(this.defaultColor);
            this.setSelected(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.component instanceof JInternalFrame) {
            JInternalFrame jInternalFrame = (JInternalFrame)this.component;
            Object object = actionEvent.getSource();
            if (object == this.close) {
                jInternalFrame.doDefaultCloseAction();
            } else if (object == this.enlarge) {
                try {
                    jInternalFrame.setMaximum(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else if (object == this.reduce) {
                try {
                    jInternalFrame.setIcon(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else if (object == this.restore) {
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                } else {
                    try {
                        jInternalFrame.setMaximum(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            } else if (!jInternalFrame.isVisible()) {
                try {
                    jInternalFrame.setIcon(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else if (jInternalFrame.isSelected()) {
                try {
                    jInternalFrame.setIcon(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else {
                try {
                    jInternalFrame.setSelected(true);
                    this.dBar.activeButton(this);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(80, 20);
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.dBar.activeButton(this);
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.dBar.removeButton(this);
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        try {
            ((JInternalFrame)this.component).setIcon(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        ((JInternalFrame)this.component).show();
        this.dBar.activeButton(this);
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        ((JInternalFrame)this.component).hide();
        this.setActive(false);
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        this.setActive(false);
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            if (this.component instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)this.component;
                try {
                    jInternalFrame.setSelected(true);
                    this.dBar.activeButton(this);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
            if (((JInternalFrame)this.component).isMaximum() || ((JInternalFrame)this.component).isIcon()) {
                this.restore.setEnabled(true);
            } else {
                this.restore.setEnabled(false);
            }
            if (((JInternalFrame)this.component).isIcon()) {
                this.reduce.setEnabled(false);
            } else {
                this.reduce.setEnabled(true);
            }
            if (((JInternalFrame)this.component).isMaximum()) {
                this.enlarge.setEnabled(false);
            } else {
                this.enlarge.setEnabled(true);
            }
            if (this.dBar.getOrientation().equals("South")) {
                this.popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY() - (int)this.popupMenu.getPreferredSize().getHeight());
            } else if (this.dBar.getOrientation().equals("East")) {
                this.popupMenu.show(this, mouseEvent.getX() - (int)this.popupMenu.getPreferredSize().getWidth(), mouseEvent.getY());
            } else if (this.dBar.getOrientation().equals("North")) {
                this.popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else if (this.dBar.getOrientation().equals("West")) {
                this.popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addMenuItem(JMenuItem jMenuItem) {
        this.popupMenu.add(jMenuItem);
    }

    public void addSeparator() {
        this.popupMenu.addSeparator();
    }

    public void removeMenuItem(JMenuItem jMenuItem) {
        this.popupMenu.remove(jMenuItem);
    }
}

