/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktop2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import madkit.desktop2.ImageViewer;
import madkit.desktop2.Miniature;
import madkit.desktop2.RessourceBrowser;
import madkit.desktop2.RessourceInfo;

class Images
extends JPanel
implements MouseListener,
KeyListener {
    protected LinkedList listMiniature;
    protected LinkedList changeListeners;
    protected Miniature currentMiniature;
    protected int margeX;
    protected int margeY;
    protected int iconSize;
    protected ImageViewer imageViewer;

    public Images(ImageViewer imageViewer) {
        super(new BorderLayout());
        this.addMouseListener(this);
        this.imageViewer = imageViewer;
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(".png");
        linkedList.add(".gif");
        linkedList.add(".jpg");
        this.init(linkedList, 96);
    }

    public Images(ImageViewer imageViewer, LinkedList linkedList, int n) {
        super(new BorderLayout());
        this.imageViewer = imageViewer;
        this.init(linkedList, n);
    }

    public boolean isFocusable() {
        return true;
    }

    protected void init(LinkedList linkedList, int n) {
        this.setBackground(Color.white);
        this.iconSize = n;
        this.addKeyListener(this);
        this.listMiniature = new LinkedList();
        this.changeListeners = new LinkedList();
        this.margeX = 10;
        this.margeY = 10;
        RessourceBrowser ressourceBrowser = new RessourceBrowser();
        LinkedList linkedList2 = ressourceBrowser.browseForRessourceEndWith(linkedList);
        for (RessourceInfo ressourceInfo : linkedList2) {
            this.listMiniature.add(new Miniature(ressourceInfo, n));
        }
    }

    public Dimension getPreferredSize() {
        int n = (int)(this.getSize().getWidth() / (double)(this.iconSize + 2 * this.margeX));
        if (n < 1) {
            n = 1;
        }
        return new Dimension(this.iconSize + 2 * this.margeX, (int)(Math.ceil((float)this.listMiniature.size() / (float)n) * (double)(this.iconSize + 2 * this.margeY)));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = (int)(this.getSize().getWidth() / (double)(this.iconSize + 2 * this.margeX));
        if (n < 1) {
            n = 1;
        }
        int n2 = this.margeX;
        int n3 = this.margeY;
        int n4 = 0;
        for (Miniature miniature : this.listMiniature) {
            boolean bl = miniature == this.currentMiniature ? graphics.hitClip(n2 - 1, n3 - 1, this.iconSize + 2, this.iconSize + 2) : graphics.hitClip(n2, n3, this.iconSize, this.iconSize);
            if (bl) {
                miniature.paint(graphics, n2, n3);
            }
            if ((n4 + 1) % n == 0) {
                n2 = this.margeX;
                n3 += this.margeY * 2 + this.iconSize;
            } else {
                n2 += this.margeX * 2 + this.iconSize;
            }
            ++n4;
        }
    }

    public RessourceInfo getSelectedRessource() {
        if (this.currentMiniature != null) {
            return this.currentMiniature.getRessource();
        }
        return null;
    }

    public Dimension getIconDimension() {
        return this.currentMiniature.getIconDimension();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.currentMiniature != null) {
            this.currentMiniature.setSelected(false);
            this.currentMiniature = null;
        }
        if ((n6 = (int)((float)(n5 = mouseEvent.getX()) / (float)(n4 = 2 * this.margeX + this.iconSize))) * n4 + this.margeX < n5 && n5 < (n6 + 1) * n4 - this.margeX && (n3 = (int)((float)(n2 = mouseEvent.getY()) / (float)(n = 2 * this.margeY + this.iconSize))) * n + this.margeY < n2 && n2 < (n3 + 1) * n - this.margeY) {
            int n7;
            int n8 = (int)(this.getSize().getWidth() / (double)(this.iconSize + 2 * this.margeX));
            if (n8 < 1) {
                n8 = 1;
            }
            if ((n7 = n3 * n8 + n6) < this.listMiniature.size()) {
                this.currentMiniature = (Miniature)this.listMiniature.get(n7);
                this.currentMiniature.setSelected(true);
            }
        }
        this.repaint();
        this.onChange();
    }

    protected void onChange() {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(new ChangeEvent(this.imageViewer));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void setSelectedIcon(String string) {
        for (Miniature miniature : this.listMiniature) {
            String string2 = miniature.getRessource().getResourceName();
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if (!string2.equals(string)) continue;
            if (this.currentMiniature != null) {
                this.currentMiniature.setSelected(false);
                this.currentMiniature = null;
            }
            this.currentMiniature = miniature;
            miniature.setSelected(true);
            if (this.getSize().getWidth() > 0.0) {
                this.scrollToCurrentMiniature();
            }
            this.onChange();
            return;
        }
    }

    public void scrollToCurrentMiniature() {
        if (this.currentMiniature != null) {
            int n = (int)(this.getSize().getWidth() / (double)(this.iconSize + 2 * this.margeX));
            if (n < 1) {
                n = 1;
            }
            int n2 = 2 * this.margeY + this.iconSize;
            int n3 = (int)((float)this.listMiniature.indexOf(this.currentMiniature) / (float)n) * n2;
            this.scrollRectToVisible(new Rectangle(0, n3, 1, n2));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.listMiniature.indexOf(this.currentMiniature);
        int n3 = (int)(this.getSize().getWidth() / (double)(this.iconSize + 2 * this.margeX));
        if (n3 < 1) {
            n3 = 1;
        }
        if (this.currentMiniature == null && (n == 40 || n == 37 || n == 39 || n == 38)) {
            this.currentMiniature = (Miniature)this.listMiniature.getFirst();
            if (this.currentMiniature != null) {
                this.currentMiniature.setSelected(true);
                this.scrollToCurrentMiniature();
                this.repaint();
                this.onChange();
            }
        } else if (this.currentMiniature != null) {
            if (n == 40) {
                this.currentMiniature.setSelected(false);
                this.currentMiniature = n2 + n3 < this.listMiniature.size() - 1 ? (Miniature)this.listMiniature.get(n2 + n3) : (Miniature)this.listMiniature.get(this.listMiniature.size() - 1);
                this.currentMiniature.setSelected(true);
                this.scrollToCurrentMiniature();
                this.repaint();
                this.onChange();
            } else if (n == 38) {
                this.currentMiniature.setSelected(false);
                this.currentMiniature = n2 - n3 > 0 ? (Miniature)this.listMiniature.get(n2 - n3) : (Miniature)this.listMiniature.get(0);
                this.currentMiniature.setSelected(true);
                this.scrollToCurrentMiniature();
                this.repaint();
                this.onChange();
            } else if (n == 37) {
                if (n2 > 0) {
                    this.currentMiniature.setSelected(false);
                    this.currentMiniature = (Miniature)this.listMiniature.get(n2 - 1);
                    this.currentMiniature.setSelected(true);
                    this.scrollToCurrentMiniature();
                    this.repaint();
                    this.onChange();
                }
            } else if (n == 39 && n2 < this.listMiniature.size() - 1) {
                this.currentMiniature.setSelected(false);
                this.currentMiniature = (Miniature)this.listMiniature.get(n2 + 1);
                this.currentMiniature.setSelected(true);
                this.scrollToCurrentMiniature();
                this.repaint();
                this.onChange();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

