/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktop2;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import madkit.boot.Madkit;
import madkit.boot.MadkitClassLoader;
import madkit.desktop2.AboutDialog;
import madkit.desktop2.AgentInfo;
import madkit.desktop2.BeanShellAgentButton;
import madkit.desktop2.Desktop;
import madkit.desktop2.DesktopAgent;
import madkit.desktop2.DesktopBooter;
import madkit.desktop2.DesktopInfo;
import madkit.desktop2.IconInfo;
import madkit.desktop2.JMenuItemDesktop;
import madkit.desktop2.JMenuItemForAgent;
import madkit.desktop2.JavaAgentButton;
import madkit.desktop2.JessAgentButton;
import madkit.desktop2.MenuInfo;
import madkit.desktop2.MenuItemInfo;
import madkit.desktop2.PropertyDesktop;
import madkit.desktop2.PythonAgentButton;
import madkit.desktop2.QuitDialog;
import madkit.desktop2.SEditFileButton;
import madkit.desktop2.SEditFormalismButton;
import madkit.desktop2.SchemeAgentButton;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AbstractMadkitBooter;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DesktopAgentGUI
implements ActionListener {
    public static final String DESKTOPINITFILE = "desktop.ini";
    protected AgentInfo ai;
    protected HashMap components;
    protected LinkedList iconInfos;
    protected LinkedList menuInfos;
    protected LinkedList desktopMenuItem;
    protected Desktop desktop;
    protected JMenu menuSelectDesktop;
    protected JMenuItem stop;
    protected JMenuItem exec;
    protected JMenuItem about;
    protected JMenuItemDesktop currentDesktop;
    protected PropertyDesktop propertyDesktop;
    protected boolean saveIni;
    protected boolean saveConfig;
    protected final String defaultConfigPath = System.getProperties().get("madkit.dir") + File.separator + "bin" + File.separator + "configs" + File.separator;

    public DesktopAgentGUI(DesktopAgent desktopAgent) {
        this.ai = new AgentInfo((AbstractAgent)desktopAgent);
        this.components = new HashMap();
        this.iconInfos = new LinkedList();
        this.menuInfos = new LinkedList();
        this.desktopMenuItem = new LinkedList();
        this.propertyDesktop = new PropertyDesktop();
        this.readIniFile();
        this.createMenuSystem();
        if (this.currentDesktop != null) {
            if (!this.createDesktop(this.currentDesktop.getClassName())) {
                System.exit(0);
            }
        } else {
            if (!this.createDesktop("madkit.desktop2.DesktopWithContainer")) {
                System.exit(0);
            }
            for (int i = 0; i < this.menuSelectDesktop.getMenuComponentCount(); ++i) {
                Component component = this.menuSelectDesktop.getMenuComponent(i);
                if (!(component instanceof JMenuItemDesktop)) continue;
                if (((JMenuItemDesktop)component).getClassName().equals("madkit.desktop2.DesktopWithContainer")) {
                    this.currentDesktop = (JMenuItemDesktop)component;
                }
                this.currentDesktop.setSelected(true);
            }
        }
    }

    public void init() {
        this.desktop.show();
        DesktopBooter.getBooter().loadConfigFile(new File(this.defaultConfigPath + "Desktop2Config.cfg"));
    }

    protected void createMenuSystem() {
        this.menuSelectDesktop = new JMenu("Select your desktop");
        for (DesktopInfo desktopInfo : this.desktopMenuItem) {
            JMenuItemDesktop jMenuItemDesktop = desktopInfo.getIcon() != null && !desktopInfo.getIcon().equals("") ? new JMenuItemDesktop(desktopInfo.getName(), new ImageIcon(desktopInfo.getIcon())) : new JMenuItemDesktop(desktopInfo.getName());
            jMenuItemDesktop.setClassName(desktopInfo.getCode());
            jMenuItemDesktop.setToolTipText(desktopInfo.getDescription());
            jMenuItemDesktop.addActionListener(this);
            if (this.currentDesktop == null && desktopInfo.getDefault() != null && desktopInfo.getDefault().equalsIgnoreCase("true")) {
                this.currentDesktop = jMenuItemDesktop;
            }
            this.menuSelectDesktop.add(jMenuItemDesktop);
        }
        if (this.currentDesktop != null) {
            this.currentDesktop.setSelected(true);
        }
        this.exec = new JMenuItem("Execute script file...");
        this.exec.addActionListener(this);
        this.about = new JMenuItem("About...");
        this.about.addActionListener(this);
        this.stop = new JMenuItem("Stop Madkit");
        this.stop.addActionListener(this);
    }

    public void saveConfigFile(boolean bl) {
        if (bl) {
            try {
                Object object;
                AgentInfo agentInfo2;
                Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement("config");
                for (AgentInfo agentInfo2 : this.components.values()) {
                    if (agentInfo2 == null || agentInfo2.getAgent() == null) continue;
                    object = document.createElement("launch-agent");
                    object.setAttribute("name", agentInfo2.getAgent().getName());
                    object.setAttribute("type", "Java");
                    object.setAttribute("code", agentInfo2.getAgent().getClass().getName());
                    object.setAttribute("X", String.valueOf((int)agentInfo2.getLocation().getX()));
                    object.setAttribute("Y", String.valueOf((int)agentInfo2.getLocation().getY()));
                    object.setAttribute("height", String.valueOf((int)agentInfo2.getSize().getHeight()));
                    object.setAttribute("width", String.valueOf((int)agentInfo2.getSize().getWidth()));
                    element.appendChild((Node)object);
                }
                document.appendChild(element);
                agentInfo2 = new OutputFormat(document);
                object = new FileWriter(this.defaultConfigPath + "Desktop2Config.cfg");
                agentInfo2.setIndenting(true);
                agentInfo2.setLineSeparator(System.getProperties().get("line.separator").toString());
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)object, (OutputFormat)agentInfo2);
                xMLSerializer.asDOMSerializer();
                xMLSerializer.serialize(document);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public void saveIniFile(boolean bl) {
        try {
            if (!bl) {
                Element element;
                Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().parse(new File(DESKTOPINITFILE));
                Element element2 = document.getDocumentElement();
                NodeList nodeList = element2.getElementsByTagName("PropertyDesktop");
                if (nodeList.getLength() > 0) {
                    element = (Element)nodeList.item(0);
                    element.setAttribute("saveIni", Boolean.toString(this.saveIni));
                    element.setAttribute("saveConfig", Boolean.toString(this.saveConfig));
                } else {
                    element = document.createElement("PropertyDesktop");
                    element.setAttribute("saveIni", Boolean.toString(this.saveIni));
                    element.setAttribute("saveConfig", Boolean.toString(this.saveConfig));
                    element2.appendChild(element);
                }
                element = new OutputFormat(document);
                FileWriter fileWriter = new FileWriter(DESKTOPINITFILE);
                element.setIndenting(true);
                element.setLineSeparator(System.getProperties().get("line.separator").toString());
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, (OutputFormat)element);
                xMLSerializer.asDOMSerializer();
                xMLSerializer.serialize(document);
            } else {
                Object object;
                Object object22;
                Object object3;
                Object object42;
                Object object5;
                Object object62;
                Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement("desktop");
                for (Object object62 : this.menuInfos) {
                    object5 = document.createElement("StartMenu");
                    object5.setAttribute("name", ((MenuInfo)object62).getName());
                    object5.setAttribute("icon", ((MenuInfo)object62).getIcon());
                    for (Object object42 : ((MenuInfo)object62).getMenuItemInfo()) {
                        object3 = document.createElement("button");
                        object3.setAttribute("name", ((MenuItemInfo)object42).getName());
                        object3.setAttribute("icon", ((MenuItemInfo)object42).getIcon());
                        object3.setAttribute("description", ((MenuItemInfo)object42).getDescription());
                        object3.setAttribute("type", ((MenuItemInfo)object42).getType());
                        object3.setAttribute("code", ((MenuItemInfo)object42).getCode());
                        object5.appendChild((Node)object3);
                    }
                    element.appendChild((Node)object5);
                }
                for (Object object62 : this.iconInfos) {
                    object5 = document.createElement("DesktopIcon");
                    object5.setAttribute("name", ((IconInfo)object62).getLabel());
                    object5.setAttribute("description", ((IconInfo)object62).getDescription());
                    object5.setAttribute("icon", ((IconInfo)object62).getIcon());
                    object5.setAttribute("type", ((IconInfo)object62).getType());
                    object5.setAttribute("code", ((IconInfo)object62).getCode());
                    object5.setAttribute("X", Integer.toString(((IconInfo)object62).getX()));
                    object5.setAttribute("Y", Integer.toString(((IconInfo)object62).getY()));
                    element.appendChild((Node)object5);
                }
                object62 = document.createElement("PropertyDesktop");
                object62.setAttribute("saveIni", Boolean.toString(this.saveIni));
                object62.setAttribute("saveConfig", Boolean.toString(this.saveConfig));
                if (this.propertyDesktop.getDesktopColor() != null) {
                    object5 = document.createElement("BackgroundColor");
                    object5.setAttribute("R", String.valueOf(this.propertyDesktop.getDesktopColor().getRed()));
                    object5.setAttribute("G", String.valueOf(this.propertyDesktop.getDesktopColor().getGreen()));
                    object5.setAttribute("B", String.valueOf(this.propertyDesktop.getDesktopColor().getBlue()));
                    object62.appendChild((Node)object5);
                }
                if (this.propertyDesktop.getWallpaperPath() != null && !this.propertyDesktop.getWallpaperPath().equals("")) {
                    object5 = document.createElement("Wallpaper");
                    object5.setAttribute("Path", this.propertyDesktop.getWallpaperPath());
                    object5.setAttribute("Position", this.propertyDesktop.getWallpaperPos());
                    object62.appendChild((Node)object5);
                }
                object5 = this.ai.getLocation();
                Dimension dimension = this.ai.getSize();
                if (((Point)object5).x >= 0 || ((Point)object5).y >= 0 || dimension.width >= 0 && dimension.height >= 0) {
                    object42 = document.createElement("Dimension");
                    if (((Point)object5).x >= 0) {
                        object42.setAttribute("X", "" + ((Point)object5).x);
                    }
                    if (((Point)object5).y >= 0) {
                        object42.setAttribute("Y", "" + ((Point)object5).y);
                    }
                    if (dimension.width >= 0) {
                        object42.setAttribute("width", "" + dimension.width);
                    }
                    if (dimension.height >= 0) {
                        object42.setAttribute("height", "" + dimension.height);
                    }
                    object62.appendChild((Node)object42);
                }
                if (this.propertyDesktop.getSkinUse()) {
                    object42 = document.createElement("skin");
                    object42.setAttribute("use", Boolean.toString(this.propertyDesktop.getSkinUse()));
                    object3 = this.propertyDesktop.getSkinTheme();
                    if (object3 == null) {
                        object3 = "themepack.zip";
                    }
                    object42.setAttribute("name", (String)object3);
                    object62.appendChild((Node)object42);
                }
                element.appendChild((Node)object62);
                object42 = "";
                for (int i = 0; i < this.menuSelectDesktop.getMenuComponentCount(); ++i) {
                    object22 = this.menuSelectDesktop.getMenuComponent(i);
                    if (this.currentDesktop != object22) continue;
                    object42 = this.currentDesktop.getClassName();
                }
                Element element3 = document.createElement("DesktopType");
                for (Object object22 : this.desktopMenuItem) {
                    object = document.createElement("DesktopClass");
                    object.setAttribute("name", ((DesktopInfo)object22).getName());
                    object.setAttribute("description", ((DesktopInfo)object22).getDescription());
                    object.setAttribute("icon", ((DesktopInfo)object22).getIcon());
                    object.setAttribute("code", ((DesktopInfo)object22).getCode());
                    System.out.println(((DesktopInfo)object22).getCode() + "  " + (String)object42);
                    if (((DesktopInfo)object22).getCode().equals(object42)) {
                        object.setAttribute("default", Boolean.toString(true));
                    } else {
                        object.setAttribute("default", Boolean.toString(false));
                    }
                    element3.appendChild((Node)object);
                }
                element.appendChild(element3);
                document.appendChild(element);
                object22 = new OutputFormat(document);
                object = new FileWriter(DESKTOPINITFILE);
                object22.setIndenting(true);
                object22.setLineSeparator(System.getProperties().get("line.separator").toString());
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)object, (OutputFormat)object22);
                xMLSerializer.asDOMSerializer();
                xMLSerializer.serialize(document);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected void readIniFile() {
        File file = new File(DESKTOPINITFILE);
        if (!file.exists()) {
            file = new File(this.defaultConfigPath + "defaultDesktop.ini");
        }
        if (file.exists()) {
            try {
                NodeList nodeList;
                Object object;
                Object object2;
                Object object3;
                int n;
                FileInputStream fileInputStream = new FileInputStream(file);
                Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().parse(fileInputStream);
                Element element = document.getDocumentElement();
                NodeList nodeList2 = element.getElementsByTagName("StartMenu");
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    object3 = (Element)nodeList2.item(n);
                    object2 = new MenuInfo();
                    ((MenuInfo)object2).setIcon(object3.getAttribute("icon"));
                    ((MenuInfo)object2).setName(object3.getAttribute("name"));
                    NodeList nodeList3 = object3.getElementsByTagName("button");
                    for (int i = 0; i < nodeList3.getLength(); ++i) {
                        object = (Element)nodeList3.item(i);
                        MenuItemInfo menuItemInfo = new MenuItemInfo();
                        menuItemInfo.setCode(object.getAttribute("code"));
                        menuItemInfo.setDescription(object.getAttribute("description"));
                        menuItemInfo.setIcon(object.getAttribute("icon"));
                        menuItemInfo.setName(object.getAttribute("name"));
                        menuItemInfo.setType(object.getAttribute("type"));
                        menuItemInfo.setGUI(object.getAttribute("gui"));
                        ((MenuInfo)object2).addMenuItemInfo(menuItemInfo);
                    }
                    this.menuInfos.add(object2);
                }
                NodeList nodeList4 = element.getElementsByTagName("DesktopIcon");
                for (n = 0; n < nodeList4.getLength(); ++n) {
                    object3 = (Element)nodeList4.item(n);
                    object2 = new IconInfo();
                    ((IconInfo)object2).setIcon(object3.getAttribute("icon"));
                    ((IconInfo)object2).setCode(object3.getAttribute("code"));
                    ((IconInfo)object2).setLabel(object3.getAttribute("name"));
                    ((IconInfo)object2).setDescription(object3.getAttribute("description"));
                    ((IconInfo)object2).setType(object3.getAttribute("type"));
                    ((IconInfo)object2).setGUI(object3.getAttribute("gui"));
                    String string = object3.getAttribute("X");
                    object = object3.getAttribute("Y");
                    int n2 = 0;
                    int n3 = 0;
                    if (string != null) {
                        n2 = Integer.parseInt(string);
                    }
                    if (object != null) {
                        n3 = Integer.parseInt((String)object);
                    }
                    ((IconInfo)object2).setX(n2);
                    ((IconInfo)object2).setY(n3);
                    this.iconInfos.add(object2);
                }
                NodeList nodeList5 = element.getElementsByTagName("DesktopType");
                if (nodeList5.getLength() > 0) {
                    NodeList nodeList6 = element.getElementsByTagName("DesktopClass");
                    for (n = 0; n < nodeList6.getLength(); ++n) {
                        object3 = (Element)nodeList6.item(n);
                        object2 = new DesktopInfo();
                        ((DesktopInfo)object2).setIcon(object3.getAttribute("icon"));
                        ((DesktopInfo)object2).setCode(object3.getAttribute("code"));
                        ((DesktopInfo)object2).setName(object3.getAttribute("name"));
                        ((DesktopInfo)object2).setDescription(object3.getAttribute("description"));
                        ((DesktopInfo)object2).setDefault(object3.getAttribute("default"));
                        this.desktopMenuItem.add(object2);
                    }
                }
                if ((nodeList = element.getElementsByTagName("PropertyDesktop")).getLength() > 0) {
                    Element element2 = (Element)nodeList.item(0);
                    object3 = element2.getAttribute("saveIni");
                    this.saveIni = object3 == null || ((String)object3).equals("") ? true : Boolean.valueOf((String)object3);
                    object3 = element2.getAttribute("saveConfig");
                    this.saveConfig = object3 == null || ((String)object3).equals("") ? false : Boolean.valueOf((String)object3);
                    NodeList nodeList7 = element2.getElementsByTagName("BackgroundColor");
                    if (nodeList7.getLength() > 0) {
                        object2 = (Element)nodeList7.item(0);
                        String string = object2.getAttribute("R");
                        object = object2.getAttribute("G");
                        String string2 = object2.getAttribute("B");
                        if (string != null && object != null && string2 != null) {
                            this.propertyDesktop.setDesktopColor(new Color(Integer.parseInt(string), Integer.parseInt((String)object), Integer.parseInt(string2)));
                        }
                    }
                    if ((nodeList7 = element2.getElementsByTagName("Wallpaper")).getLength() > 0) {
                        object2 = (Element)nodeList7.item(0);
                        String string = object2.getAttribute("Path");
                        object = object2.getAttribute("Position");
                        if (object != null) {
                            if (((String)object).equalsIgnoreCase("Center")) {
                                this.propertyDesktop.setWallpaperPos("Center");
                            } else if (((String)object).equalsIgnoreCase("Stretch")) {
                                this.propertyDesktop.setWallpaperPos("Stretch");
                            }
                        }
                        if (string != null) {
                            this.propertyDesktop.setWallpaperPath(string);
                        }
                    }
                    if ((nodeList7 = element2.getElementsByTagName("Dimension")).getLength() > 0) {
                        int n4 = -1;
                        int n5 = -1;
                        int n6 = -1;
                        int n7 = -1;
                        Element element3 = (Element)nodeList7.item(0);
                        String string = element3.getAttribute("X");
                        String string3 = element3.getAttribute("Y");
                        String string4 = element3.getAttribute("height");
                        String string5 = element3.getAttribute("width");
                        try {
                            n4 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            n5 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            n6 = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            n7 = Integer.parseInt(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        this.ai.setLocation(new Point(n4, n5));
                        this.ai.setSize(new Dimension(n7, n6));
                    }
                    if ((nodeList7 = element.getElementsByTagName("skin")).getLength() > 0) {
                        Element element4 = (Element)nodeList7.item(0);
                        boolean bl = Boolean.valueOf(element4.getAttribute("use"));
                        this.propertyDesktop.setSkinUse(bl);
                        if (bl) {
                            String string = element4.getAttribute("name");
                            this.propertyDesktop.setSkinTheme(string);
                            this.processSkin(string);
                        }
                    }
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("File read error with !\n" + file.getName());
            }
            catch (Exception exception) {
                System.err.println("XML problem !\n" + file.getName());
            }
        }
    }

    void processSkin(String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        MadkitClassLoader madkitClassLoader = Madkit.getClassLoader();
        try {
            Class clazz = madkitClassLoader.loadClass("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
            if (clazz != null) {
                System.out.println("Setting skin name: " + string);
                String string2 = Madkit.libDirectory + File.separator + "skins" + File.separator;
                SkinLookAndFeel.setSkin((Skin)SkinLookAndFeel.loadThemePack((String)(string2 + string)));
                SkinLookAndFeel.enable();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Cannot change the look and feel of the Desktop. Need the skinlf.jar in libs/support directory");
        }
        catch (Exception exception) {
            System.out.println("Invalid look & feel theme : " + string);
        }
    }

    public boolean addListenerTo(MenuItemInfo menuItemInfo, AbstractButton abstractButton) {
        if (menuItemInfo.getType() != null && menuItemInfo.getCode() != null) {
            if (menuItemInfo.getType().equalsIgnoreCase("Java")) {
                abstractButton.addActionListener(new JavaAgentButton(this.ai.getAgent(), menuItemInfo.getCode(), menuItemInfo.getGUI()));
                return true;
            }
            if (menuItemInfo.getType().equalsIgnoreCase("Scheme")) {
                abstractButton.addActionListener(new SchemeAgentButton(this.ai.getAgent(), menuItemInfo.getCode(), menuItemInfo.getGUI()));
                return true;
            }
            if (menuItemInfo.getType().equalsIgnoreCase("Jess")) {
                abstractButton.addActionListener(new JessAgentButton(this.ai.getAgent(), menuItemInfo.getCode(), menuItemInfo.getGUI()));
                return true;
            }
            if (menuItemInfo.getType().equalsIgnoreCase("Python")) {
                abstractButton.addActionListener(new PythonAgentButton(this.ai.getAgent(), menuItemInfo.getCode(), menuItemInfo.getGUI()));
                return true;
            }
            if (menuItemInfo.getType().equalsIgnoreCase("BeanShell")) {
                abstractButton.addActionListener(new BeanShellAgentButton(this.ai.getAgent(), menuItemInfo.getCode(), menuItemInfo.getGUI()));
                return true;
            }
            if (menuItemInfo.getType().equalsIgnoreCase("SEditFormalism")) {
                abstractButton.addActionListener(new SEditFormalismButton(this.ai.getAgent(), menuItemInfo.getCode(), menuItemInfo.getGUI()));
                return true;
            }
            if (menuItemInfo.getType().equalsIgnoreCase("SEditFile")) {
                abstractButton.addActionListener(new SEditFileButton(this.ai.getAgent(), menuItemInfo.getCode(), menuItemInfo.getGUI()));
                return true;
            }
        }
        return false;
    }

    protected void processButton(JMenu jMenu, Element element) {
        if (element.getAttribute("type").equalsIgnoreCase("Java")) {
            jMenu.add(new JMenuItemForAgent(this.ai.getAgent(), element, new JavaAgentButton(this.ai.getAgent(), element.getAttribute("code"), element.getAttribute("gui"))));
        } else if (element.getAttribute("type").equalsIgnoreCase("Scheme")) {
            jMenu.add(new JMenuItemForAgent(this.ai.getAgent(), element, new SchemeAgentButton(this.ai.getAgent(), element.getAttribute("code"), element.getAttribute("gui"))));
        } else if (element.getAttribute("type").equalsIgnoreCase("Jess")) {
            jMenu.add(new JMenuItemForAgent(this.ai.getAgent(), element, new JessAgentButton(this.ai.getAgent(), element.getAttribute("code"), element.getAttribute("gui"))));
        } else if (element.getAttribute("type").equalsIgnoreCase("Python")) {
            jMenu.add(new JMenuItemForAgent(this.ai.getAgent(), element, new PythonAgentButton(this.ai.getAgent(), element.getAttribute("code"), element.getAttribute("gui"))));
        } else if (element.getAttribute("type").equalsIgnoreCase("BeanShell")) {
            jMenu.add(new JMenuItemForAgent(this.ai.getAgent(), element, new BeanShellAgentButton(this.ai.getAgent(), element.getAttribute("code"), element.getAttribute("gui"))));
        } else if (element.getAttribute("type").equalsIgnoreCase("SEditFormalism")) {
            jMenu.add(new JMenuItemForAgent(this.ai.getAgent(), element, new SEditFormalismButton(this.ai.getAgent(), element.getAttribute("code"), element.getAttribute("gui"))));
        } else if (element.getAttribute("type").equalsIgnoreCase("SEditFile")) {
            jMenu.add(new JMenuItemForAgent(this.ai.getAgent(), element, new SEditFileButton(this.ai.getAgent(), element.getAttribute("code"), element.getAttribute("gui"))));
        }
    }

    public void addAgent(AbstractAgent abstractAgent, Component component, Point point, Dimension dimension) {
        AgentInfo agentInfo = new AgentInfo(abstractAgent);
        agentInfo.setLocation(point);
        agentInfo.setSize(dimension);
        this.components.put(component, agentInfo);
        this.desktop.addComponent(agentInfo, component);
        ((DesktopBooter)DesktopBooter.getBooter()).registerAgentGUI(abstractAgent, component);
    }

    public void removeGUI(Component component) {
        this.desktop.removeComponent(component);
        this.components.remove(component);
    }

    public boolean quitMadkit() {
        QuitDialog quitDialog = new QuitDialog(this.desktop.getTopComponent(), this);
        if (quitDialog.result() == 0) {
            System.exit(0);
        } else if (quitDialog.result() > 0) {
            this.desktop.dispose();
            this.saveIniFile(this.saveIni);
            this.saveConfigFile(this.saveConfig);
            System.exit(0);
        }
        return false;
    }

    public void setSaveIni(boolean bl) {
        this.saveIni = bl;
    }

    public void setSaveConfig(boolean bl) {
        this.saveConfig = bl;
    }

    public boolean getSaveIni() {
        return this.saveIni;
    }

    public boolean getSaveConfig() {
        return this.saveConfig;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.stop) {
            this.quitMadkit();
        } else if (object == this.exec) {
            this.openScriptFile();
        } else if (object == this.about) {
            new AboutDialog();
        } else if (object instanceof JMenuItemDesktop) {
            JMenuItemDesktop jMenuItemDesktop = (JMenuItemDesktop)object;
            if (jMenuItemDesktop == this.currentDesktop) {
                this.currentDesktop.setSelected(true);
            } else {
                if (this.createDesktop(((JMenuItemDesktop)object).getClassName())) {
                    if (this.currentDesktop != null) {
                        this.currentDesktop.setSelected(false);
                    }
                    this.currentDesktop = jMenuItemDesktop;
                    this.currentDesktop.setSelected(true);
                } else {
                    jMenuItemDesktop.setSelected(false);
                    jMenuItemDesktop.setEnabled(false);
                }
                this.desktop.show();
            }
        }
    }

    protected void addMenuSystem() {
        this.desktop.addMenuSystem(this.menuSelectDesktop);
        this.desktop.addMenuSystem(this.about);
        this.desktop.addMenuSystem(this.exec);
        this.desktop.addMenuSystem(this.stop);
    }

    public void addIcon(IconInfo iconInfo) {
        if (iconInfo != null) {
            this.iconInfos.add(iconInfo);
            this.desktop.addIcon(iconInfo);
        }
    }

    public void removeIcon(IconInfo iconInfo) {
        if (iconInfo != null) {
            this.iconInfos.remove(iconInfo);
            this.desktop.removeIcon(iconInfo);
        }
    }

    protected boolean createDesktop(String string) {
        Object var2_2 = null;
        try {
            MadkitClassLoader madkitClassLoader = Madkit.getClassLoader();
            Class clazz = madkitClassLoader.loadClass(string);
            var2_2 = clazz.newInstance();
            if (var2_2 != null && var2_2 instanceof Desktop) {
                if (this.desktop != null) {
                    this.desktop.dispose();
                }
                this.desktop = var2_2;
                this.desktop.init(this.ai, this.menuInfos, this);
                this.addMenuSystem();
                if (this.components != null) {
                    for (Object object : this.components.keySet()) {
                        this.desktop.addComponent((AgentInfo)this.components.get(object), (Component)object);
                    }
                }
                if (this.iconInfos != null) {
                    for (Object object : this.iconInfos) {
                        this.desktop.addIcon((IconInfo)object);
                    }
                }
                this.desktop.setProperty(this.propertyDesktop);
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Desktop class does not exist" + classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("Desktop launch exception:" + exception);
        }
        return false;
    }

    protected File openFile(boolean bl, final String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        final Object[] objectArray = vector.toArray();
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        if (bl) {
            jFileChooser.setFileSelectionMode(1);
        }
        if (string != null) {
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String string2 = file.getName();
                    if (file.isDirectory()) {
                        return true;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!string2.endsWith("." + (String)objectArray[i])) continue;
                        return true;
                    }
                    return false;
                }

                public String getDescription() {
                    return string + "files";
                }
            });
        }
        File file = null;
        if (jFileChooser.showOpenDialog(this.desktop.getTopComponent()) == 0) {
            file = jFileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    protected void openScriptFile() {
        File file = this.openFile(false, AbstractMadkitBooter.ALL_FILES);
        if (file != null) {
            DesktopBooter.getBooter().loadFile(this.ai.getAgent(), file);
        }
    }
}

