/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.grapheco;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import modulecoFramework.medium.Medium;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.EWorld;
import modulecoGUI.CentralControl;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CBufferedCanvas;

public class CanevasSmallWorld
extends CBufferedCanvas
implements CAgentRepresentation {
    private static final long serialVersionUID = 2032206056418193237L;
    public String name = "Links";
    protected EWorld eWorld;
    protected char[][] state;
    protected MenuItem menuItemEditAgent;
    protected MenuItem menuItemEditAgentLinks;
    protected MenuItem menuItemEditWorld;
    protected Color[][] c;
    protected Color colorBack;
    protected final Color fondcanvas = Color.lightGray;
    protected int size;
    protected double radius;
    protected double littleradius;
    protected double diameter;
    protected double littlediameter;
    protected int OldAgentID;
    protected int selectedAgentID;
    static double margin = 16.0;
    static double TWO_PI = Math.PI * 2;
    protected Shape agentCircle;
    protected Shape linkArc1;
    protected Shape linkArc;
    protected Shape line;
    protected BasicStroke widePen;
    protected BasicStroke narrowPen;
    protected Cursor canvasCrosshairCursor;
    protected Cursor canvasHandCursor;
    protected Vector shapeAgentVector;
    protected Vector shapeLinkVector;

    public CanevasSmallWorld() {
        this.setColors();
        this.setBackground(this.fondcanvas);
        this.menuItemEditAgent = new MenuItem("Edit Agent");
        this.menuItemEditAgentLinks = new MenuItem("Edit AgentLinks");
        this.menuItemEditWorld = new MenuItem("Edit World");
        this.menuItemEditAgent.addActionListener(this);
        this.menuItemEditAgentLinks.addActionListener(this);
        this.menuItemEditWorld.addActionListener(this);
        this.colorBack = Color.lightGray;
        this.setBackground(this.colorBack);
        this.agentCircle = new Ellipse2D.Double();
        this.linkArc = new Arc2D.Double(0);
        this.linkArc1 = new Arc2D.Double(0);
        this.line = new Line2D.Double();
        this.widePen = new BasicStroke(2.0f, 2, 1);
        this.narrowPen = new BasicStroke(1.0f, 2, 1);
        this.canvasCrosshairCursor = new Cursor(1);
        this.canvasHandCursor = new Cursor(12);
        this.setCursor(this.canvasCrosshairCursor);
        this.shapeAgentVector = new Vector();
        this.shapeLinkVector = new Vector();
    }

    public void setCAgent(CAgent cAgent) {
        this.eWorld = (EWorld)cAgent;
        this.size = new Double(Math.sqrt(this.eWorld.getAgentSetSize())).intValue();
        this.state = new char[this.size * this.size][2];
        for (int i = 0; i < this.size; ++i) {
            this.state[i][0] = (Boolean)((CAgent)this.eWorld.get(i)).getState() != false ? (char)'\u0000' : '\u0001';
            this.state[i][1] = this.state[i][0];
        }
    }

    protected void setColors() {
        this.c = new Color[2][2];
        this.c[0][0] = Color.blue.brighter().brighter().brighter();
        this.c[1][1] = Color.red.darker();
        this.c[1][0] = Color.yellow;
        this.c[0][1] = Color.green;
    }

    protected void drawFirstTime(Graphics graphics) {
        this.draw(graphics);
    }

    public void draw(Graphics graphics) {
        int n;
        this.calculateAgentsShape();
        this.calculateLinksShape();
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = new Integer(this.getHeight()).doubleValue();
        double d2 = new Integer(this.getWidth()).doubleValue();
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.translate(d2 / 2.0, d / 2.0);
        graphics2D.setColor(Color.black.darker().darker());
        graphics2D.setStroke(this.widePen);
        for (n = 0; n < this.shapeAgentVector.size(); ++n) {
            graphics2D.draw((Shape)this.shapeAgentVector.get(n));
        }
        for (n = 0; n < this.shapeLinkVector.size(); ++n) {
            graphics2D.draw((Shape)this.shapeLinkVector.get(n));
        }
        graphics2D.translate(-d2 / 2.0, -d / 2.0);
    }

    public void calculateAgentsShape() {
        double d = this.getHeight();
        double d2 = this.getWidth();
        this.diameter = Math.min(d, d2) - margin * 2.0 - this.littlediameter;
        this.radius = this.diameter / 2.0;
        int n = this.size * this.size;
        this.littleradius = 22 - 2 * this.size;
        this.littlediameter = 2.0 * this.littleradius;
        this.shapeAgentVector.clear();
        for (int i = 0; i < n; ++i) {
            double d3 = Math.cos((double)i * TWO_PI / (double)n) * this.radius;
            double d4 = Math.sin((double)i * TWO_PI / (double)n) * this.radius;
            Ellipse2D.Double double_ = new Ellipse2D.Double();
            double_.setFrameFromCenter(d3, d4, d3 + this.littleradius, d4 + this.littleradius);
            this.shapeAgentVector.add(i, double_);
        }
    }

    public void calculateLinksShape() {
        double d = this.getHeight();
        double d2 = this.getWidth();
        this.diameter = Math.min(d, d2) - margin * 2.0 - this.littlediameter;
        this.radius = this.diameter / 2.0;
        int n = this.size * this.size;
        this.littleradius = 22 - 2 * this.size;
        this.littlediameter = 2.0 * this.littleradius;
        this.shapeLinkVector.clear();
        for (int i = 0; i < 1; ++i) {
            System.out.println("Dessin de l'agent : " + i);
            Medium[] mediumArray = ((CAgent)this.eWorld.get(i)).getMediums();
            ArrayList arrayList = ((NeighbourMedium)mediumArray[0]).getNeighbours();
            for (EAgent eAgent : arrayList) {
                int n2 = eAgent.getAgentID();
                System.out.println("\tPour son voisin : " + n2);
                int n3 = (n2 - i + n) % n;
                System.out.println("\t\tDistance : " + n2);
                int n4 = n / 4;
                if (n3 == 1 || n3 > n4) continue;
                Ellipse2D.Double double_ = (Ellipse2D.Double)this.shapeAgentVector.get(i);
                double d3 = double_.getCenterX();
                double d4 = double_.getCenterY();
                Ellipse2D.Double double_2 = (Ellipse2D.Double)this.shapeAgentVector.get(n2);
                double d5 = double_2.getCenterX();
                double d6 = double_2.getCenterY();
                double d7 = (d3 + d5) / 2.0;
                double d8 = (d4 + d6) / 2.0;
                double d9 = Math.sqrt((d3 - d5) * (d3 - d5) + (d4 - d6) * (d4 - d6)) / 2.0;
                double d10 = (d3 - d5) / (d4 - d6);
                double d11 = Math.atan(d10) * 360.0 / TWO_PI;
                System.out.println("Tan = " + d10 + " | " + d11);
                Arc2D.Double double_3 = new Arc2D.Double();
                double_3.setArcByCenter(d7, d8, d9, 90.0, 270.0, 1);
                this.shapeLinkVector.add(double_3);
            }
        }
    }

    public void drawOld(Graphics graphics) {
        if (graphics != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = new Integer(this.getHeight()).doubleValue();
            double d2 = new Integer(this.getWidth()).doubleValue();
            this.littleradius = 22 - 2 * this.size;
            this.littlediameter = 2.0 * this.littleradius;
            this.diameter = Math.min(d, d2) - margin * 2.0 - this.littlediameter;
            this.radius = this.diameter / 2.0;
            int n = this.size * this.size;
            graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.translate(d2 / 2.0, d / 2.0);
            graphics2D.setColor(Color.black.darker().darker());
            graphics2D.setStroke(this.widePen);
            ((Arc2D.Double)this.linkArc1).setFrame(-this.radius, -this.radius, this.diameter, this.diameter);
            double d3 = this.radius;
            double d4 = 0.0;
            double d5 = this.radius * Math.cos(TWO_PI / new Integer(n).doubleValue());
            double d6 = this.radius * Math.sin(-TWO_PI / new Integer(n).doubleValue());
            ((Arc2D.Double)this.linkArc1).setAngles(d3, d4, d5, d6);
            ((Ellipse2D.Double)this.agentCircle).setFrameFromCenter(this.radius, 0.0, this.radius + this.littleradius, this.littleradius);
            for (int i = 0; i < n; ++i) {
                System.out.println("Dessin de l'agent : " + i);
                Medium[] mediumArray = ((CAgent)this.eWorld.get(i)).getMediums();
                ArrayList arrayList = ((NeighbourMedium)mediumArray[0]).getNeighbours();
                for (EAgent eAgent : arrayList) {
                    double d7;
                    int n2 = eAgent.getAgentID();
                    System.out.println("\tPour son voisin : " + n2);
                    int n3 = (n2 - i + n) % n;
                    System.out.println("\t\tDistance : " + n2);
                    int n4 = n / 4;
                    String string = "";
                    if (n3 <= n4) {
                        d7 = (double)n3 * Math.PI / (double)n;
                    } else if (n3 >= n - n4) {
                        d7 = -((double)(n - n3)) * Math.PI / (double)n;
                        string = "-";
                    } else {
                        d7 = 0.0;
                    }
                    System.out.println("\t\tAngle Bissectrice : " + string + n3 + " PI/" + n);
                    double d8 = Math.abs(this.radius * Math.cos(d7));
                    double d9 = Math.abs(this.radius * Math.sin(d7));
                    ((Arc2D.Double)this.linkArc).setArcByCenter(d8, 0.0, d9, 90.0, 180.0, 0);
                    if (n3 > n4 && n3 < n - n4) continue;
                    if (n3 == 1) {
                        graphics2D.draw(this.linkArc1);
                        graphics2D.drawString(i + " - " + n2, (int)d8, -((int)d9));
                        continue;
                    }
                    if (n3 == n - 1) {
                        graphics2D.rotate(TWO_PI / (double)n);
                        graphics2D.draw(this.linkArc1);
                        graphics2D.rotate(-TWO_PI / (double)n);
                        continue;
                    }
                    graphics2D.rotate(-d7);
                    graphics2D.draw(this.linkArc);
                    Color color = graphics2D.getColor();
                    graphics2D.setColor(this.fondcanvas);
                    graphics2D.fillRect((int)(this.radius - d8) - 2, -10, 50, 20);
                    graphics2D.setColor(color);
                    graphics2D.drawString(i + " - " + n2, (int)(this.radius - d8), 0);
                    graphics2D.rotate(d7);
                }
                this.drawAgent(i, graphics2D);
            }
            graphics2D.translate(-d2 / 2.0, -d / 2.0);
        }
    }

    public void drawAgent(int n, Graphics2D graphics2D) {
        System.out.println("\tDraw agent : " + n);
        int n2 = n;
        this.state[n2][0] = this.state[n2][1];
        this.state[n2][1] = (Boolean)((CAgent)this.eWorld.get(n2)).getState() != false ? (char)'\u0000' : '\u0001';
        graphics2D.setColor(this.c[this.state[n2][0]][this.state[n2][1]]);
        graphics2D.draw(this.agentCircle);
        graphics2D.fill(this.agentCircle);
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        graphics2D.drawString("" + n, (int)this.radius, 0);
        graphics2D.setColor(color);
        System.out.println("\tRotation de 2 PI /" + this.size * this.size);
        graphics2D.rotate(-TWO_PI / (double)(this.size * this.size));
    }

    /*
     * Unable to fully structure code
     */
    public void mouseClicked(MouseEvent var1_1) {
        block8: {
            block7: {
                var2_2 = 22 - 2 * this.size;
                var4_3 = (double)Math.min(this.dimension.width, this.dimension.height) - CanevasSmallWorld.margin * 2.0 - var2_2 * 2.0;
                var6_4 = this.size * this.size;
                var7_5 = 0;
                var1_1.translatePoint(-this.dimension.width / 2, -this.dimension.height / 2);
                var9_6 = var1_1.getX();
                var10_7 = -var1_1.getY();
                var11_8 = Math.sqrt(Math.pow(var9_6, 2.0) + Math.pow(var10_7, 2.0));
                var13_9 = Math.atan2(var10_7, var9_6);
                var15_10 = 2.0 * var2_2 / var4_3;
                while (true) {
                    v0 = new Integer(var6_4);
                    v1 = new Integer(var6_4);
                    if (!(Math.abs(var13_9) / var13_9 * var13_9 - (double)var7_5 * CanevasSmallWorld.TWO_PI / v0.doubleValue() >= 3.141592653589793 / v1.doubleValue())) break;
                    ++var7_5;
                }
                var8_11 = var13_9 <= 3.141592653589793 / new Integer(var6_4).doubleValue() ? var7_5 : var6_4 - var7_5;
                if ((var1_1.getModifiers() & 4) != 4) break block7;
                if (!(var11_8 > var4_3 / 2.0 - var2_2) || !(var11_8 < var4_3 / 2.0 + var2_2)) ** GOTO lbl-1000
                v2 = new Integer(var6_4);
                if (!(var13_9 <= Math.abs(var13_9) / var13_9 * (double)var7_5 * CanevasSmallWorld.TWO_PI / v2.doubleValue() + var15_10)) ** GOTO lbl-1000
                v3 = new Integer(var6_4);
                if (var13_9 >= Math.abs(var13_9) / var13_9 * (double)var7_5 * CanevasSmallWorld.TWO_PI / v3.doubleValue() - var15_10) {
                    this.selectedAgentID = var8_11;
                    this.popupMenu.add(this.menuItemEditAgent);
                    this.popupMenu.add(this.menuItemEditWorld);
                } else lbl-1000:
                // 3 sources

                {
                    this.popupMenu.remove(this.menuItemEditAgent);
                    this.popupMenu.remove(this.menuItemEditWorld);
                    if (this.menuItemEditAgentLinks != null) {
                        this.popupMenu.remove(this.menuItemEditAgentLinks);
                    }
                }
                super.mouseClicked(var1_1);
                break block8;
            }
            if (var11_8 > var4_3 / 2.0 - var2_2 && var11_8 < var4_3 / 2.0 + var2_2) {
                v4 = new Integer(var6_4);
                if (var13_9 <= Math.abs(var13_9) / var13_9 * (double)var7_5 * CanevasSmallWorld.TWO_PI / v4.doubleValue() + var15_10) {
                    v5 = new Integer(var6_4);
                    if (var13_9 >= Math.abs(var13_9) / var13_9 * (double)var7_5 * CanevasSmallWorld.TWO_PI / v5.doubleValue() - var15_10) {
                        ((EAgent)this.eWorld.get(var8_11)).inverseState();
                    }
                }
            }
            this.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseMoved(MouseEvent mouseEvent) {
        double d = 22 - 2 * this.size;
        double d2 = (double)Math.min(this.dimension.width, this.dimension.height) - margin * 2.0 - d * 2.0;
        int n = this.size * this.size;
        int n2 = 0;
        mouseEvent.translatePoint(-this.dimension.width / 2, -this.dimension.height / 2);
        int n3 = mouseEvent.getX();
        int n4 = -mouseEvent.getY();
        double d3 = Math.sqrt(Math.pow(n3, 2.0) + Math.pow(n4, 2.0));
        double d4 = Math.atan2(n4, n3);
        double d5 = 2.0 * d / d2;
        while (true) {
            Integer n5 = new Integer(n);
            Integer n6 = new Integer(n);
            if (!(Math.abs(d4) / d4 * d4 - (double)n2 * TWO_PI / n5.doubleValue() >= Math.PI / n6.doubleValue())) break;
            ++n2;
        }
        int n7 = d4 <= Math.PI / new Integer(n).doubleValue() ? n2 : n - n2;
        if (d3 > d2 / 2.0 - d && d3 < d2 / 2.0 + d) {
            Integer n8 = new Integer(n);
            if (d4 <= Math.abs(d4) / d4 * (double)n2 * TWO_PI / n8.doubleValue() + d5) {
                Integer n9 = new Integer(n);
                if (d4 >= Math.abs(d4) / d4 * (double)n2 * TWO_PI / n9.doubleValue() - d5) {
                    if (this.OldAgentID != n7) {
                        System.out.println("Agent  :" + n7);
                        this.OldAgentID = n7;
                    }
                    this.setCursor(this.canvasHandCursor);
                    this.setToolTipText(new Integer(n7).toString());
                    return;
                }
            }
        }
        this.setCursor(this.canvasCrosshairCursor);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!(actionEvent.getSource().equals(this.menuItemEditAgent) || actionEvent.getSource().equals(this.menuItemEditAgentLinks) || actionEvent.getSource().equals(this.menuItemEditWorld))) {
            super.actionPerformed(actionEvent);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Icon getIcon() {
        return null;
    }

    public String getDefaultPosition() {
        return null;
    }

    public void setDefaultPosition(String string) {
    }

    public CAgent getCAgent() {
        return null;
    }

    public void setIcon(Icon icon) {
    }

    public CentralControl getCentralControl() {
        return null;
    }
}

