/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.grapheco;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import modulecoFramework.Moduleco;
import modulecoGUI.CentralControl;
import modulecoGUI.grapheco.encoders.GIFEncoder;
import modulecoGUI.grapheco.encoders.PngEncoderB;
import modulecoGUI.utils.SimpleFileFilter;

public abstract class CBufferedCanvas
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener,
Printable {
    protected BufferedImage bufferedImage;
    protected Graphics bufferedImageGraphics;
    protected PopupMenu popupMenu;
    protected MenuItem menuItemSavePNG;
    protected MenuItem menuItemSaveGIF;
    protected MenuItem menuItemPrint;
    protected MenuItem menuItemRepresentation;
    protected Dimension dimension;
    protected CentralControl centralControl;
    private boolean updateSize = true;
    public boolean drawAble = false;

    public CBufferedCanvas() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.popupMenu = new PopupMenu();
        this.add(this.popupMenu);
        this.menuItemSaveGIF = new MenuItem("Save Image");
        this.menuItemSaveGIF.addActionListener(this);
        this.popupMenu.add(this.menuItemSaveGIF);
        this.menuItemPrint = new MenuItem("Print Image");
        this.menuItemPrint.addActionListener(this);
        this.popupMenu.add(this.menuItemPrint);
        this.menuItemRepresentation = new MenuItem("Circle/Lattice");
        this.menuItemRepresentation.addActionListener(this);
        this.popupMenu.add(this.menuItemRepresentation);
    }

    protected abstract void draw(Graphics var1);

    public void setCentralControl(CentralControl centralControl) {
        this.centralControl = centralControl;
    }

    public void paint(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        if (this.updateSize) {
            this.updateSize = false;
            this.bufferedImage = (BufferedImage)this.createImage(this.dimension.width, this.dimension.height);
            this.bufferedImageGraphics = this.bufferedImage.createGraphics();
            this.draw(this.bufferedImageGraphics);
        } else {
            this.draw(this.bufferedImageGraphics);
        }
        graphics.drawImage(this.bufferedImage, 0, 0, this);
    }

    public void updateImage() {
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
    }

    public void resetImage() {
        this.updateSize = true;
        this.repaint();
    }

    public void setSize(Dimension dimension) {
        this.updateSize = true;
        this.dimension = dimension;
        super.setSize(dimension);
    }

    public void setSize(int n, int n2) {
        this.updateSize = true;
        this.dimension = new Dimension(n, n2);
        super.setSize(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.updateSize = true;
        this.dimension = new Dimension(n3, n4);
        super.setBounds(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.updateSize = true;
        this.dimension = new Dimension(rectangle.width, rectangle.height);
        super.setBounds(rectangle);
    }

    public Dimension getPreferredSize() {
        if (this.dimension == null) {
            return super.getPreferredSize();
        }
        return this.dimension;
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    public Dimension getMaximumSize() {
        return new Dimension(600, 600);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        this.draw((Graphics2D)graphics);
        return 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object;
        String string;
        Object object2;
        Object object3;
        if (actionEvent.getSource().equals(this.menuItemSavePNG)) {
            object3 = new PngEncoderB(this.bufferedImage);
            object2 = this.centralControl.modulecoLauncher.getEWorld().pack().substring(this.centralControl.modulecoLauncher.getEWorld().pack().lastIndexOf(46) + 1);
            string = "";
            object = string + File.separator + (String)object2 + ".png";
            try {
                serializable = new File((String)object);
                if (!((File)serializable).getParentFile().isDirectory()) {
                    ((File)serializable).getParentFile().mkdir();
                }
                if (!((File)serializable).isFile()) {
                    ((File)serializable).createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
                fileOutputStream.write(((PngEncoderB)object3).pngEncode());
                fileOutputStream.flush();
                fileOutputStream.close();
                System.out.println("Image " + (String)object2 + " successfully stored in " + (String)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (actionEvent.getSource().equals(this.menuItemSaveGIF)) {
            object3 = null;
            try {
                object3 = new GIFEncoder(this.bufferedImage);
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
            object2 = new SimpleFileFilter("Fichiers Gif", ".gif");
            string = "";
            object = new File(string);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            serializable = new JFileChooser(string);
            ((JFileChooser)serializable).addChoosableFileFilter((FileFilter)object2);
            ((JFileChooser)serializable).setDialogTitle("Save Canevas for model \"" + Moduleco.getCurrentModelName() + "\"");
            int n = ((JFileChooser)serializable).showSaveDialog(this);
            if (n == 0) {
                String string2 = ((JFileChooser)serializable).getSelectedFile().getName();
                String string3 = ((JFileChooser)serializable).getSelectedFile().getAbsolutePath();
                if (!string3.endsWith(".gif")) {
                    string3 = string3.concat(".gif");
                }
                try {
                    File file = new File(string3);
                    if (!file.getParentFile().isDirectory()) {
                        file.getParentFile().mkdir();
                    }
                    if (!file.isFile()) {
                        file.createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ((GIFEncoder)object3).Write(fileOutputStream);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    System.out.println("Image successfully stored in " + string3);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (actionEvent.getSource().equals(this.menuItemPrint)) {
            object3 = PrinterJob.getPrinterJob();
            ((PrinterJob)object3).validatePage(((PrinterJob)object3).defaultPage());
            ((PrinterJob)object3).setPrintable(this, ((PrinterJob)object3).pageDialog(((PrinterJob)object3).defaultPage()));
            if (((PrinterJob)object3).printDialog()) {
                try {
                    ((PrinterJob)object3).print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (actionEvent.getSource().equals(this.menuItemRepresentation)) {
            // empty if block
        }
    }

    public void setDrawAble(boolean bl) {
        this.drawAble = bl;
    }
}

