/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Field;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.simulation.ModulecoLauncher;

public class JFrameDebug
extends JFrame {
    JTextArea jTextArea;

    public JFrameDebug() {
        this.setTitle("Debug Window");
        this.setSize(400, 500);
        this.setDefaultCloseOperation(2);
        this.setLocation(200, 100);
        this.jTextArea = new JTextArea();
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.jTextArea);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        this.setVisible(true);
    }

    public void setText(String string) {
        this.jTextArea.setText(string);
    }

    public void showModelProperties(ModulecoLauncher modulecoLauncher) {
        EWorld eWorld = modulecoLauncher.getEWorld();
        Field[] fieldArray = eWorld.getClass().getFields();
        this.jTextArea.setText(eWorld.getClass().getName());
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                Object object = fieldArray[i].get(eWorld);
                this.jTextArea.setText(this.jTextArea.getText() + "\n" + fieldArray[i].getName() + " : " + object.toString());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

