/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.dataRecorder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.ModelParameters;
import modulecoFramework.utils.dataRecorder.Recorder;

public class JConfigRecorder
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -4149040572651950861L;
    JPanel jPanelContainer;
    JPanel jPanelModelParameter;
    JPanel jPanelFile;
    JPanel jPanelProperties;
    JDialog jDialog;
    EWorld world;
    Recorder recorder;
    JButton jButtonOk;
    JButton jButtonCancel;
    JButton jButtonWorldRecord;
    JButton jButtonWorldRecord2;
    JButton jButtonWorldNotRecord;
    JButton jButtonWorldNotRecord2;
    JButton jButtonAgentRecord;
    JButton jButtonAgentRecord2;
    JButton jButtonAgentNotRecord;
    JButton jButtonAgentNotRecord2;
    JList jListWorldRecord;
    JList jListWorldNotRecord;
    JList jListAgentRecord;
    JList jListAgentNotRecord;
    JButton jButtonBrowse;
    JTextField jTextFieldFilePath;

    public JConfigRecorder(Recorder recorder, EWorld eWorld) {
        this.recorder = recorder;
        this.world = eWorld;
        this.setLayout(new BorderLayout());
        this.build();
    }

    protected void build() {
        this.buildModelParameter();
        this.buildFileParameter();
        this.buildProperties();
        this.jPanelContainer = new JPanel(new BorderLayout());
        this.jPanelContainer.add((Component)this.jPanelModelParameter, "North");
        this.jPanelContainer.add((Component)this.jPanelFile, "Center");
        this.jPanelContainer.add((Component)this.jPanelProperties, "South");
        this.jButtonOk = new JButton("OK");
        this.jButtonCancel = new JButton("Cancel");
        this.jButtonOk.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.jButtonOk);
        this.add((Component)this.jPanelContainer, "Center");
        this.add((Component)jPanel, "South");
        this.validate();
        this.repaint();
    }

    protected void buildModelParameter() {
        GridLayout gridLayout = new GridLayout(3, 4);
        gridLayout.setHgap(10);
        gridLayout.setVgap(10);
        this.jPanelModelParameter = new JPanel(gridLayout);
        this.jPanelModelParameter.setBorder(BorderFactory.createTitledBorder("Model parameters"));
        JLabel jLabel = new JLabel("Model Name : ");
        JLabel jLabel2 = new JLabel("Neighbour Name : ");
        JLabel jLabel3 = new JLabel("Scheduler Type : ");
        JLabel jLabel4 = new JLabel("World Size : ");
        JLabel jLabel5 = new JLabel("Zone Name : ");
        ModelParameters modelParameters = this.world.getModelParameters();
        JTextField jTextField = new JTextField(modelParameters.getName());
        JTextField jTextField2 = new JTextField(modelParameters.getNeighbourhood());
        JTextField jTextField3 = new JTextField(modelParameters.getTimeScheduler());
        JTextField jTextField4 = new JTextField(modelParameters.getLength());
        JTextField jTextField5 = new JTextField(modelParameters.getZone());
        jTextField.setEnabled(false);
        jTextField2.setEnabled(false);
        jTextField3.setEnabled(false);
        jTextField4.setEnabled(false);
        jTextField5.setEnabled(false);
        this.jPanelModelParameter.add(jLabel);
        this.jPanelModelParameter.add(jTextField);
        this.jPanelModelParameter.add(jLabel2);
        this.jPanelModelParameter.add(jTextField2);
        this.jPanelModelParameter.add(jLabel3);
        this.jPanelModelParameter.add(jTextField3);
        this.jPanelModelParameter.add(jLabel4);
        this.jPanelModelParameter.add(jTextField4);
        this.jPanelModelParameter.add(jLabel5);
        this.jPanelModelParameter.add(jTextField5);
    }

    protected void buildFileParameter() {
        this.jPanelFile = new JPanel(new GridBagLayout());
        this.jPanelFile.setBorder(BorderFactory.createTitledBorder("Data File Parameters"));
        JLabel jLabel = new JLabel("File Path : ");
        JLabel jLabel2 = new JLabel("Data Format : ");
        this.jTextFieldFilePath = new JTextField(this.recorder.getFilePath());
        this.jTextFieldFilePath.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                JConfigRecorder.this.recorder.setFilePath(JConfigRecorder.this.jTextFieldFilePath.getText());
            }
        });
        this.jTextFieldFilePath.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JConfigRecorder.this.recorder.setFilePath(JConfigRecorder.this.jTextFieldFilePath.getText());
            }
        });
        this.jButtonBrowse = new JButton("Browse");
        this.jButtonBrowse.addActionListener(this);
        this.jPanelFile.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanelFile.add((Component)this.jTextFieldFilePath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanelFile.add((Component)this.jButtonBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.jPanelFile.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
    }

    protected void buildProperties() {
        this.jPanelProperties = new JPanel(new BorderLayout());
        this.jPanelProperties.setBorder(BorderFactory.createTitledBorder("Selected Variables"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Recorded :");
        JLabel jLabel2 = new JLabel("Not Recorded :");
        JLabel jLabel3 = new JLabel("Recorded :");
        JLabel jLabel4 = new JLabel("Not Recorded :");
        this.jListWorldRecord = new JList<String>(this.recorder.getRecordedWorldProperies());
        this.jListWorldNotRecord = new JList<String>(this.recorder.getNotRecordedWorldProperies());
        this.jListAgentRecord = new JList<String>(this.recorder.getRecordedAgentProperies());
        this.jListAgentNotRecord = new JList<String>(this.recorder.getNotRecordedAgentProperies());
        this.jButtonWorldRecord = new JButton(">");
        this.jButtonWorldRecord2 = new JButton(">>");
        this.jButtonWorldNotRecord = new JButton("<");
        this.jButtonWorldNotRecord2 = new JButton("<<");
        this.jButtonAgentRecord = new JButton(">");
        this.jButtonAgentRecord2 = new JButton(">>");
        this.jButtonAgentNotRecord = new JButton("<");
        this.jButtonAgentNotRecord2 = new JButton("<<");
        this.jButtonWorldRecord.addActionListener(this);
        this.jButtonWorldNotRecord.addActionListener(this);
        this.jButtonAgentRecord.addActionListener(this);
        this.jButtonAgentNotRecord.addActionListener(this);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)new JScrollPane(this.jListWorldRecord), new GridBagConstraints(0, 1, 1, 4, 1.0, 0.0, 13, 1, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.jButtonWorldRecord, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.jButtonWorldRecord2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.jButtonWorldNotRecord, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.jButtonWorldNotRecord2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)new JScrollPane(this.jListWorldNotRecord), new GridBagConstraints(2, 1, 1, 4, 1.0, 0.0, 13, 1, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)jLabel4, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)new JScrollPane(this.jListAgentRecord), new GridBagConstraints(0, 1, 1, 4, 1.0, 0.0, 13, 1, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)this.jButtonAgentRecord, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)this.jButtonAgentRecord2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)this.jButtonAgentNotRecord, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)this.jButtonAgentNotRecord2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)new JScrollPane(this.jListAgentNotRecord), new GridBagConstraints(2, 1, 1, 4, 1.0, 0.0, 13, 1, new Insets(5, 10, 5, 10), 0, 0));
        jTabbedPane.add("Agents' Variables", jPanel2);
        jTabbedPane.add("World's Variables", jPanel);
        this.jPanelProperties.add((Component)jTabbedPane, "Center");
    }

    protected JDialog createDialog(Component component) throws HeadlessException {
        Container container = SwingUtilities.getAncestorOfClass(JFrame.class, component);
        if (container != null) {
            JDialog jDialog = new JDialog((JFrame)container);
            jDialog.getContentPane().add(this);
            jDialog.setModal(true);
            jDialog.setTitle("Record Data : ");
            jDialog.invalidate();
            jDialog.repaint();
            return jDialog;
        }
        return null;
    }

    public int showJConfigRedorder(Component component) {
        this.jDialog = this.createDialog(component);
        this.jDialog.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.jDialog.setLocation((dimension.width - this.jDialog.getWidth()) / 2, (dimension.height - this.jDialog.getHeight()) / 2);
        this.jDialog.setVisible(true);
        return 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser;
        int n;
        if (actionEvent.getSource().equals(this.jButtonWorldRecord)) {
            Object object;
            Object[] objectArray = this.jListWorldRecord.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                object = (String)objectArray[i];
                this.recorder.eraseWorldProperty((String)object);
            }
            String[] stringArray = this.recorder.getRecordedWorldProperies();
            object = new DefaultListModel();
            for (int i = 0; i < stringArray.length; ++i) {
                ((DefaultListModel)object).addElement(stringArray[i]);
            }
            this.jListWorldRecord.setModel(object);
            String[] stringArray2 = this.recorder.getNotRecordedWorldProperies();
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                defaultListModel.addElement(stringArray2[i]);
            }
            this.jListWorldNotRecord.setModel(defaultListModel);
        } else if (actionEvent.getSource().equals(this.jButtonWorldNotRecord)) {
            Object object;
            Object[] objectArray = this.jListWorldNotRecord.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                object = (String)objectArray[i];
                this.recorder.recordWorldProperty((String)object);
            }
            String[] stringArray = this.recorder.getRecordedWorldProperies();
            object = new DefaultListModel();
            for (int i = 0; i < stringArray.length; ++i) {
                ((DefaultListModel)object).addElement(stringArray[i]);
            }
            this.jListWorldRecord.setModel(object);
            String[] stringArray3 = this.recorder.getNotRecordedWorldProperies();
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (int i = 0; i < stringArray3.length; ++i) {
                defaultListModel.addElement(stringArray3[i]);
            }
            this.jListWorldNotRecord.setModel(defaultListModel);
        } else if (actionEvent.getSource().equals(this.jButtonAgentRecord)) {
            Object object;
            Object[] objectArray = this.jListAgentRecord.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                object = (String)objectArray[i];
                this.recorder.eraseAgentProperty((String)object);
            }
            String[] stringArray = this.recorder.getRecordedAgentProperies();
            object = new DefaultListModel();
            for (int i = 0; i < stringArray.length; ++i) {
                ((DefaultListModel)object).addElement(stringArray[i]);
            }
            this.jListAgentRecord.setModel(object);
            String[] stringArray4 = this.recorder.getNotRecordedAgentProperies();
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (int i = 0; i < stringArray4.length; ++i) {
                defaultListModel.addElement(stringArray4[i]);
            }
            this.jListAgentNotRecord.setModel(defaultListModel);
        } else if (actionEvent.getSource().equals(this.jButtonAgentNotRecord)) {
            Object object;
            Object[] objectArray = this.jListAgentNotRecord.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                object = (String)objectArray[i];
                this.recorder.recordAgentProperty((String)object);
            }
            String[] stringArray = this.recorder.getRecordedAgentProperies();
            object = new DefaultListModel();
            for (int i = 0; i < stringArray.length; ++i) {
                ((DefaultListModel)object).addElement(stringArray[i]);
            }
            this.jListAgentRecord.setModel(object);
            String[] stringArray5 = this.recorder.getNotRecordedAgentProperies();
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (int i = 0; i < stringArray5.length; ++i) {
                defaultListModel.addElement(stringArray5[i]);
            }
            this.jListAgentNotRecord.setModel(defaultListModel);
        } else if (actionEvent.getSource().equals(this.jButtonOk)) {
            this.jDialog.setVisible(false);
            this.jDialog.dispose();
        } else if (actionEvent.getSource().equals(this.jButtonBrowse) && (n = (jFileChooser = new JFileChooser(this.recorder.getFile())).showSaveDialog(this)) == 0) {
            this.recorder.setFilePath(jFileChooser.getSelectedFile().getAbsolutePath());
            this.jTextFieldFilePath.setText(this.recorder.getFilePath());
        }
    }
}

