/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor.editors;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import modulecoGUI.cAgentEditor.editors.SwingEditorSupport;
import modulecoGUI.cAgentEditor.editors.SwingEnumEditor;

public class SwingStringEditor
extends SwingEditorSupport {
    private SwingEnumEditor enumEditor = new SwingEnumEditor();
    private JTextField textfield;
    private boolean isEnumeration = false;
    private PropertyDescriptor descriptor;

    public void setValue(Object object) {
        if (this.isEnumeration) {
            this.enumEditor.setValue(object);
        } else {
            super.setValue(object);
            if (object != null) {
                this.textfield.setText(object.toString());
            }
        }
    }

    public Object getValue() {
        if (this.isEnumeration) {
            return this.enumEditor.getValue();
        }
        return super.getValue();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.enumEditor.addPropertyChangeListener(propertyChangeListener);
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.enumEditor.removePropertyChangeListener(propertyChangeListener);
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public void init(PropertyDescriptor propertyDescriptor) {
        this.descriptor = propertyDescriptor;
        Object[] objectArray = (Object[])propertyDescriptor.getValue("enumerationValues");
        if (objectArray != null) {
            this.isEnumeration = true;
            this.enumEditor.init(propertyDescriptor);
        } else {
            this.isEnumeration = false;
            if (this.textfield == null) {
                this.textfield = new JTextField();
                this.textfield.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            SwingStringEditor.this.setValue(SwingStringEditor.this.textfield.getText());
                        }
                    }
                });
                this.panel = new JPanel();
                this.panel.setLayout(new BoxLayout(this.panel, 0));
                this.panel.add(this.textfield);
            }
        }
    }

    public Component getCustomEditor() {
        if (this.isEnumeration) {
            return this.enumEditor.getCustomEditor();
        }
        return super.getCustomEditor();
    }
}

