/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import modulecoGUI.cAgentEditor.editors.SwingEditorSupport;

public class SwingFontEditor
extends SwingEditorSupport
implements ActionListener {
    private static int BUTTON_WIDTH = 20;
    private static int BUTTON_HEIGHT = 30;
    private static Dimension buttonSize = new Dimension(BUTTON_WIDTH, BUTTON_HEIGHT);
    private String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static int[] pointSizes = new int[]{3, 5, 8, 10, 12, 14, 18, 24, 36, 48};
    private int selectedStyle = 0;
    private static final String sampleText = "Abcde...";
    private JComboBox familyNameCombo;
    private JComboBox fontSizeCombo;
    private JToggleButton pButton;
    private JToggleButton iButton;
    private JToggleButton bButton;
    private FontDisplay iDisplay;
    private FontDisplay pDisplay = new FontDisplay(0);
    private FontDisplay bDisplay;
    private JLabel labelDisplay;
    private boolean valueSet;

    public SwingFontEditor() {
        this.pButton = new JToggleButton(this.pDisplay);
        this.pButton.setToolTipText("plain style");
        this.iDisplay = new FontDisplay(2);
        this.iButton = new JToggleButton(this.iDisplay);
        this.iButton.setToolTipText("italic style");
        this.bDisplay = new FontDisplay(1);
        this.bButton = new JToggleButton(this.bDisplay);
        this.bButton.setToolTipText("bold style");
        this.initializeButton(this.pButton);
        this.initializeButton(this.iButton);
        this.initializeButton(this.bButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.pButton);
        buttonGroup.add(this.iButton);
        buttonGroup.add(this.bButton);
        this.labelDisplay = new JLabel(this.fonts[0]);
        this.labelDisplay.setAlignmentX(0.0f);
        this.labelDisplay.setPreferredSize(new Dimension(250, 30));
        this.labelDisplay.setMinimumSize(new Dimension(250, 30));
        this.initializeComboBoxes();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.familyNameCombo);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.fontSizeCombo);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.pButton);
        jPanel.add(this.iButton);
        jPanel.add(this.bButton);
        jPanel.setAlignmentX(0.0f);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(jPanel);
        this.panel.add(this.labelDisplay);
    }

    private void initializeButton(JToggleButton jToggleButton) {
        jToggleButton.setBorderPainted(false);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setPreferredSize(buttonSize);
        jToggleButton.setMaximumSize(buttonSize);
        jToggleButton.setMinimumSize(buttonSize);
        jToggleButton.addActionListener(this);
        this.setAlignment(jToggleButton);
    }

    private void initializeComboBoxes() {
        this.familyNameCombo = new JComboBox<String>(this.fonts);
        this.fontSizeCombo = new JComboBox();
        this.familyNameCombo.setPreferredSize(SwingEditorSupport.MEDIUM_DIMENSION);
        this.familyNameCombo.setMinimumSize(SwingEditorSupport.MEDIUM_DIMENSION);
        this.familyNameCombo.setMaximumSize(SwingEditorSupport.MEDIUM_DIMENSION);
        this.familyNameCombo.addActionListener(this);
        this.setAlignment(this.familyNameCombo);
        for (int i = 0; i < pointSizes.length; ++i) {
            this.fontSizeCombo.addItem("" + pointSizes[i]);
        }
        this.fontSizeCombo.setPreferredSize(SwingEditorSupport.SMALL_DIMENSION);
        this.fontSizeCombo.setMaximumSize(SwingEditorSupport.SMALL_DIMENSION);
        this.fontSizeCombo.setMinimumSize(SwingEditorSupport.SMALL_DIMENSION);
        this.fontSizeCombo.addActionListener(this);
        this.setAlignment(this.fontSizeCombo);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.valueSet) {
            return;
        }
        Object object = actionEvent.getSource();
        String string = "Dialog";
        int n = 12;
        if (object instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)object;
            if (object == this.pButton) {
                this.selectedStyle = 0;
            } else if (object == this.iButton) {
                this.selectedStyle = 2;
            } else if (object == this.bButton) {
                this.selectedStyle = 1;
            }
            string = (String)this.familyNameCombo.getSelectedItem();
            if (this.fontSizeCombo.getSelectedIndex() != -1) {
                n = pointSizes[this.fontSizeCombo.getSelectedIndex()];
            }
        }
        if (object instanceof JComboBox) {
            string = (String)this.familyNameCombo.getSelectedItem();
            if (this.fontSizeCombo.getSelectedIndex() != -1) {
                n = pointSizes[this.fontSizeCombo.getSelectedIndex()];
            }
        }
        super.setValue(new Font(string, this.selectedStyle, n));
    }

    private void editorChangeValue(Font font) {
        int n;
        if (font == null) {
            this.familyNameCombo.setSelectedIndex(-1);
            this.fontSizeCombo.setSelectedIndex(-1);
            this.labelDisplay.setText("null");
            return;
        }
        for (n = 0; n < this.fonts.length; ++n) {
            if (!this.fonts[n].equals(font.getName())) continue;
            this.familyNameCombo.setSelectedIndex(n);
            break;
        }
        for (n = 0; n < pointSizes.length; ++n) {
            if (font.getSize() > pointSizes[n]) continue;
            this.fontSizeCombo.setSelectedIndex(n);
            break;
        }
        this.selectedStyle = font.getStyle();
        String string = "";
        switch (this.selectedStyle) {
            case 0: {
                this.pButton.setSelected(true);
                string = "Plain";
                break;
            }
            case 2: {
                this.iButton.setSelected(true);
                string = "Italic";
                break;
            }
            case 1: {
                this.bButton.setSelected(true);
                string = "Bold";
            }
        }
        String string2 = font.getFamily();
        this.iDisplay.setFamily(string2);
        this.pDisplay.setFamily(string2);
        this.bDisplay.setFamily(string2);
        this.labelDisplay.setFont(font);
        this.labelDisplay.setText(string2 + ", " + string + ", " + font.getSize());
        this.panel.revalidate();
        this.panel.repaint();
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.valueSet = true;
        this.editorChangeValue((Font)object);
        this.valueSet = false;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Font font = graphics.getFont();
        graphics.setFont((Font)this.getValue());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(sampleText, 0, rectangle.height - n);
        graphics.setFont(font);
    }

    public String getJavaInitializationString() {
        Font font = (Font)this.getValue();
        return "new java.awt.Font(\"" + font.getFamily() + "\", " + font.getStyle() + ", " + font.getSize() + ")";
    }

    private class FontDisplay
    implements Icon {
        private Font font;
        private int style = 0;
        private int size = 24;
        private String label = "A";
        private int iconWidth = 20;
        private int iconHeight = 30;

        public FontDisplay(int n) {
            this.style = n;
            this.font = new Font("Dialog", this.style, this.size);
        }

        public FontDisplay() {
            this.font = new Font("Dialog", this.style, this.size);
        }

        public void setFamily(String string) {
            this.font = new Font(string, this.style, this.size);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JComponent jComponent = (JComponent)component;
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            if (jComponent instanceof JToggleButton) {
                AbstractButton abstractButton = (AbstractButton)jComponent;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isPressed() || buttonModel.isSelected()) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.gray);
                }
            }
            graphics.drawString(this.label, n, n2 + this.iconHeight - 7);
            graphics.setFont(font);
        }

        public int getIconWidth() {
            return this.iconWidth;
        }

        public int getIconHeight() {
            return this.iconHeight;
        }
    }
}

