/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI.cAgentEditor.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import modulecoGUI.cAgentEditor.editors.ChooserComboPopup;
import modulecoGUI.cAgentEditor.editors.MainSwatchPanel;
import modulecoGUI.cAgentEditor.editors.RecentSwatchPanel;
import modulecoGUI.cAgentEditor.editors.SwatchPanel;
import modulecoGUI.cAgentEditor.editors.SwingColorEditor;

public class SwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    SwingColorEditor chooser;
    ChooserComboPopup popup;
    private static String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");

    public SwatchChooserPanel(SwingColorEditor swingColorEditor, ChooserComboPopup chooserComboPopup) {
        this.chooser = swingColorEditor;
        this.popup = chooserComboPopup;
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
    }

    protected void buildChooser() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(recentStr);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        jPanel2.setBorder(compoundBorder);
        jPanel2.add((Component)this.swatchPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(compoundBorder);
        jPanel3.add((Component)this.recentSwatchPanel, "Center");
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel.add(jPanel2);
        this.add(jPanel);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.swatchPanel = null;
        this.mainSwatchListener = null;
        this.removeAll();
    }

    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = SwatchChooserPanel.this.swatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            SwatchChooserPanel.this.chooser.setValue(color);
            SwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
            SwatchChooserPanel.this.popup.setVisible(false);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = SwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            SwatchChooserPanel.this.chooser.setValue(color);
            SwatchChooserPanel.this.popup.setVisible(false);
        }
    }
}

