/*
 * Decompiled with CFR 0.152.
 */
package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import modulecoGUI.CentralControl;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentationContainer;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.util.ViewMap;
import net.infonode.util.Direction;

public class JPanelDockingMiddle
extends JPanel {
    CentralControl centralControl;
    RootWindow rootWindow;
    SplitWindow splitWindowBottomTop;
    SplitWindow splitWindowLeftRigth;
    TabWindow tabWindowRigth;
    TabWindow tabWindowLeft;
    TabWindow tabWindowBottom;
    static String LEFT_POSITION = "LEFT";
    static String RIGTH_POSITION = "RIGTH";
    static String BOTTOM_POSITION = "BOTTOM";
    private int nbOfRepresentation;
    ViewMap viewMap;
    Preferences preferences = Preferences.userNodeForPackage(JPanelDockingMiddle.class);
    Map mapTabWindow;

    public JPanelDockingMiddle(CentralControl centralControl) {
        this.centralControl = centralControl;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.build();
    }

    public void build() {
        this.removeAll();
        this.nbOfRepresentation = 0;
        this.mapTabWindow = new HashMap();
        this.viewMap = new ViewMap();
        this.tabWindowRigth = new TabWindow();
        this.tabWindowRigth.setName(RIGTH_POSITION);
        this.mapTabWindow.put(this.tabWindowRigth.getName(), this.tabWindowRigth);
        this.tabWindowLeft = new TabWindow();
        this.tabWindowLeft.setName(LEFT_POSITION);
        this.mapTabWindow.put(this.tabWindowLeft.getName(), this.tabWindowLeft);
        this.tabWindowBottom = new TabWindow();
        this.tabWindowBottom.setName(BOTTOM_POSITION);
        this.mapTabWindow.put(this.tabWindowBottom.getName(), this.tabWindowBottom);
        this.splitWindowLeftRigth = new SplitWindow(true, 0.5f, (DockingWindow)this.tabWindowLeft, (DockingWindow)this.tabWindowRigth);
        this.splitWindowBottomTop = new SplitWindow(false, 0.7f, (DockingWindow)this.splitWindowLeftRigth, (DockingWindow)this.tabWindowBottom);
        CAgentRepresentationContainer cAgentRepresentationContainer = this.centralControl.getAgentRepresentationContainer();
        Iterator iterator = cAgentRepresentationContainer.iterator();
        while (iterator.hasNext()) {
            CAgentRepresentation cAgentRepresentation = (CAgentRepresentation)iterator.next();
            this.addAgentRepresentation(cAgentRepresentation, cAgentRepresentation.getDefaultPosition());
        }
        this.rootWindow = new RootWindow(null);
        this.rootWindow.setWindow((DockingWindow)this.splitWindowBottomTop);
        this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(true);
        this.add((Component)this.rootWindow, "Center");
    }

    public void addAgentRepresentation(CAgentRepresentation cAgentRepresentation) {
        if (cAgentRepresentation instanceof AbstractCAgentRepresentation) {
            this.viewMap.addView(this.nbOfRepresentation, new View(cAgentRepresentation.getName(), ((AbstractCAgentRepresentation)cAgentRepresentation).getIcon(), (Component)((JPanel)((Object)cAgentRepresentation))));
        } else {
            this.viewMap.addView(this.nbOfRepresentation, new View(cAgentRepresentation.getName(), null, (Component)((JComponent)((Object)cAgentRepresentation))));
        }
        ++this.nbOfRepresentation;
        this.validate();
        this.repaint();
    }

    public void addAgentRepresentation(CAgentRepresentation cAgentRepresentation, String string) {
        View view = cAgentRepresentation instanceof AbstractCAgentRepresentation ? new View(cAgentRepresentation.getName(), ((AbstractCAgentRepresentation)cAgentRepresentation).getIcon(), (Component)((JComponent)((Object)cAgentRepresentation))) : new View(cAgentRepresentation.getName(), null, (Component)((JComponent)((Object)cAgentRepresentation)));
        this.viewMap.addView(this.nbOfRepresentation, view);
        ++this.nbOfRepresentation;
        TabWindow tabWindow = null;
        tabWindow = string != null ? (TabWindow)this.mapTabWindow.get(string) : (TabWindow)this.mapTabWindow.get(RIGTH_POSITION);
        if (tabWindow == null) {
            tabWindow = this.getFirstTabWindow((DockingWindow)this.rootWindow);
        }
        tabWindow.addTab((DockingWindow)view);
        view.restore();
    }

    public void displayDockingHierarchy() {
        this.displayDockingHierarchy((DockingWindow)this.rootWindow, "");
    }

    public void displayDockingHierarchy(DockingWindow dockingWindow, String string) {
        System.out.println(string + dockingWindow.getName() + " : " + dockingWindow.getTitle() + " : " + dockingWindow.getClass());
        for (int i = 0; i < dockingWindow.getChildWindowCount(); ++i) {
            this.displayDockingHierarchy(dockingWindow.getChildWindow(i), string + "\t");
        }
    }

    private TabWindow getFirstTabWindow(DockingWindow dockingWindow) {
        if (TabWindow.class.equals(dockingWindow.getClass())) {
            return (TabWindow)dockingWindow;
        }
        Object object = null;
        for (int i = 0; i < dockingWindow.getChildWindowCount() && object == null; ++i) {
            object = this.getFirstTabWindow(dockingWindow.getChildWindow(i));
        }
        if (object != null && object.getClass().equals(TabWindow.class)) {
            return (TabWindow)object;
        }
        return null;
    }

    public void resetPerspective() {
        this.build();
    }

    public void showView(String string) {
        for (int i = 0; i < this.viewMap.getViewCount(); ++i) {
            if (!this.viewMap.getView(i).getTitle().equals(string)) continue;
            this.viewMap.getView(i).restore();
        }
    }
}

