/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.utils.dataRecorder;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import madkit.kernel.Probe;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;
import madkit.simulation.probes.ReflexiveProbe;
import modulecoFramework.simulation.scheduling.ModulecoScheduler;

public class StatRecorder
extends Watcher
implements ReferenceableAgent {
    private static final long serialVersionUID = 3824894816891832508L;
    public Map mapWorldProbe = new HashMap();
    public Map mapWorldValues = new HashMap();
    int iteration;

    public void activate() {
        this.requestRole("moduleco", "WatcherGroup", "WatcherRole", null);
        this.recordAllWorldProperties();
    }

    public int getIteration() {
        return (int)ModulecoScheduler.getGVT();
    }

    private void recordAllWorldProperties() {
        Probe probe = new Probe("moduleco", "ecoAgent", "environment");
        this.addProbe(probe);
        ListIterator listIterator = probe.getAgentsIterator();
        if (listIterator.hasNext()) {
            Object e = listIterator.next();
            String[] stringArray = new String[]{};
            try {
                stringArray = (String[])e.getClass().getField("outputParameters").get(e);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                ReflexiveProbe reflexiveProbe = new ReflexiveProbe("moduleco", "ecoAgent", "environment", stringArray[i]);
                this.addProbe((Probe)reflexiveProbe);
                this.mapWorldProbe.put(stringArray[i], reflexiveProbe);
            }
        }
        this.removeProbe(probe);
    }

    public void observeAgents() {
        this.iteration = (int)ModulecoScheduler.getGVT();
        this.observeNewWorldValue();
    }

    private void observeNewWorldValue() {
        for (String string : this.mapWorldProbe.keySet()) {
            ReflexiveProbe reflexiveProbe = (ReflexiveProbe)this.mapWorldProbe.get(string);
            Vector<Object> vector = (Vector<Object>)this.mapWorldValues.get(string);
            if (vector == null) {
                vector = new Vector<Object>();
                this.mapWorldValues.put(string, vector);
            }
            ListIterator listIterator = reflexiveProbe.getAgentsIterator();
            while (listIterator.hasNext()) {
                vector.add(this.iteration, reflexiveProbe.getObject(listIterator.next()));
            }
        }
    }

    public double getValue(String string) {
        Vector vector = (Vector)this.mapWorldValues.get(string);
        Object e = vector.lastElement();
        try {
            Double d = new Double(e.toString());
            return d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Double.MIN_VALUE;
        }
    }

    public Vector getValues(String string) {
        return null;
    }

    public double getValue(String string, int n) {
        Vector vector = (Vector)this.mapWorldValues.get(string);
        Object e = vector.get(n);
        try {
            Double d = new Double(e.toString());
            return d;
        }
        catch (Exception exception) {
            return Double.MIN_VALUE;
        }
    }
}

