/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.simulation.scheduling;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.xml.parsers.DocumentBuilderFactory;
import madkit.kernel.Activator;
import madkit.kernel.SynchroScheduler;
import madkit.simulation.activators.TurboMethodActivator;
import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.ZoneSelector;
import modulecoFramework.simulation.scheduling.EarlyCommitActivator;
import modulecoFramework.simulation.scheduling.LateCommitActivator;
import modulecoFramework.simulation.scheduling.ModulecoActivator;
import modulecoFramework.simulation.scheduling.ModulecoDiscreteEventActivator;
import modulecoFramework.simulation.scheduling.SimEvent;
import modulecoFramework.simulation.scheduling.WorldActivator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModulecoScheduler
extends SynchroScheduler {
    private static final long serialVersionUID = 6999716090701729806L;
    public static final String EARLY_COMMIT_MODE = "earlyCommit";
    public static final String LATE_COMMIT_MODE = "lateCommit";
    public static final String DISCRETE_EVENT_MODE = "eventBased";
    SortedSet agentsActivators = new TreeSet();
    TurboMethodActivator worldActivator;
    TurboMethodActivator interfaceActivator;
    TurboMethodActivator watcherActivator;
    protected List eventList = new ArrayList();
    public static double GVT = 0.0;
    protected double simulationDuration;
    protected EWorld world;
    protected ZoneSelector zs;

    public void setZoneSelector(ZoneSelector zoneSelector) {
        this.zs = zoneSelector;
        this.world = zoneSelector.getWorld();
    }

    public void activate() {
        GVT = 0.0;
        this.requestRole("moduleco", "engine", "scheduler", null);
        this.watcherActivator = new TurboMethodActivator("observeAgents", "moduleco", "WatcherGroup", "WatcherRole");
        this.interfaceActivator = new TurboMethodActivator("updateImage", "moduleco", "engine", "worldListener");
        this.addModulecoActivator(new WorldActivator("environment", Integer.MAX_VALUE, (Activator)this.watcherActivator, (Activator)this.interfaceActivator));
        this.addActivator((Activator)this.watcherActivator);
        this.addActivator((Activator)this.interfaceActivator);
        this.loadSchecdulingParameters();
    }

    public void step() {
        this.executeNextEvent();
    }

    public void loadSchecdulingParameters() {
        String string = null;
        File file = Moduleco.getParametersFile();
        String string2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            Element element = (Element)document.getDocumentElement().getElementsByTagName("scheduling").item(0);
            NodeList nodeList = element.getElementsByTagName("role");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                this.createActivator(element2.getAttribute("name"), element2.getAttribute("activationType"), Integer.parseInt(element2.getAttribute("activationOrder")));
            }
            string = ((Element)nodeList.item(0)).getAttribute("name");
            string2 = ((Element)nodeList.item(0)).getAttribute("nbOfSimulations");
        }
        catch (IOException iOException) {
            System.err.println("File read error with !\n" + file.getName());
        }
        catch (SAXException sAXException) {
            System.err.println("Parsing error of the file !\n" + file.getName());
        }
        catch (Exception exception) {
            System.err.println("XML problem !\n" + file.getName());
            exception.printStackTrace();
        }
    }

    public void createActivator(String string, String string2, int n) {
        ModulecoActivator modulecoActivator = string2.equals(EARLY_COMMIT_MODE) ? new EarlyCommitActivator(string, n) : (string2.equals(LATE_COMMIT_MODE) ? new LateCommitActivator(string, n) : new ModulecoDiscreteEventActivator(string, n));
        this.addModulecoActivator(modulecoActivator);
    }

    public DefaultListModel getEventList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        Iterator iterator = this.agentsActivators.iterator();
        while (iterator.hasNext()) {
            defaultListModel.addElement(((Activator)iterator.next()).getRole());
        }
        return defaultListModel;
    }

    public void addEvent(SimEvent simEvent) {
        int n = Collections.binarySearch(this.eventList, simEvent) + 1;
        if (n <= 0) {
            this.eventList.add(-n, simEvent);
        } else {
            this.eventList.add(n, simEvent);
        }
    }

    public boolean executeNextEvent() {
        SimEvent simEvent = null;
        if (!this.eventList.isEmpty()) {
            simEvent = (SimEvent)this.eventList.remove(0);
        }
        if (simEvent != null) {
            GVT = simEvent.getOccurrenceDate();
            SimEvent simEvent2 = ((ModulecoActivator)simEvent.getSource()).execute(GVT, simEvent);
            if (simEvent2 != null) {
                this.addEvent(simEvent2);
            }
            return false;
        }
        return true;
    }

    public void addModulecoActivator(Activator activator) {
        this.addActivator(activator);
        this.agentsActivators.add(activator);
        if (activator instanceof EarlyCommitActivator || activator instanceof LateCommitActivator) {
            this.addEvent(new SimEvent(activator, GVT));
        } else {
            List list = ((ModulecoDiscreteEventActivator)activator).initializeEvents(GVT);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addEvent((SimEvent)iterator.next());
            }
        }
    }

    public static double getGVT() {
        return GVT;
    }
}

