/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.simulation;

import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.WorldListener;
import modulecoFramework.modeleco.ZoneSelector;
import modulecoFramework.simulation.scheduling.ModulecoScheduler;

public class SimulationControl
extends Agent {
    private static final long serialVersionUID = -512994355855853403L;
    protected transient boolean runnable = false;
    protected EWorld eWorld;
    protected ModulecoScheduler ts;
    protected ZoneSelector zs;
    protected int iter = 0;
    private int simulationDuration = Integer.MAX_VALUE;
    public String tsClass;
    public String zsClass;
    public WorldListener worldListener;

    public SimulationControl(EWorld eWorld, WorldListener worldListener, String string) {
        this.eWorld = eWorld;
        this.worldListener = worldListener;
        this.zsClass = string;
    }

    public void buildScheduler() {
        this.eWorld.setSimulationControl(this);
        try {
            this.zs = (ZoneSelector)Moduleco.getClass(this.zsClass).newInstance();
            this.zs.setWorld(this.eWorld);
            this.ts = new ModulecoScheduler();
            this.launchAgent((AbstractAgent)this.ts, "ModulecoScheduler", false);
            this.ts.setZoneSelector(this.zs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initSimulation() {
        this.eWorld.connectAll();
        this.eWorld.initAll();
        this.eWorld.compute();
    }

    public void progress() {
        this.ts.step();
    }

    public void live() {
        while (true) {
            this.exitImmediatlyOnKill();
            while (!this.runnable) {
                this.exitImmediatlyOnKill();
                this.pause(10);
            }
            Thread.yield();
            this.iter = (int)ModulecoScheduler.getGVT();
            if (this.getSimulationDuration() > this.iter) {
                this.pause(1);
                this.progress();
                continue;
            }
            this.sendMessage("moduleco", "engine", "modulecoAgent", new Message());
            this.runnable = false;
        }
    }

    public void start() {
        this.runnable = true;
    }

    public void stop() {
        this.runnable = false;
    }

    public void terminate() {
        this.killAgent((AbstractAgent)this.ts);
        this.killAgent((AbstractAgent)this);
        this.eWorld.terminate();
    }

    public int getIter() {
        return this.iter;
    }

    public void activate() {
        this.requestRole("moduleco", "engine", "simulationControl", null);
    }

    public void end() {
        System.err.println("" + ((Object)((Object)this)).toString() + " ending !!");
    }

    public int getSimulationDuration() {
        return this.simulationDuration;
    }

    public void setSimulationDuration(int n) {
        this.simulationDuration = n;
    }
}

