/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.simulation;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import madkit.kernel.AbstractAgent;
import madkit.system.MadkitOutput;
import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.ModelParameters;
import modulecoFramework.modeleco.WorldListener;
import modulecoFramework.simulation.SimulationControl;
import modulecoFramework.utils.ModelReader;
import modulecoFramework.utils.ModelWriter;
import modulecoFramework.utils.dataRecorder.Recorder;
import modulecoFramework.utils.dataRecorder.StatRecorder;
import modulecoFramework.utils.graphicalWatcher.GraphicalWatcher;
import modulecoGUI.CentralControl;

public class ModulecoLauncher
extends AbstractAgent {
    private static final long serialVersionUID = 1L;
    protected CentralControl centralControl;
    protected SimulationControl simulationControl;
    protected EWorld eWorld;
    protected String model;
    protected ModelParameters modelParameters;
    protected WorldListener worldListener;
    GraphicalWatcher graphicalWatcher;
    Recorder recorder;
    StatRecorder statRecorder;
    MadkitOutput madkitOutput;

    public void setCentralControl(CentralControl centralControl) {
        this.centralControl = centralControl;
    }

    public void create(String string) {
        String string2 = Moduleco.getCurrentModelName();
        Moduleco.setCurrentModelName(string);
        this.reset();
        try {
            Class clazz = Moduleco.getClass("models." + string + ".World");
            Constructor constructor = clazz.getConstructor(new Class[0]);
            try {
                this.eWorld = (EWorld)constructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println(invocationTargetException.getTargetException().toString());
            }
            try {
                String string3 = this.eWorld.getClass().getPackage().getName().replace(".", File.separator);
                if (string.equals(string2)) {
                    this.readModelParameters(new File(string3 + File.separator + "temp.parameters"));
                } else {
                    this.readModelParameters(new File(string3 + File.separator + string + ".parameters"));
                }
            }
            catch (Exception exception) {
                System.out.println("BE CARREFUL : Moduleco can't find parameters' file for model " + Moduleco.getCurrentModelName());
            }
            this.modelParameters = this.eWorld.getModelParameters();
            if (this.modelParameters == null) {
                this.modelParameters = new ModelParameters(string);
                this.eWorld.setModelParameters(this.modelParameters);
            }
            this.launchAgent((AbstractAgent)this.eWorld, "world", false);
            this.createWorldListener();
        }
        catch (Exception exception) {
            System.out.println("[ModulecoLauncher.create()] Exception: " + exception.toString());
            exception.printStackTrace();
        }
    }

    protected void createWorldListener() {
        this.worldListener = new WorldListener(this.eWorld, this.modelParameters, this.centralControl);
        this.launchAgent(this.worldListener, "world listener", false);
    }

    public void reload() {
        this.simulationControl.terminate();
        this.reset();
    }

    public void launch() {
        this.worldListener.setModelParameters(this.modelParameters);
        String string = "modulecoFramework.modeleco.zone." + this.modelParameters.getNeighbourhood();
        String string2 = "modulecoFramework.modeleco.zone." + this.modelParameters.getZone();
        this.eWorld.build();
        this.eWorld.initializeMedium();
        this.eWorld.populateAll(string);
        this.simulationControl = new SimulationControl(this.eWorld, this.worldListener, string2);
        this.launchAgent((AbstractAgent)this.simulationControl, "controler", false);
        this.simulationControl.buildScheduler();
        this.simulationControl.initSimulation();
        String string3 = this.eWorld.getClass().getPackage().getName().replace(".", File.separator);
        this.writeModelParameters(new File(string3 + File.separator + "temp.parameters"));
        this.runNewGraphicalWatcher();
        this.record();
    }

    public EWorld getEWorld() {
        return this.eWorld;
    }

    public SimulationControl getSimulationControl() {
        return this.simulationControl;
    }

    public ModelParameters getModelParameters() {
        return this.modelParameters;
    }

    public void activate() {
        this.println("activated");
        this.requestRole("moduleco", "engine", "modulecoLauncher", null);
    }

    public JPanel getOutputGUI() {
        if (this.madkitOutput != null) {
            return (JPanel)this.madkitOutput.getGUIObject();
        }
        return null;
    }

    public void end() {
        this.reset();
        this.println("ended");
    }

    public void reset() {
        this.killAgent((AbstractAgent)this.eWorld);
        this.killAgent((AbstractAgent)this.simulationControl);
        this.killAgent((AbstractAgent)this.graphicalWatcher);
        this.killAgent((AbstractAgent)this.recorder);
        this.killAgent(this.worldListener);
    }

    public void writeModelParameters(File file) {
        ModelWriter modelWriter = new ModelWriter(this.eWorld);
        modelWriter.record(file);
    }

    public void readModelParameters(File file) {
        ModelReader modelReader = new ModelReader(this.eWorld);
        modelReader.read(file);
    }

    public void runNewGraphicalWatcher() {
        this.graphicalWatcher = new GraphicalWatcher();
        this.launchAgent((AbstractAgent)this.graphicalWatcher, "Watcher", false);
    }

    public GraphicalWatcher getGraphicalWatcher() {
        return this.graphicalWatcher;
    }

    public void loadDefaultModel(String string) {
        this.centralControl.loadDefaultModel("seminaire");
    }

    protected void record() {
        this.recorder = new Recorder();
        this.launchAgent((AbstractAgent)this.recorder, "Recorder", false);
        this.recorder.recordAllAgentProperty();
        this.recorder.recordAllWorldProperty();
        this.recorder.observeAgents();
        this.statRecorder = new StatRecorder();
        this.launchAgent((AbstractAgent)this.statRecorder, "StatRecorder", false);
        this.statRecorder.observeAgents();
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public StatRecorder getStatRecorder() {
        return this.statRecorder;
    }
}

