/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework.modeleco;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;
import modulecoFramework.Moduleco;
import modulecoFramework.medium.Medium;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.CAutorun;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.ModelParameters;
import modulecoFramework.modeleco.ZoneSelector;
import modulecoFramework.simulation.SimulationControl;

public abstract class EWorld
extends Watcher
implements ReferenceableAgent,
CAgent,
Serializable {
    protected ZoneSelector[] connectionsStrategies;
    protected Medium[] mediumsInWorld;
    protected CAgent[] extraAgents = new CAgent[0];
    protected int agentID;
    public int length;
    public int agentSetSize;
    public SimulationControl simulationControl;
    public ArrayList agentSet;
    protected Medium[] mediums;
    protected EWorld worldMother;
    public String[] inputParameters;
    public String[] outputParameters;
    public String[] outputGraphics;
    public ModelParameters modelParameters;
    public HashMap hashMapChoiceValue;
    public HashMap hashMapChoiceString;

    public EWorld() {
        System.out.println("-->EWorld()");
        this.setWorld(this);
        this.inputParameters = new String[0];
        this.outputParameters = new String[0];
        this.outputGraphics = new String[]{"Canevas", "Graphique"};
        this.hashMapChoiceString = new HashMap();
        this.hashMapChoiceValue = new HashMap();
    }

    public void build() {
        System.out.println("-->EWorld.build()");
        this.length = this.modelParameters.length;
        this.agentSetSize = this.length * this.length;
        this.agentSet = new ArrayList(this.agentSetSize);
    }

    public void setModelParameters(ModelParameters modelParameters) {
        this.modelParameters = modelParameters;
        this.length = modelParameters.length;
        this.agentSetSize = this.length * this.length;
        this.agentSet = new ArrayList(this.agentSetSize);
    }

    public ModelParameters getModelParameters() {
        return this.modelParameters;
    }

    public void activate() {
        System.out.println("-->EWorld.activate()");
        this.createGroup(false, "moduleco", "model", null, null);
        this.createGroup(false, "moduleco", "ecoAgent", null, null);
        this.requestRole("moduleco", "model", "environment", null);
        this.requestRole("moduleco", "ecoAgent", "environment", null);
    }

    public void end() {
        Iterator iterator = this.agentSet.iterator();
        while (iterator.hasNext()) {
            this.killAgent((AbstractAgent)iterator.next());
        }
    }

    public void populateAll(String string) {
        System.out.println("-->EWorld.populateAll()");
        this.populate();
    }

    public void populate() {
        System.out.println("-->EWorld.populate()");
    }

    public void connectAll() {
        System.out.println("-->EWorld.connectAll()");
        this.connect();
    }

    public void connect() {
        System.out.println("-->EWorld.connect()");
    }

    public void initAll() {
        System.out.println("-->EWorld.InitAll()");
        Iterator iterator = this.agentSet.iterator();
        while (iterator.hasNext()) {
            ((EAgent)iterator.next()).init();
        }
        if (this.extraAgents != null) {
            for (int i = 0; i < this.extraAgents.length; ++i) {
                this.extraAgents[i].init();
            }
        }
        if (this.mediumsInWorld != null) {
            for (int i = 0; i < this.mediumsInWorld.length; ++i) {
                this.mediumsInWorld[i].init();
            }
        }
        this.init();
    }

    public void init() {
        System.out.println("-->EWorld.init()");
    }

    public void compute() {
        System.out.println("-->EWorld.compute()");
    }

    public void commitAll() {
        System.out.println("-->EWorld.commitAll()");
        this.compute();
        this.commit();
    }

    public void commit() {
        System.out.println("-->EWorld.commit()");
    }

    public void terminate() {
        System.out.println("EWorld.terminate()");
        List list = this.getAgentsRefWithRole("basicAgent");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.killAgent((AbstractAgent)iterator.next());
        }
        this.agentSet.clear();
    }

    public void cleanup() {
        System.out.println("eWorld.cleanup()");
    }

    public int getIter() {
        System.out.println("eWorld.getIter()");
        return this.simulationControl.getIter();
    }

    public Object get(int n) {
        return this.agentSet.get(n);
    }

    public Iterator iterator() {
        return this.getAgentsRefWithRole("basicAgent").iterator();
    }

    public EAgent addAgent(String string) {
        EAgent eAgent = null;
        try {
            eAgent = (EAgent)Moduleco.getClass(this.pack() + "." + string).newInstance();
            eAgent.setWorld(this);
            eAgent.setAgentID(this.agentSet.size());
            this.agentSet.add(eAgent);
            this.launchAgent(eAgent, "modulecoAgent" + (this.agentSet.size() - 1), false);
        }
        catch (Exception exception) {
            System.err.println("Unable to launch agent " + string + " " + exception);
            exception.printStackTrace();
        }
        return eAgent;
    }

    public int getIndex(CAgent cAgent) {
        return this.agentSet.indexOf(cAgent);
    }

    public int size() {
        return this.agentSet.size();
    }

    public ArrayList getAgents() {
        return this.agentSet;
    }

    public void inverseState() {
    }

    public CAutorun createAutorun() {
        return null;
    }

    public Object getState() {
        return null;
    }

    public CAgent[] getExtraAgents() {
        return this.extraAgents;
    }

    public Medium[] getMediums() {
        return this.mediums;
    }

    public EWorld getWorld() {
        return this.worldMother;
    }

    public int getAgentSetSize() {
        return this.agentSetSize;
    }

    public int getLength() {
        return this.length;
    }

    public String pack() {
        String string = this.getClass().getName();
        return string.substring(0, string.lastIndexOf(46));
    }

    public String getPackageName() {
        return this.getClass().getPackage().getName();
    }

    public int getAgentID() {
        return -1;
    }

    public void setWorld(EWorld eWorld) {
        this.worldMother = eWorld;
    }

    public void setAgentID(int n) {
        this.agentID = n;
    }

    public void setSimulationControl(SimulationControl simulationControl) {
        this.simulationControl = simulationControl;
    }

    public void playRole(String string) {
        this.requestRole("moduleco", "ecoAgent", string, null);
    }

    public void leaveRole(String string) {
        this.leaveRole("moduleco", "ecoAgent", string);
    }

    public List getAgentsRefWithRole(String string) {
        try {
            Probe probe = new Probe("moduleco", "ecoAgent", string);
            this.addProbe(probe);
            List list = probe.getCurrentAgentsList();
            this.removeAllProbes();
            return list;
        }
        catch (Exception exception) {
            return new ArrayList();
        }
    }

    public void initializeMedium() {
    }

    public double nextEventDeltaTime() {
        return 1.0;
    }

    public void addInputParameters(String string) {
        String[] stringArray = this.inputParameters;
        this.inputParameters = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            this.inputParameters[i] = stringArray[i];
        }
        this.inputParameters[stringArray.length] = string;
    }

    public void addInputParameters(String[] stringArray) {
        int n;
        String[] stringArray2 = this.inputParameters;
        this.inputParameters = new String[stringArray2.length + stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            this.inputParameters[n] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.inputParameters[stringArray2.length + n] = stringArray[n];
        }
    }

    public void clearInputParameters() {
        this.inputParameters = new String[0];
    }

    public void addOutputParameters(String string) {
        String[] stringArray = this.outputParameters;
        this.outputParameters = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            this.outputParameters[i] = stringArray[i];
        }
        this.outputParameters[stringArray.length] = string;
    }

    public void addOutputParameters(String[] stringArray) {
        int n;
        String[] stringArray2 = this.outputParameters;
        this.outputParameters = new String[stringArray2.length + stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            this.outputParameters[n] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.outputParameters[stringArray2.length + n] = stringArray[n];
        }
    }

    public void clearOutputParameters() {
        this.outputParameters = new String[0];
    }

    public void addOutputGraphics(String string) {
        String[] stringArray = this.outputGraphics;
        this.outputGraphics = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            this.outputGraphics[i] = stringArray[i];
        }
        this.outputGraphics[stringArray.length] = string;
    }

    public void addOutputGraphics(String[] stringArray) {
        int n;
        String[] stringArray2 = this.outputGraphics;
        this.outputGraphics = new String[stringArray2.length + stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            this.outputGraphics[n] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.outputGraphics[stringArray2.length + n] = stringArray[n];
        }
    }

    public void clearOutputGraphics() {
        this.outputGraphics = new String[0];
    }

    public void addInputParametersChoices(String string, String[] stringArray, Object[] objectArray) {
        this.hashMapChoiceString.put(string, stringArray);
        this.hashMapChoiceValue.put(string, objectArray);
    }
}

