/*
 * Decompiled with CFR 0.152.
 */
package modulecoFramework;

import madkit.kernel.AbstractAgent;
import modulecoFramework.modeleco.CAutorun;
import modulecoFramework.modeleco.EWorld;
import modulecoFramework.simulation.ModulecoLauncher;
import modulecoFramework.simulation.SimulationControl;
import modulecoFramework.utils.ExistingModels;

public class Core
extends AbstractAgent {
    protected ModulecoLauncher modulecoLauncher;
    protected SimulationControl simulationControl;
    protected static ExistingModels modelsList;
    protected static boolean withGUI;
    protected static String model;
    protected static int noSimulations;

    public void activate() {
        this.requestRole("moduleco", "engine", "coreAgent", null);
    }

    public void initModel(boolean bl, String string, ModulecoLauncher modulecoLauncher) {
        this.modulecoLauncher = modulecoLauncher;
        System.out.println("[Core()] (model, withGUI) = (" + string + ", " + bl + ")");
        if (!bl) {
            int n = 1;
            for (int i = 0; i < n; ++i) {
                this.modulecoLauncher.create(string);
                this.modulecoLauncher.launch();
                EWorld eWorld = this.modulecoLauncher.getEWorld();
                this.simulationControl = this.modulecoLauncher.getSimulationControl();
                CAutorun cAutorun = eWorld.createAutorun();
                if (cAutorun != null) {
                    cAutorun.setSimulationControl(this.simulationControl);
                    cAutorun.run();
                    continue;
                }
                System.out.println("BE CAREFUL: there is no Autorun in the model you have launched.\nThe simulation has now started, but might never terminate.");
                this.simulationControl.start();
            }
        }
    }

    private static void doUsage() {
        int n = modelsList.getNoModels();
        int n2 = 4;
        String string = "\t\t\t\t";
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            string = string + modelsList.getName(i) + ", ";
            if (++n3 < n2) continue;
            string = string + "\n\t\t\t\t";
            n3 = 0;
        }
        System.out.println("USAGE\n\tCore [OPTIONS] [MODEL]");
        System.out.println("OPTIONS\n\t-n, --noGUI\tRun Moduleco in comand-line. The GUI is enabled by default.");
        System.out.println("MODEL\n\tmodel\t\tName of the model to launch. Existing models:");
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        modelsList = new ExistingModels();
        if (stringArray.length > 0) {
            withGUI = false;
            if (stringArray[0].startsWith("-n") || stringArray[0].startsWith("--noGUI")) {
                if (stringArray.length > 1) {
                    if (modelsList.exists(stringArray[1])) {
                        model = stringArray[1];
                        if (stringArray.length > 2) {
                            noSimulations = Integer.parseInt(stringArray[2]);
                        }
                    } else {
                        System.out.println("\n" + stringArray[1] + " is not a valid model name.\n");
                        Core.doUsage();
                        System.exit(0);
                    }
                } else {
                    System.out.println("\nPlease provide a model name.\n");
                    Core.doUsage();
                    System.exit(0);
                }
            } else {
                System.out.println("\n" + stringArray[0] + " is not a valid option.\n");
                Core.doUsage();
                System.exit(0);
            }
        }
    }

    public void printCopyright() {
        System.out.println("Moduleco\nBeta version 1.5 - 19/04/2004");
        System.out.println("Created by Antoine Beugnard & Denis Phan - ENST-Bretagne");
        System.out.println("Maintained by Gilles Daniel & Denis Phan");
        System.out.println("Adapted to MadKit by Jacques Ferber");
        System.out.println("Please update this version by download the latest version at:");
        System.out.println("http://www.cs.man.ac.uk/ai/public/moduleco");
        System.out.println("http://www-eco.enst-bretagne.fr/~phan/moduleco");
    }

    static {
        withGUI = true;
        model = null;
        noSimulations = 1;
    }
}

