/*
 * Decompiled with CFR 0.152.
 */
package jsynedit.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jedit.textarea.JEditTextArea;
import jsynedit.AbstractDoc;
import jsynedit.AbstractEditorPanel;
import jsynedit.search.AbstractDisposer;
import jsynedit.search.JextCheckBox;
import jsynedit.search.JextHighlightButton;
import jsynedit.search.ModifiedCellRenderer;
import jsynedit.search.Search;
import jsynedit.search.UUtilities;

public class FindReplace
extends JDialog
implements ActionListener {
    public static final int SEARCH = 1;
    public static final int REPLACE = 2;
    private int type;
    private AbstractEditorPanel parent;
    private JComboBox fieldSearch;
    private JComboBox fieldReplace;
    private JTextField fieldSearchEditor;
    private JTextField fieldReplaceEditor;
    private JTextField script;
    private JextHighlightButton btnFind;
    private JextHighlightButton btnReplace;
    private JextHighlightButton btnReplaceAll;
    private JextHighlightButton btnCancel;
    private JextCheckBox checkIgnoreCase;
    private JextCheckBox saveStates;
    private JextCheckBox useRegexp;
    private JextCheckBox allFiles;
    private JextCheckBox scripted;

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
    }

    public FindReplace(AbstractEditorPanel abstractEditorPanel, int n, boolean bl) {
        this.parent = abstractEditorPanel;
        this.type = n;
        this.fieldSearch = new JComboBox();
        this.fieldSearch.setRenderer(new ModifiedCellRenderer());
        this.fieldSearch.setEditable(true);
        this.fieldReplace = new JComboBox();
        this.fieldReplace.setRenderer(new ModifiedCellRenderer());
        this.fieldReplace.setEditable(true);
        KeyHandler keyHandler = new KeyHandler();
        this.fieldSearchEditor = (JTextField)this.fieldSearch.getEditor().getEditorComponent();
        this.fieldSearchEditor.addKeyListener(keyHandler);
        this.fieldReplaceEditor = (JTextField)this.fieldReplace.getEditor().getEditorComponent();
        this.fieldReplaceEditor.addKeyListener(keyHandler);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel jLabel = new JLabel("Find label");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 25, 50);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 25, 50);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.fieldSearch, gridBagConstraints);
        this.getContentPane().add(this.fieldSearch);
        this.btnFind = new JextHighlightButton("Find");
        this.btnFind.setToolTipText("find.tip");
        this.btnFind.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 25, 50);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.btnFind, gridBagConstraints);
        this.getContentPane().add(this.btnFind);
        this.getRootPane().setDefaultButton(this.btnFind);
        this.btnCancel = new JextHighlightButton("Cancel");
        this.btnCancel.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 25, 50);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.btnCancel, gridBagConstraints);
        this.getContentPane().add(this.btnCancel);
        JLabel jLabel2 = new JLabel("Replace with");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 25, 50);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.getContentPane().add(jLabel2);
        if (n != 2) {
            jLabel2.setEnabled(false);
        }
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 25, 50);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.fieldReplace, gridBagConstraints);
        this.getContentPane().add(this.fieldReplace);
        if (n != 2) {
            this.fieldReplace.setEnabled(false);
        }
        this.btnReplace = new JextHighlightButton("Replace");
        this.btnReplace.setToolTipText("replace.tip");
        if (n != 2) {
            this.btnReplace.setEnabled(false);
        }
        this.btnReplace.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 25, 50);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.btnReplace, gridBagConstraints);
        this.getContentPane().add(this.btnReplace);
        this.btnReplaceAll = new JextHighlightButton("Replace All");
        this.btnReplaceAll.setToolTipText("replace.all.tip");
        if (n != 2) {
            this.btnReplaceAll.setEnabled(false);
        }
        this.btnReplaceAll.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 25, 50);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.btnReplaceAll, gridBagConstraints);
        this.getContentPane().add(this.btnReplaceAll);
        this.scripted = new JextCheckBox("replace.script", Search.getPythonScript());
        if (n != 2) {
            this.scripted.setEnabled(false);
        } else {
            this.fieldReplace.setEnabled(!this.scripted.isSelected());
            this.scripted.addActionListener(this);
        }
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 50, 50);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.scripted, gridBagConstraints);
        this.getContentPane().add(this.scripted);
        this.script = new JTextField();
        if (n != 2) {
            this.script.setEnabled(false);
        } else {
            this.script.setEnabled(this.scripted.isSelected());
        }
        this.script.setText(Search.getPythonScriptString());
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 50, 50);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.script, gridBagConstraints);
        this.getContentPane().add(this.script);
        this.checkIgnoreCase = new JextCheckBox("Ignore Case", Search.getIgnoreCase());
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 25, 50);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.checkIgnoreCase, gridBagConstraints);
        this.getContentPane().add(this.checkIgnoreCase);
        JPanel jPanel = new JPanel();
        this.saveStates = new JextCheckBox("Save Values", true);
        this.allFiles = new JextCheckBox("In All Files", false);
        jPanel.add(this.saveStates);
        jPanel.add(this.allFiles);
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 25, 50);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.useRegexp = new JextCheckBox("Use Extended RegExp", Search.getRegexp());
        this.buildConstraints(gridBagConstraints, 2, 3, 2, 1, 50, 50);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.useRegexp, gridBagConstraints);
        this.getContentPane().add(this.useRegexp);
        this.load();
        this.setDefaultCloseOperation(0);
        this.addKeyListener(new AbstractDisposer(this));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FindReplace.this.exit();
            }
        });
        this.pack();
        this.setResizable(false);
        UUtilities.centerComponentChild(abstractEditorPanel, this);
        this.btnFind.addKeyListener(keyHandler);
        this.btnReplace.addKeyListener(keyHandler);
        this.btnReplaceAll.addKeyListener(keyHandler);
        this.btnCancel.addKeyListener(keyHandler);
        this.checkIgnoreCase.addKeyListener(keyHandler);
        this.saveStates.addKeyListener(keyHandler);
        this.useRegexp.addKeyListener(keyHandler);
        this.allFiles.addKeyListener(keyHandler);
        this.scripted.addKeyListener(keyHandler);
        this.script.addKeyListener(keyHandler);
        this.setLocation(50, 50);
    }

    private void load() {
        String string;
        for (int i = 0; i < 25 && (string = "search.history." + i) != null; ++i) {
            this.fieldSearch.addItem(string);
        }
        AbstractDoc abstractDoc = this.parent.getTextArea();
        string = Search.getFindPattern();
        if (string != null) {
            this.addSearchHistory(string);
            this.fieldSearch.setSelectedItem(string);
        }
        if (this.type == 2) {
            for (int i = 0; i < 25 && (string = "replace.history." + i) != null; ++i) {
                this.fieldReplace.addItem(string);
            }
            string = Search.getReplacePattern();
            if (string != null) {
                this.addReplaceHistory(string);
                this.fieldReplace.setSelectedItem(string);
            }
        }
        this.fieldSearchEditor.selectAll();
    }

    private void exit() {
        Search.setIgnoreCase(this.checkIgnoreCase.isSelected());
        Search.setRegexp(this.useRegexp.isSelected());
        this.dispose();
    }

    private void addSearchHistory() {
        this.addSearchHistory(this.fieldSearchEditor.getText());
    }

    private void addSearchHistory(String string) {
        int n;
        if (string == null) {
            return;
        }
        for (n = 0; n < this.fieldSearch.getItemCount(); ++n) {
            if (!((String)this.fieldSearch.getItemAt(n)).equals(string)) continue;
            return;
        }
        this.fieldSearch.insertItemAt(string, 0);
        if (this.fieldSearch.getItemCount() > 25) {
            n = 25;
            while (n < this.fieldSearch.getItemCount()) {
                this.fieldSearch.removeItemAt(n);
            }
        }
        this.fieldSearchEditor.setText((String)this.fieldSearch.getItemAt(0));
    }

    private void addReplaceHistory() {
        this.addReplaceHistory(this.fieldReplaceEditor.getText());
    }

    private void addReplaceHistory(String string) {
        int n;
        if (string == null) {
            return;
        }
        for (n = 0; n < this.fieldReplace.getItemCount(); ++n) {
            if (!((String)this.fieldReplace.getItemAt(n)).equals(string)) continue;
            return;
        }
        this.fieldReplace.insertItemAt(string, 0);
        if (this.fieldReplace.getItemCount() > 25) {
            n = 25;
            while (n < this.fieldReplace.getItemCount()) {
                this.fieldReplace.removeItemAt(n);
            }
        }
        this.fieldReplaceEditor.setText((String)this.fieldReplace.getItemAt(0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnCancel) {
            this.exit();
        } else if (object == this.btnFind) {
            this.doFind();
        } else if (object == this.btnReplace) {
            this.doReplace();
        } else if (object == this.btnReplaceAll) {
            this.doReplaceAll();
        } else if (object == this.scripted) {
            this.script.setEnabled(this.scripted.isSelected());
            this.fieldReplace.setEnabled(!this.scripted.isSelected());
        }
    }

    private void setSettings() {
        Search.setFindPattern(this.fieldSearchEditor.getText());
        Search.setIgnoreCase(this.checkIgnoreCase.isSelected());
        Search.setRegexp(this.useRegexp.isSelected());
        if (this.type == 2) {
            Search.setReplacePattern(this.fieldReplaceEditor.getText());
            Search.setPythonScript(this.scripted.isSelected());
            Search.setPythonScriptString(this.script.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReplaceAll() {
        UUtilities.setCursorOnWait(this, true);
        this.addReplaceHistory();
        this.addSearchHistory();
        try {
            if (this.allFiles.isSelected()) {
                AbstractDoc[] abstractDocArray = this.parent.getTextAreas();
                for (int i = 0; i < abstractDocArray.length; ++i) {
                    AbstractDoc abstractDoc = abstractDocArray[i];
                    this.setSettings();
                    Search.replaceAll(abstractDoc, 0, this.parent.getTextArea().getDocument().getLength());
                }
            } else {
                AbstractDoc abstractDoc = this.parent.getTextArea();
                this.setSettings();
                if (Search.replaceAll(abstractDoc, 0, this.parent.getTextArea().getDocument().getLength()) == 0) {
                    UUtilities.beep();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            UUtilities.setCursorOnWait(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReplace() {
        UUtilities.setCursorOnWait(this, true);
        this.addReplaceHistory();
        this.addSearchHistory();
        try {
            AbstractDoc abstractDoc = this.parent.getTextArea();
            this.setSettings();
            if (!Search.replace(abstractDoc)) {
                UUtilities.beep();
            } else {
                this.find(abstractDoc);
            }
        }
        catch (Exception exception) {
        }
        finally {
            UUtilities.setCursorOnWait(this, false);
        }
    }

    private void doFind() {
        UUtilities.setCursorOnWait(this, true);
        this.addSearchHistory();
        this.find(this.parent.getTextArea());
        UUtilities.setCursorOnWait(this, false);
    }

    private void find(JEditTextArea jEditTextArea) {
        block10: {
            this.setSettings();
            try {
                if (Search.find(jEditTextArea, jEditTextArea.getCaretPosition())) break block10;
                int n = 1;
                n = JOptionPane.showConfirmDialog(null, "Match not found in {0}.\nRestart from beginning ?", "find", 0, 3);
                switch (n) {
                    case 0: {
                        jEditTextArea.setCaretPosition(0);
                        this.find(jEditTextArea);
                        break;
                    }
                    case 1: {
                        if (!this.allFiles.isSelected()) break;
                        JTabbedPane jTabbedPane = this.parent.getTabbedPane();
                        int n2 = jTabbedPane.indexOfComponent(jEditTextArea);
                        Component component = null;
                        while (component == null && !(component instanceof JEditTextArea)) {
                            if (++n2 == jTabbedPane.getTabCount()) {
                                n2 = 0;
                            }
                            component = jTabbedPane.getComponentAt(n2);
                        }
                        JEditTextArea jEditTextArea2 = (JEditTextArea)component;
                        if (jEditTextArea2 != jEditTextArea) {
                            this.find(jEditTextArea2);
                        }
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.parent = null;
        this.fieldSearch = null;
        this.fieldReplace = null;
        this.fieldSearchEditor = null;
        this.fieldReplaceEditor = null;
        this.btnFind = null;
        this.btnReplace = null;
        this.btnReplaceAll = null;
        this.btnCancel = null;
        this.checkIgnoreCase = null;
        this.saveStates = null;
        this.useRegexp = null;
        this.allFiles = null;
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    if (keyEvent.getSource() == FindReplace.this.fieldSearchEditor) {
                        FindReplace.this.doFind();
                        break;
                    }
                    if (keyEvent.getSource() != FindReplace.this.fieldReplaceEditor) break;
                    FindReplace.this.doReplace();
                    break;
                }
                case 27: {
                    FindReplace.this.exit();
                }
            }
        }
    }
}

