/*
 * Decompiled with CFR 0.152.
 */
package jsynedit;

import gnu.actions.BoxComment;
import gnu.actions.BoxUncomment;
import gnu.actions.CreateTemplate;
import gnu.actions.LeftIndent;
import gnu.actions.Print;
import gnu.actions.RemoveWhitespace;
import gnu.actions.RightIndent;
import gnu.actions.SimpleComment;
import gnu.actions.SimpleUnComment;
import gnu.actions.ToLowerCase;
import gnu.actions.ToUpperCase;
import gnu.java.Beautifier;
import gnu.jbrowser.InsertClassName;
import gnu.options.OptionsDialog;
import gnu.search.FindAll;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jedit.InputHandler;
import jedit.lang.BatchFileTokenMarker;
import jedit.lang.CCTokenMarker;
import jedit.lang.CTokenMarker;
import jedit.lang.EiffelTokenMarker;
import jedit.lang.HTMLTokenMarker;
import jedit.lang.IDLTokenMarker;
import jedit.lang.JavaScriptTokenMarker;
import jedit.lang.JavaTokenMarker;
import jedit.lang.JessTokenMarker;
import jedit.lang.KawaTokenMarker;
import jedit.lang.LispTokenMarker;
import jedit.lang.PHPTokenMarker;
import jedit.lang.PatchTokenMarker;
import jedit.lang.PerlTokenMarker;
import jedit.lang.PropsTokenMarker;
import jedit.lang.PythonTokenMarker;
import jedit.lang.SchemeTokenMarker;
import jedit.lang.ShellScriptTokenMarker;
import jedit.lang.TeXTokenMarker;
import jedit.lang.XMLTokenMarker;
import jsynedit.AbstractDoc;
import jsynedit.SwingFileFilter;
import jsynedit.Utils;
import jsynedit.search.FindReplace;
import madkit.kernel.JTextAreaWriter;
import madkit.utils.agents.AbstractEditorAgent;

public class AbstractEditorPanel
extends JRootPane
implements ActionListener,
AncestorListener,
ChangeListener {
    protected AbstractDoc inputArea;
    protected JTextArea outputArea;
    protected PrintWriter out;
    protected JToolBar toolBar;
    protected JMenuBar menubar = new JMenuBar();
    private static int cpt = 1;
    protected JPanel commandPanel;
    private Beautifier beautifier;
    private JSplitPane split;
    private InsertClassName jbrowser;
    boolean jbrowserEnabled = false;
    private static Properties props;
    private FindAll findAll;
    private BoxComment boxComment;
    private BoxUncomment boxUncomment;
    private ToUpperCase upperCase;
    private ToLowerCase lowerCase;
    private SimpleComment simpleComment;
    private SimpleUnComment simpleUnComment;
    private RemoveWhitespace rmWhiteSpace;
    private JFileChooser fileChooser;
    private Print printer;
    private CreateTemplate templates;
    private LeftIndent left_indent;
    private RightIndent right_indent;
    private String iconeNewFile;
    private String iconeOpenFile;
    private String iconeSaveFile;
    private String iconeSaveAllFile;
    private String iconeCutFile;
    private String iconeCopyFile;
    private String iconePasteFile;
    private String iconeUndoFile;
    private String iconeRedoFile;
    private String iconePropFile;
    private String iconeSearchFile;
    private String iconeCloseFile;
    private String iconePrintFile;
    JMenu menuOptions;
    protected FindReplace findReplace;
    protected JTabbedPane pane;
    protected JTabbedPane vTabbedPane;
    protected JComboBox languages;
    protected OptionsDialog optionsDialog;
    private AbstractDoc[] textAreas;
    private static int textAreasCurrentSize;
    private String currentFile;
    public static final boolean LOAD = true;
    public static final boolean SAVE = false;
    AbstractEditorAgent ag;
    private int waitCount;
    protected String extens = null;

    public PrintWriter stdout() {
        return this.out;
    }

    public PrintWriter stderr() {
        return this.out;
    }

    public InputStream stdin() {
        return System.in;
    }

    public AbstractDoc getTextArea() {
        return this.inputArea;
    }

    public AbstractDoc[] getTextAreas() {
        return this.textAreas;
    }

    public JTabbedPane getTabbedPane() {
        return this.pane;
    }

    public JFileChooser getFileChooser(int n) {
        return this.fileChooser;
    }

    public JTextArea getOutputArea() {
        return this.outputArea;
    }

    public JToolBar getToolbar() {
        return this.toolBar;
    }

    public JMenuBar getMenubar() {
        return this.menubar;
    }

    AbstractDoc getInputArea() {
        return this.inputArea;
    }

    public AbstractEditorPanel(AbstractEditorAgent abstractEditorAgent) {
        this();
        this.ag = abstractEditorAgent;
    }

    public AbstractEditorPanel() {
        this.setJMenuBar(this.menubar);
        JMenu jMenu = new JMenu("File");
        this.menubar.add(jMenu);
        AbstractEditorPanel.addMenuItem(this, jMenu, "New file", "new", 78, 78);
        JMenu jMenu2 = new JMenu("Templates");
        JMenu jMenu3 = new JMenu("Java");
        JMenu jMenu4 = new JMenu("Madkit");
        jMenu2.add(jMenu3);
        jMenu2.add(jMenu4);
        AbstractEditorPanel.addMenuItem(this, jMenu3, "Class", AbstractEditorPanel.getUserDirectory() + "/templates/Java/Class.java", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu3, "Interface", AbstractEditorPanel.getUserDirectory() + "/templates/Java/Interface.java", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu3, "Main", AbstractEditorPanel.getUserDirectory() + "/templates/Java/Main.java", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu4, "Agent", AbstractEditorPanel.getUserDirectory() + "/templates/Madkit/Agent.java", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu, "Open", "open", 79, 79);
        jMenu.addSeparator();
        AbstractEditorPanel.addMenuItem(this, jMenu, "Save", "save", 83, 83);
        AbstractEditorPanel.addMenuItem(this, jMenu, "Save as", "saveAs", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu, "Save All", "saveAll", -1);
        jMenu.addSeparator();
        AbstractEditorPanel.addMenuItem(this, jMenu, "Print Document", "print", 80, 80);
        jMenu.addSeparator();
        AbstractEditorPanel.addMenuItem(this, jMenu, "Close", "close", 87, 87);
        AbstractEditorPanel.addMenuItem(this, jMenu, "Quit", "quit", 81, 81);
        JMenu jMenu5 = new JMenu("Edit");
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Undo", "undo", 90, 90);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Redo", "redo", 89, 89);
        jMenu5.addSeparator();
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Cut", "cut", 88, 88);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Copy", "copy", 67, 67);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Paste", "paste", 86, 86);
        jMenu5.addSeparator();
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Find", "find", 70, 70);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Replace", "replace", 82, 82);
        jMenu5.addSeparator();
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Left Indent", "left_indent", 37, 37);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Right Indent", "right_indent", 39, 39);
        jMenu5.addSeparator();
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Box Comment", "boxcomment", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Box Uncomment", "boxuncomment", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Upper Case", "uppercase", 38, 38);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Lower Case", "lowercase", 40, 40);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Simple Comment", "simplecomment", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "Simple Uncomment", "simpleuncomment", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu5, "remove Space", "removewhitespace", -1);
        this.menubar.add(jMenu5);
        this.menubar.add(jMenu2);
        this.menuOptions = new JMenu("Options");
        this.menubar.add(this.menuOptions);
        JMenu jMenu6 = new JMenu("Java");
        AbstractEditorPanel.addMenuItem(this, jMenu6, "Beautifier", "beautifier", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu6, "Browser", "browser", -1);
        this.menuOptions.add(jMenu6);
        AbstractEditorPanel.addMenuItem(this, this.menuOptions, "Find All", "findall", -1);
        AbstractEditorPanel.addMenuItem(this, this.menuOptions, "Preferences...", "preferences", -1);
        AbstractEditorPanel.addMenuItem(this, this.menuOptions, "General", "optGen", -1);
        AbstractEditorPanel.addMenuItem(this, this.menuOptions, "Police", "optPol", -1);
        AbstractEditorPanel.addMenuItem(this, this.menuOptions, "Style & Color", "optS&C", -1);
        JMenu jMenu7 = new JMenu("Help");
        this.menubar.add(jMenu7);
        this.getContentPane().setLayout(new BorderLayout(1, 1));
        this.commandPanel = new JPanel();
        this.commandPanel.setAlignmentX(0.0f);
        this.commandPanel.setAlignmentY(0.0f);
        this.commandPanel.setLayout(new FlowLayout(0));
        this.toolBar = new JToolBar();
        this.applyTheme("transpa");
        this.addTool(this.toolBar, "new", "new file", "/images/" + this.iconeNewFile);
        this.addTool(this.toolBar, "open", "Open file", "/images/" + this.iconeOpenFile);
        this.addTool(this.toolBar, "save", "Save file", "/images/" + this.iconeSaveFile);
        this.addTool(this.toolBar, "saveAll", "Save all files", "/images/" + this.iconeSaveAllFile);
        this.toolBar.addSeparator();
        this.addTool(this.toolBar, "cut", "Cut", "/images/" + this.iconeCutFile);
        this.addTool(this.toolBar, "copy", "Copy", "/images/" + this.iconeCopyFile);
        this.addTool(this.toolBar, "paste", "Paste", "/images/" + this.iconePasteFile);
        this.toolBar.addSeparator();
        this.addTool(this.toolBar, "undo", "Undo", "/images/" + this.iconeUndoFile);
        this.addTool(this.toolBar, "redo", "Redo", "/images/" + this.iconeRedoFile);
        this.languages = new JComboBox();
        this.languages.addItem("None");
        this.languages.addItem("BatchFile");
        this.languages.addItem("C");
        this.languages.addItem("CC");
        this.languages.addItem("Eiffel");
        this.languages.addItem("HTML");
        this.languages.addItem("IDL");
        this.languages.addItem("Java");
        this.languages.addItem("JavaScript");
        this.languages.addItem("Jess");
        this.languages.addItem("Kawa");
        this.languages.addItem("Lisp");
        this.languages.addItem("Patch");
        this.languages.addItem("Perl");
        this.languages.addItem("PHP");
        this.languages.addItem("Props");
        this.languages.addItem("Python");
        this.languages.addItem("Scheme");
        this.languages.addItem("ShellScript");
        this.languages.addItem("TeX");
        this.languages.addItem("XML");
        this.languages.addActionListener(this);
        this.toolBar.addSeparator(new Dimension(50, 5));
        this.toolBar.add(this.languages);
        this.commandPanel.add(this.toolBar);
        this.getContentPane().add("North", this.commandPanel);
        this.findReplace = new FindReplace(this, 2, true);
        this.textAreas = new AbstractDoc[10];
        textAreasCurrentSize = 0;
        this.pane = new JTabbedPane();
        this.left_indent = new LeftIndent();
        this.right_indent = new RightIndent();
        this.printer = new Print();
        this.templates = new CreateTemplate();
        this.boxComment = new BoxComment();
        this.boxUncomment = new BoxUncomment();
        this.upperCase = new ToUpperCase();
        this.lowerCase = new ToLowerCase();
        this.simpleComment = new SimpleComment();
        this.simpleUnComment = new SimpleUnComment();
        this.rmWhiteSpace = new RemoveWhitespace();
        this.split = new JSplitPane(1);
        this.getContentPane().add((Component)this.split, "Center");
        this.split.setOneTouchExpandable(true);
        this.pane.setPreferredSize(new Dimension(400, 400));
        this.vTabbedPane = new JTabbedPane();
        this.split.setLeftComponent(this.vTabbedPane);
        this.outputArea = new JTextArea(";; EditorAgent 2.0 (c) Madkit team\n", 10, 40);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setSize(400, 100);
        jScrollPane.getViewport().add(this.outputArea);
        this.out = new PrintWriter((Writer)new JTextAreaWriter(this.outputArea), true);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(this.pane);
        jSplitPane.setBottomComponent(jScrollPane);
        this.split.setRightComponent(jSplitPane);
        this.fileChooser = new JFileChooser(System.getProperty("madkit.dir", null));
        this.initProperties();
        this.optionsDialog = new OptionsDialog(this);
        this.findReplace = new FindReplace(this, 2, true);
        this.findAll = new FindAll(this);
        this.jbrowser = new InsertClassName();
        this.beautifier = new Beautifier();
        this.vTabbedPane.addTab("FindAll", this.findAll);
        this.currentFile = null;
        this.addAncestorListener(this);
        this.pane.addChangeListener(this);
        this.languages.setSelectedIndex(0);
        this.show();
    }

    public void applyTheme(String string) {
        if (string == "red") {
            this.applyThemeIcon("red");
            return;
        }
        if (string == "blue") {
            this.applyThemeIcon("blue");
            return;
        }
        if (string == "purple") {
            this.applyThemeIcon("violet");
            return;
        }
        if (string == "gold") {
            this.applyThemeIcon("yellow");
            return;
        }
        if (string == "metal") {
            this.applyThemeIcon("metal");
            return;
        }
        if (string == "transpa") {
            this.applyThemeIcon("transpa");
            return;
        }
    }

    public void applyThemeIcon(String string) {
        this.iconeNewFile = string + "/b_" + string + "_new.gif";
        this.iconeOpenFile = string + "/b_" + string + "_open.gif";
        this.iconeSaveFile = string + "/b_" + string + "_save.gif";
        this.iconeSaveAllFile = string + "/b_" + string + "_saveAll.gif";
        this.iconeCutFile = string + "/b_" + string + "_cut.gif";
        this.iconeCopyFile = string + "/b_" + string + "_copy.gif";
        this.iconePasteFile = string + "/b_" + string + "_paste.gif";
        this.iconeUndoFile = string + "/b_" + string + "_undo.gif";
        this.iconeRedoFile = string + "/b_" + string + "_redo.gif";
        this.iconeSearchFile = string + "/b_" + string + "_search.gif";
        this.iconePropFile = string + "/b_" + string + "_props.gif";
        this.iconeCloseFile = "close.gif";
        this.iconePrintFile = string + "/b_" + string + "_print02.gif";
    }

    public static void setProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        props.put(string, string2);
    }

    public static String getProperty(String string) {
        return props.getProperty(string);
    }

    public static final String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public void propertiesChanged() {
        for (int i = 0; i < this.pane.getTabCount(); ++i) {
            AbstractDoc abstractDoc = this.textAreas[i];
            abstractDoc.loadTextAreaProperties();
            abstractDoc.loadUndoProperties();
        }
    }

    public static final String getProperty(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        if (objectArray == null) {
            return props.getProperty(string, string);
        }
        return MessageFormat.format(props.getProperty(string, string), objectArray);
    }

    public static boolean getBooleanProperty(String string) {
        String string2 = AbstractEditorPanel.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals("on") || string2.equals("true");
    }

    public void initProperties() {
        props = new Properties();
        this.initCommentProperties("", "", "", "");
        props.setProperty("print.pageOrientation", "1");
        props.setProperty("print.pageWidth", "10");
        props.setProperty("print.pageHeight", "10");
        props.setProperty("print.pageImgX", "10");
        props.setProperty("print.pageImgY", "10");
        props.setProperty("print.pageImgWidth", "10");
        props.setProperty("print.pageImgHeight", "10");
        props.setProperty("print.font", "10");
        props.setProperty("print.fontSize", "10");
        AbstractEditorPanel.setProperty("templates.input", "Enter the value of {0}");
        AbstractEditorPanel.setProperty("templates.title", "Template input");
        props.setProperty("print.printLineNumbers.label", "Print line numbers");
        props.setProperty("print.wrapText.label", "Wrap text");
        props.setProperty("print.printHeader.label", "Print header");
        props.setProperty("print.printFooter.label", "Print footer");
        props.setProperty("print.printSyntax.label", "Print colors and styles");
        props.setProperty("print.pageLayout.label", "Page Layout");
        props.setProperty("options.orientation.label", "Split orientation");
        props.setProperty("options.linesintervalenabled.label", "Enable interval highlighting");
        props.setProperty("options.wrapguideenabled.label", "Enable wrap guide");
        props.setProperty("options.splitarea.label", "Splits editor");
        props.setProperty("options.blockcaret.label", "Block caret");
        props.setProperty("options.blinkingcaret.label", "Blinking caret");
        props.setProperty("options.linehighlight.label", "Line highlighting");
        props.setProperty("options.eolmarkers.label", "End of line markers");
        props.setProperty("options.softtabs.label", "Soft tabs");
        props.setProperty("options.tabindent.label", "Indent on TAB");
        props.setProperty("options.enterindent.label", "Indent on ENTER");
        props.setProperty("options.tabstop.label", "Tab stops");
        props.setProperty("options.wordmove.go_over_space.label", "Word jumping goes over spaces");
        props.setProperty("options.smartHomeEnd.label", "Smart HOME/END");
        props.setProperty("options.defaultdirloaddialog.label", "Default dir from active file");
        props.setProperty("options.selection.label", "Use selection as search pattern");
        props.setProperty("options.extra_line_feed.label", "Append an extra line feed on save");
        props.setProperty("options.line_end_preserved.label", "Keep existing line separator on open");
        props.setProperty("options.styles.bgColor", "Editor background");
        props.setProperty("options.styles.fgColor", "Editor foreground");
        props.setProperty("options.styles.caretColor", "Caret");
        props.setProperty("options.styles.selectionColor", "Selection");
        props.setProperty("options.styles.highlightColor", "Highlight");
        props.setProperty("options.styles.lineHighlightColor", "Line highlight");
        props.setProperty("options.styles.linesHighlightColor", "Interval highlight");
        props.setProperty("options.styles.bracketHighlightColor", "Bracket Highlight");
        props.setProperty("options.styles.wrapGuideColor", "Wrap guide");
        props.setProperty("options.styles.eolMarkerColor", "EOL markers");
        props.setProperty("options.styles.comment1Style", "editor.style.comment1");
        props.setProperty("options.styles.comment2Style", "editor.style.comment2");
        props.setProperty("options.styles.literal1Style", "editor.style.literal1");
        props.setProperty("options.styles.literal2Style", "editor.style.literal2");
        props.setProperty("options.styles.labelStyle", "editor.style.label");
        props.setProperty("options.styles.keyword1Style", "editor.style.keyword1");
        props.setProperty("options.styles.keyword2Style", "editor.style.keyword2");
        props.setProperty("options.styles.keyword3Style", "editor.style.keyword3");
        props.setProperty("options.styles.operatorStyle", "editor.style.operator");
        props.setProperty("options.styles.invalidStyle", "editor.style.invalid");
        props.setProperty("options.styles.methodStyle", "editor.style.method");
        props.setProperty("beautifier.breakBracket", "true");
        props.setProperty("beautifier.indentSwitch", "true");
        props.setProperty("beautifier.preferredLineLength", "30");
        props.setProperty("editor.softTab", "on");
        props.setProperty("options.jbrowse.panel_label", "Default Options for Future Sessions");
        props.setProperty("options.jbrowse.showAttr", "Attributes");
        props.setProperty("options.jbrowse.showPrimAttr", "include");
        props.setProperty("options.jbrowse.showGeneralizations", "extends/implements");
        props.setProperty("options.jbrowse.showThrows", "Method throws type(s)");
        props.setProperty("options.jbrowse.visLevelLabel", "Lowest Visibility Level to Show");
        props.setProperty("options.jbrowse.topLevelVis", "Top-Level:");
        props.setProperty("options.jbrowse.memberVis", "Member:");
        props.setProperty("options.jbrowse.displayOptions", "How to display");
        props.setProperty("options.jbrowse.showArgs", "Arguments");
        props.setProperty("options.jbrowse.showArgNames", "formal names");
        props.setProperty("options.jbrowse.showNestedName", "Qualify nested");
        props.setProperty("options.jbrowse.showIconKeywords", "Keywords specified by icons");
        props.setProperty("options.jbrowse.showMiscMod", "Implementation detail modifiers");
        props.setProperty("options.jbrowse.alphaSort", "Alpha Method Sort");
        props.setProperty("options.jbrowse.showLineNums", "Line Numbers");
        props.setProperty("options.jbrowse.umlStyle", "UML");
        props.setProperty("options.jbrowse.javaStyle", "Java");
        props.setProperty("options.jbrowse.customStyle", "Custom");
        props.setProperty("options.jbrowse.displayStyle", "Display style:");
        props.setProperty("options.jbrowse.customOptions", "Custom Display");
        props.setProperty("options.jbrowse.custVisAsSymbol", "Use Visibility");
        props.setProperty("options.jbrowse.custAbsAsItalic", "Abstract in italics");
        props.setProperty("options.jbrowse.custStaAsUlined", "Static as underlined");
        props.setProperty("options.jbrowse.custTypeIsSuffixed", "Type identifier as a suffix");
        props.setProperty("filechooser.lastdirectory.true", AbstractEditorPanel.getHomeDirectory());
        props.setProperty("filechooser.lastdirectory.false", AbstractEditorPanel.getHomeDirectory());
        props.setProperty("options.undo.limit", "100");
        props.setProperty("options.undo.sequence", "500");
        this.initPropertiesStylesOptions();
    }

    private void initPropertiesStylesOptions() {
        AbstractEditorPanel.setProperty("editor.wordmove.go_over_space", "on");
        AbstractEditorPanel.setProperty("editor.splitted.orientation", "Vertical");
        AbstractEditorPanel.setProperty("editor.autoScroll", "3");
        AbstractEditorPanel.setProperty("editor.antiAliasing", "off");
        AbstractEditorPanel.setProperty("editor.dirDefaultDialog", "on");
        AbstractEditorPanel.setProperty("editor.linesInterval", "5");
        AbstractEditorPanel.setProperty("editor.linesIntervalEnabled", "off");
        AbstractEditorPanel.setProperty("editor.linesHighlightColor", "#e6e6ff");
        AbstractEditorPanel.setProperty("editor.tabStop", "on");
        AbstractEditorPanel.setProperty("editor.font", "Monospaced");
        AbstractEditorPanel.setProperty("editor.fontSize", "12");
        AbstractEditorPanel.setProperty("editor.tabSize", "8");
        AbstractEditorPanel.setProperty("editor.tabIndent", "off");
        AbstractEditorPanel.setProperty("editor.enterIndent", "on");
        AbstractEditorPanel.setProperty("editor.blinkingCaret", "on");
        AbstractEditorPanel.setProperty("editor.softTab", "on");
        AbstractEditorPanel.setProperty("editor.saveSession", "on");
        AbstractEditorPanel.setProperty("editor.colorize.mode", "plain");
        AbstractEditorPanel.setProperty("editor.bgColor", "#ffffff");
        AbstractEditorPanel.setProperty("editor.fgColor", "#000000");
        AbstractEditorPanel.setProperty("editor.lineHighlight", "on");
        AbstractEditorPanel.setProperty("editor.lineHighlightColor", "#e0e0e0");
        AbstractEditorPanel.setProperty("editor.highlightColor", "#ffff00");
        AbstractEditorPanel.setProperty("editor.wrapGuideColor", "#ff0000");
        AbstractEditorPanel.setProperty("editor.wrapGuideOffset", "0");
        AbstractEditorPanel.setProperty("editor.wrapGuideEnabled", "off");
        AbstractEditorPanel.setProperty("editor.bracketHighlight", "on");
        AbstractEditorPanel.setProperty("editor.bracketHighlightColor", "#00ff00");
        AbstractEditorPanel.setProperty("editor.eolMarkers", "off");
        AbstractEditorPanel.setProperty("editor.eolMarkerColor", "#009999");
        AbstractEditorPanel.setProperty("editor.caretColor", "#ff0000");
        AbstractEditorPanel.setProperty("editor.selectionColor", "#ccccff");
        AbstractEditorPanel.setProperty("editor.blockCaret", "off");
        AbstractEditorPanel.setProperty("editor.line_end.preserve", "on");
        AbstractEditorPanel.setProperty("editor.style.comment1", "color:#009900 style:i");
        AbstractEditorPanel.setProperty("editor.style.comment2", "color:#009900 style:i");
        AbstractEditorPanel.setProperty("editor.style.keyword1", "color:#0000ff style:b");
        AbstractEditorPanel.setProperty("editor.style.keyword2", "color:#ff9900");
        AbstractEditorPanel.setProperty("editor.style.keyword3", "color:#ff0000");
        AbstractEditorPanel.setProperty("editor.style.label", "color:#cc00cc style:b");
        AbstractEditorPanel.setProperty("editor.style.literal1", "color:#9999ff");
        AbstractEditorPanel.setProperty("editor.style.literal2", "color:#650099 style:b");
        AbstractEditorPanel.setProperty("editor.style.operator", "color:#ffc800 style:b");
        AbstractEditorPanel.setProperty("editor.style.invalid", "color:#ff9900 style:b");
        AbstractEditorPanel.setProperty("editor.style.method", "color:#000000 style:b");
        AbstractEditorPanel.setProperty("buttons.highlightColor", "#c0c0d2");
    }

    public void initCommentProperties(String string, String string2, String string3, String string4) {
        props.setProperty("blockComment", string);
        props.setProperty("commentStart", string2);
        props.setProperty("commentEnd", string3);
        props.setProperty("boxComment", string4);
    }

    public static void unsetProperty(String string) {
        if (props.get(string) != null) {
            props.put(string, "");
        } else {
            props.remove(string);
        }
    }

    public JTabbedPane getVerticalTabbedPane() {
        return this.vTabbedPane;
    }

    public void triggerTabbedPanes() {
        this.vTabbedPane.addTab("Find All", this.findAll);
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        Utils.getRealFrameParent(this).addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
                AbstractDoc[] abstractDocArray = AbstractEditorPanel.this.getTextAreas();
                for (int i = 0; i < textAreasCurrentSize; ++i) {
                    AbstractEditorPanel.this.closeTabbedPane(i);
                }
            }
        });
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.inputArea = (AbstractDoc)this.pane.getSelectedComponent();
        if (this.inputArea != null) {
            this.currentFile = this.inputArea.getCurrentFile();
            if (this.currentFile != null) {
                this.selectCorrectLanguage(this.currentFile);
            }
            Utils.setFrameParentTitle(this, this.pane.getTitleAt(this.pane.getSelectedIndex()));
        } else {
            this.languages.setSelectedIndex(0);
            this.currentFile = null;
            Utils.setFrameParentTitle(this, "");
        }
        if (this.jbrowserEnabled) {
            this.jbrowser.reparse(this.inputArea);
        }
    }

    public static boolean match(String string, String string2) {
        return string2.endsWith(string);
    }

    public static String getUserDirectory() {
        return System.getProperty("madkit.dir") + File.separator + "plugins/jsynedit";
    }

    public void showWaitCursor() {
        if (this.waitCount++ == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            AbstractDoc[] abstractDocArray = this.getTextAreas();
        }
    }

    public void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            cursor = Cursor.getPredefinedCursor(2);
            AbstractDoc[] abstractDocArray = this.getTextAreas();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        this.command(string);
        if (string.equals("browser")) {
            if (!this.jbrowserEnabled) {
                this.split.setDividerLocation(150);
                this.split.setOneTouchExpandable(true);
                this.jbrowser.actionPerformed(actionEvent);
                this.jbrowserEnabled = !this.jbrowserEnabled;
            } else {
                this.split.setOneTouchExpandable(true);
                this.split.setDividerLocation(0);
                this.jbrowserEnabled = !this.jbrowserEnabled;
            }
        } else if (string.equals("print")) {
            this.printer.actionPerformed(actionEvent);
        } else if (string.equals(AbstractEditorPanel.getUserDirectory() + "/templates/Java/Class.java") || string.equals(AbstractEditorPanel.getUserDirectory() + "/templates/Java/Interface.java") || string.equals(AbstractEditorPanel.getUserDirectory() + "/templates/Java/Main.java") || string.equals(AbstractEditorPanel.getUserDirectory() + "/templates/Madkit/Agent.java")) {
            this.templates.actionPerformed(actionEvent);
        } else if (string.equals("uppercase")) {
            this.upperCase.actionPerformed(actionEvent);
        } else if (string.equals("lowercase")) {
            this.lowerCase.actionPerformed(actionEvent);
        } else if (string.equals("simplecomment")) {
            this.simpleComment.actionPerformed(actionEvent);
        } else if (string.equals("simpleuncomment")) {
            this.simpleUnComment.actionPerformed(actionEvent);
        } else if (string.equals("left_indent")) {
            this.left_indent.actionPerformed(actionEvent);
        } else if (string.equals("right_indent")) {
            this.right_indent.actionPerformed(actionEvent);
        } else if (string.equals("boxcomment")) {
            this.boxComment.actionPerformed(actionEvent);
        } else if (string.equals("boxuncomment")) {
            this.boxUncomment.actionPerformed(actionEvent);
        } else if (string.equals("removewhitespace")) {
            this.rmWhiteSpace.actionPerformed(actionEvent);
        } else if (string.equals("beautifier")) {
            this.beautifier.actionPerformed(actionEvent);
        }
    }

    public void command(String string) {
        if (string.equals("open")) {
            this.openFile();
        } else if (string.equals("new")) {
            this.newFile();
        } else if (string.equals("save")) {
            this.save();
        } else if (string.equals("saveAll")) {
            this.saveAll();
        } else if (string.equals("copy")) {
            this.inputArea.copy();
        } else if (string.equals("cut")) {
            this.inputArea.cut();
        } else if (string.equals("paste")) {
            this.inputArea.paste();
        } else if (string.equals("saveAs")) {
            this.saveAs();
        } else if (string.equals("clear")) {
            this.clear();
        } else if (string.equals("close")) {
            this.closeCurentTabbedPane();
        } else if (string.equals("undo")) {
            this.inputArea.undo();
        } else if (string.equals("redo")) {
            this.inputArea.redo();
        } else if (string.equals("optGen")) {
            this.optionsDialog.show();
        } else if (string.equals("optPol")) {
            this.optionsDialog.show();
        } else if (string.equals("optS&C")) {
            this.optionsDialog.show();
        } else if (string.equals("find")) {
            this.findReplace.show();
        } else if (string.equals("quit")) {
            this.quit();
        } else if (string.equals("comboBoxChanged")) {
            if (this.inputArea != null) {
                this.chooseTokenMarker((String)this.languages.getSelectedItem());
                this.inputArea.repaint();
            }
        } else if (string.equals("find")) {
            this.findReplace.show();
        } else if (string.equals("replace")) {
            this.findReplace.show();
        } else if (string.equals("preferences")) {
            this.optionsDialog.show();
        } else if (string.equals("findall")) {
            this.split.setDividerLocation(150);
            this.split.setOneTouchExpandable(true);
            this.vTabbedPane.setSelectedComponent(this.findAll);
        }
    }

    public void closeCurentTabbedPane() {
        int n = this.pane.getSelectedIndex();
        this.closeTabbedPane(n);
    }

    public void closeTabbedPane(int n) {
        if (this.inputArea.undo.getTextModified()) {
            String string = this.pane.getTitleAt(n);
            int n2 = JOptionPane.showConfirmDialog(this, "Save changes to " + string + " ?", "Warning", 1, 3);
            if (n2 == 2) {
                return;
            }
            if (n2 == 0) {
                this.save();
            }
        }
        this.pane.remove(n);
        --textAreasCurrentSize;
        this.stateChanged(new ChangeEvent(this.pane));
    }

    public void clearOutputArea() {
        this.outputArea.setText("");
    }

    public void newFile() {
        String string = "Untitled - " + cpt;
        JPanel jPanel = new JPanel(false);
        this.inputArea = this.textAreas[AbstractEditorPanel.textAreasCurrentSize] = new AbstractDoc();
        this.inputArea.loadTextAreaProperties();
        this.inputArea.loadUndoProperties();
        this.enableShortcuts(this.inputArea);
        this.inputArea.setEditor(this);
        this.pane.addTab(string, this.inputArea);
        this.pane.setSelectedIndex(textAreasCurrentSize);
        ++textAreasCurrentSize;
        ++cpt;
    }

    public Frame getFrameParent() {
        Container container = this;
        while (!(container instanceof Frame)) {
            if (container == null) {
                return null;
            }
            container = container.getParent();
        }
        return (Frame)container;
    }

    public static String getHomeDirectory() {
        return System.getProperty("user.dir");
    }

    public void setExtens(String string) {
        this.extens = string;
    }

    protected boolean getFileDialog(boolean bl, String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser(AbstractEditorPanel.getProperty("filechooser.lastdirectory." + bl));
        if (string2 != null) {
            jFileChooser.setFileFilter(new SwingFileFilter(string2));
        }
        jFileChooser.setDialogTitle(string);
        int n = 0;
        if (bl) {
            n = jFileChooser.showOpenDialog(this);
        } else {
            if (this.currentFile == null) {
                jFileChooser.setSelectedFile(new File(this.pane.getTitleAt(this.pane.getSelectedIndex())));
            } else {
                jFileChooser.setSelectedFile(new File(this.inputArea.getCurrentFile()));
            }
            n = jFileChooser.showSaveDialog(this);
        }
        if (n == 0) {
            if (jFileChooser.getSelectedFile() != null) {
                this.currentFile = jFileChooser.getSelectedFile().getPath();
                AbstractEditorPanel.setProperty("filechooser.lastdirectory." + bl, jFileChooser.getSelectedFile().getParent());
                return true;
            }
            return false;
        }
        return false;
    }

    public void openFile(String string) {
        this.currentFile = string;
        this.openFile();
    }

    public void openFile() {
        if (!this.getFileDialog(true, "Open file", this.extens)) {
            return;
        }
        if (this.readFile(this.currentFile)) {
            this.inputArea.undo.reset();
        }
    }

    public String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public String chooseTokenMarker(String string) {
        if (string == null) {
            return "";
        }
        this.initCommentProperties("", "", "", "");
        if (string.equalsIgnoreCase("bat") || string.equalsIgnoreCase("BatchFile")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new BatchFileTokenMarker());
            this.initCommentProperties("rem", "", "", "");
            return "BatchFile";
        }
        if (string.equalsIgnoreCase("c") || string.equalsIgnoreCase("h")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new CTokenMarker());
            this.initCommentProperties("//", "/*", "*/", "*");
            return "C";
        }
        if (string.equalsIgnoreCase("cc") || string.equalsIgnoreCase("cpp") || string.equalsIgnoreCase("h")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new CCTokenMarker());
            this.initCommentProperties("//", "/*", "*/", "*");
            return "CC";
        }
        if (string.equalsIgnoreCase("cc") || string.equalsIgnoreCase("Eiffel")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new EiffelTokenMarker());
            this.initCommentProperties("--", "", "", "");
            return "Eiffel";
        }
        if (string.equalsIgnoreCase("html") || string.equalsIgnoreCase("htm")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new HTMLTokenMarker());
            return "HTML";
        }
        if (string.equalsIgnoreCase("idl")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new IDLTokenMarker());
            this.initCommentProperties("//", "/*", "*/", "*");
            return "IDL";
        }
        if (string.equalsIgnoreCase("java") || string.equalsIgnoreCase("bsh")) {
            this.inputArea.setTokenMarker(new JavaTokenMarker());
            this.initCommentProperties("//", "/*", "*/", "*");
            return "Java";
        }
        if (string.equalsIgnoreCase("js") || string.equalsIgnoreCase("JavaScript")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new JavaScriptTokenMarker());
            this.initCommentProperties("//", "/*", "*/", "*");
            return "JavaScript";
        }
        if (string.equalsIgnoreCase("lsp") || string.equalsIgnoreCase("lisp")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new LispTokenMarker());
            this.initCommentProperties(";", "#|", "|#", "#");
            return "Lisp";
        }
        if (string.equalsIgnoreCase("p56") || string.equalsIgnoreCase("Patch")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new PatchTokenMarker());
            return "Patch";
        }
        if (string.equalsIgnoreCase("pbp") || string.equalsIgnoreCase("Perl")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new PerlTokenMarker());
            this.initCommentProperties("#", "", "", "");
            return "Perl";
        }
        if (string.equalsIgnoreCase("php") || string.equalsIgnoreCase("php3")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new PHPTokenMarker());
            this.initCommentProperties("//", "/*", "*/", "*");
            return "PHP";
        }
        if (string.equalsIgnoreCase("prop") || string.equalsIgnoreCase("props")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new PropsTokenMarker());
            this.initCommentProperties("#", "", "", "");
            return "Props";
        }
        if (string.equalsIgnoreCase("py") || string.equalsIgnoreCase("Python")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new PythonTokenMarker());
            this.initCommentProperties("#", "", "", "");
            return "Python";
        }
        if (string.equalsIgnoreCase("ss") || string.equalsIgnoreCase("sch") || string.equalsIgnoreCase("Scheme")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new SchemeTokenMarker());
            this.initCommentProperties(";", "#|", "|#", "#");
            return "Scheme";
        }
        if (string.equalsIgnoreCase("sh") || string.equalsIgnoreCase("ShellScript")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new ShellScriptTokenMarker());
            this.initCommentProperties("#", "", "", "");
            return "ShellScipt";
        }
        if (string.equalsIgnoreCase("tex")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new TeXTokenMarker());
            this.initCommentProperties("%", "", "", "");
            return "TeX";
        }
        if (string.equalsIgnoreCase("xml") || string.equalsIgnoreCase("cfg") || string.equalsIgnoreCase("ini") || string.equalsIgnoreCase("fml")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new XMLTokenMarker());
            this.initCommentProperties("", "<!--", "-->", "");
            return "XML";
        }
        if (string.equalsIgnoreCase("scm")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new KawaTokenMarker());
            this.initCommentProperties(";", "#|", "|#", "#");
            return "Kawa";
        }
        if (string.equalsIgnoreCase("clp") || string.equalsIgnoreCase("jess")) {
            ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(new JessTokenMarker());
            this.initCommentProperties(";", "#|", "|#", "#");
            return "Jess";
        }
        ((AbstractDoc)this.pane.getSelectedComponent()).setTokenMarker(null);
        return string;
    }

    public void selectCorrectLanguage(String string) {
        String string2 = this.getExtension(string);
        String string3 = this.chooseTokenMarker(string2);
        for (int i = 1; i < this.languages.getItemCount(); ++i) {
            if (((String)this.languages.getItemAt(i)).equals(string3)) {
                this.languages.setSelectedIndex(i);
                break;
            }
            this.languages.setSelectedIndex(0);
        }
    }

    public boolean readFile(String string) {
        return this.readFile(new File(string));
    }

    public boolean readFile(File file) {
        String string = new String();
        String string2 = new String();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while (string2 != null) {
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                string = string + string2 + "\n";
            }
            String string3 = file.getName();
            for (int i = 0; i < textAreasCurrentSize; ++i) {
                if (!string3.equals(this.pane.getTitleAt(i))) continue;
                this.pane.setSelectedIndex(i);
                bufferedReader.close();
                return false;
            }
            this.inputArea = this.textAreas[AbstractEditorPanel.textAreasCurrentSize] = new AbstractDoc();
            this.inputArea.loadTextAreaProperties();
            this.inputArea.loadUndoProperties();
            this.enableShortcuts(this.inputArea);
            this.inputArea.setName(string3);
            this.inputArea.setEditor(this);
            this.inputArea.setCurrentFile(file.getPath());
            this.inputArea.setText(string);
            this.inputArea.setCaretPosition(0);
            this.pane.addTab(string3, this.inputArea);
            this.pane.setSelectedIndex(textAreasCurrentSize);
            ++textAreasCurrentSize;
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Cannot open file " + file.getName());
        }
        return true;
    }

    void saveIfModified() {
        int n;
        if (!this.inputArea.getText().equals("") && (n = JOptionPane.showConfirmDialog(this, "Buffer is modified, do you want to save it ?", "Warning", 0, 3, null)) == 0) {
            this.save();
        }
    }

    public void saveAs() {
        if (this.inputArea == null) {
            return;
        }
        if (this.getFileDialog(false, "Save file", this.extens)) {
            this.inputArea.setCurrentFile(this.currentFile);
            this.save1(true);
            this.pane.setTitleAt(this.pane.getSelectedIndex(), new File(this.currentFile).getName());
            this.selectCorrectLanguage(this.currentFile);
        }
    }

    public void saveAll() {
        int n = this.pane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.pane.setSelectedIndex(i);
            this.save();
        }
    }

    public void save() {
        if (this.inputArea == null) {
            return;
        }
        if (this.inputArea.getCurrentFile() == null) {
            this.saveAs();
        } else {
            this.save1(true);
        }
    }

    void save1(boolean bl) {
        if (bl) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.inputArea.getCurrentFile()));
                String string = this.inputArea.getText();
                printWriter.print(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("saveContent: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                System.err.println("saveContent: " + iOException);
            }
            this.inputArea.undo.setTextModified(false);
        }
    }

    public void clear() {
        this.clearOutputArea();
    }

    public void quit() {
        System.exit(0);
    }

    public void print(String string) {
        this.stdout().print(string);
    }

    public void println(String string) {
        this.stdout().println(string);
    }

    public void addTool(JToolBar jToolBar, String string, String string2, String string3) {
        JButton jButton;
        if (string3.equals("")) {
            jButton = (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        } else {
            URL uRL = this.getClass().getResource(string3);
            jButton = uRL != null ? (JButton)jToolBar.add(new JButton(new ImageIcon(uRL))) : (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        }
        jButton.setToolTipText(string2);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(this);
    }

    public static void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n) {
        AbstractEditorPanel.addMenuItem(actionListener, jMenu, string, string2, n, -1);
    }

    public static void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n, int n2) {
        JMenuItem jMenuItem = n > 0 ? new JMenuItem(string, n) : new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        if (n2 > 0) {
            if (n2 != 127) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, 2, false));
            } else {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, 0, false));
            }
        }
    }

    public void enableShortcuts(AbstractDoc abstractDoc) {
        InputHandler inputHandler = abstractDoc.getInputHandler();
        inputHandler.addKeyBinding("C+N", this, "new");
        inputHandler.addKeyBinding("C+O", this, "open");
        inputHandler.addKeyBinding("C+S", this, "save");
        inputHandler.addKeyBinding("C+P", this, "print");
        inputHandler.addKeyBinding("C+W", this, "close");
        inputHandler.addKeyBinding("C+F4", this, "close");
        inputHandler.addKeyBinding("C+Q", this, "quit");
        inputHandler.addKeyBinding("A+X", this, "quit");
        inputHandler.addKeyBinding("A+F4", this, "quit");
        inputHandler.addKeyBinding("C+Z", this, "undo");
        inputHandler.addKeyBinding("C+Y", this, "redo");
        inputHandler.addKeyBinding("C+X", this, "cut");
        inputHandler.addKeyBinding("S+DELETE", this, "cut");
        inputHandler.addKeyBinding("C+C", this, "copy");
        inputHandler.addKeyBinding("C+INSERT", this, "copy");
        inputHandler.addKeyBinding("C+V", this, "paste");
        inputHandler.addKeyBinding("S+INSERT", this, "paste");
        inputHandler.addKeyBinding("C+F", this, "find");
        inputHandler.addKeyBinding("F3", this, "find");
        inputHandler.addKeyBinding("C+R", this, "replace");
        inputHandler.addKeyBinding("C+LEFT", this, "left_indent");
        inputHandler.addKeyBinding("C+RIGHT", this, "right_indent");
        inputHandler.addKeyBinding("C+UP", this, "uppercase");
        inputHandler.addKeyBinding("C+DOWN", this, "lowercase");
        inputHandler.addKeyBinding("C+O", this, "optGen");
        inputHandler.addKeyBinding("F10", this, "optGen");
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public void newBuffer(String string) {
        System.out.println("buffer");
        this.newFile();
        this.inputArea.setText(string);
    }

    static {
        textAreasCurrentSize = 0;
    }
}

