/*
 * Decompiled with CFR 0.152.
 */
package jedit.lang;

import jedit.KeywordMap;
import jedit.lang.SchemeTokenMarker;

public class JessTokenMarker
extends SchemeTokenMarker {
    private static KeywordMap jessKeywords;

    public JessTokenMarker() {
        super(false, JessTokenMarker.getKeywordMap());
    }

    public static KeywordMap getKeywordMap() {
        if (jessKeywords == null) {
            jessKeywords = new KeywordMap(false);
            JessTokenMarker.addMiscellaneousfunctions();
            JessTokenMarker.addFunctionsrelatedtofilesandotherIO();
            JessTokenMarker.addFunctionsforinteractingwithJavacode();
            JessTokenMarker.addLogicalfunctions();
            JessTokenMarker.addFunctionsusedprimarilyfordebugging();
            JessTokenMarker.addFunctionsforworkingwithdefqueries();
            JessTokenMarker.addControlstructures();
            JessTokenMarker.addFunctionsforprettyprintingconstructs();
            JessTokenMarker.addFunctionsforinteractingwiththeruleengine();
            JessTokenMarker.addMathematicalfunctions();
            JessTokenMarker.addFunctionswhichquerythetypeofaValue();
            JessTokenMarker.addStringmanipulationfunctions();
            JessTokenMarker.addFunctionsforworkingwithmultifields();
            JessTokenMarker.addFunctionsforworkingwithfacts();
        }
        return jessKeywords;
    }

    private static void addFunctionsforinteractingwithJavacode() {
        jessKeywords.add("call", (byte)6);
        jessKeywords.add("context", (byte)6);
        jessKeywords.add("defclass", (byte)6);
        jessKeywords.add("definstance", (byte)6);
        jessKeywords.add("get", (byte)6);
        jessKeywords.add("get-member", (byte)6);
        jessKeywords.add("import", (byte)6);
        jessKeywords.add("instanceof", (byte)6);
        jessKeywords.add("load-function", (byte)6);
        jessKeywords.add("load-package", (byte)6);
        jessKeywords.add("new", (byte)6);
        jessKeywords.add("set", (byte)6);
        jessKeywords.add("set-member", (byte)6);
        jessKeywords.add("throw", (byte)6);
        jessKeywords.add("try", (byte)6);
        jessKeywords.add("undefinstance", (byte)6);
    }

    private static void addControlstructures() {
        jessKeywords.add("apply", (byte)6);
        jessKeywords.add("call-on-engine", (byte)6);
        jessKeywords.add("foreach", (byte)6);
        jessKeywords.add("if", (byte)6);
        jessKeywords.add("then", (byte)6);
        jessKeywords.add("else", (byte)6);
        jessKeywords.add("progn", (byte)6);
        jessKeywords.add("return", (byte)6);
        jessKeywords.add("while", (byte)6);
        jessKeywords.add("do", (byte)6);
    }

    private static void addFunctionswhichquerythetypeofaValue() {
        jessKeywords.add("evenp", (byte)6);
        jessKeywords.add("external-addressp", (byte)6);
        jessKeywords.add("floatp", (byte)6);
        jessKeywords.add("integerp", (byte)6);
        jessKeywords.add("lexemep", (byte)6);
        jessKeywords.add("longp", (byte)6);
        jessKeywords.add("multifieldp", (byte)6);
        jessKeywords.add("numberp", (byte)6);
        jessKeywords.add("oddp", (byte)6);
        jessKeywords.add("stringp", (byte)6);
        jessKeywords.add("subsetp", (byte)6);
        jessKeywords.add("symbolp", (byte)6);
    }

    private static void addMiscellaneousfunctions() {
        jessKeywords.add("bag", (byte)7);
        jessKeywords.add("bind", (byte)7);
        jessKeywords.add("clear-storage", (byte)7);
        jessKeywords.add("fetch", (byte)7);
        jessKeywords.add("gensym*", (byte)7);
        jessKeywords.add("jess-version-number", (byte)7);
        jessKeywords.add("jess-version-string", (byte)7);
        jessKeywords.add("set-factory", (byte)7);
        jessKeywords.add("setgen", (byte)7);
        jessKeywords.add("store", (byte)7);
        jessKeywords.add("system", (byte)7);
        jessKeywords.add("time", (byte)7);
    }

    private static void addFunctionsusedprimarilyfordebugging() {
        jessKeywords.add("list-function$", (byte)7);
        jessKeywords.add("matches", (byte)7);
        jessKeywords.add("show-jess-listeners", (byte)7);
        jessKeywords.add("unwatch", (byte)7);
        jessKeywords.add("view", (byte)7);
        jessKeywords.add("watch", (byte)7);
    }

    private static void addFunctionsforinteractingwiththeruleengine() {
        jessKeywords.add("agenda", (byte)7);
        jessKeywords.add("batch", (byte)7);
        jessKeywords.add("bload", (byte)7);
        jessKeywords.add("bsave", (byte)7);
        jessKeywords.add("build", (byte)7);
        jessKeywords.add("clear", (byte)7);
        jessKeywords.add("defadvice", (byte)7);
        jessKeywords.add("do-backward-chaining", (byte)7);
        jessKeywords.add("engine", (byte)7);
        jessKeywords.add("eval", (byte)7);
        jessKeywords.add("exit", (byte)7);
        jessKeywords.add("focus", (byte)7);
        jessKeywords.add("get-reset-globals", (byte)7);
        jessKeywords.add("get-salience-evaluation", (byte)7);
        jessKeywords.add("halt", (byte)7);
        jessKeywords.add("reset", (byte)7);
        jessKeywords.add("run", (byte)7);
        jessKeywords.add("run-until-halt", (byte)7);
        jessKeywords.add("set-node-index-hash", (byte)7);
        jessKeywords.add("set-reset-globals", (byte)7);
        jessKeywords.add("set-salience-evaluation", (byte)7);
        jessKeywords.add("set-strategy", (byte)7);
        jessKeywords.add("undefadvice", (byte)7);
        jessKeywords.add("undefrule", (byte)7);
        jessKeywords.add("get-focus", (byte)7);
        jessKeywords.add("set-current-module", (byte)7);
        jessKeywords.add("get-current-module", (byte)7);
        jessKeywords.add("list-focus-stack", (byte)7);
        jessKeywords.add("get-focus-stack", (byte)7);
        jessKeywords.add("clear-focus-stack", (byte)7);
        jessKeywords.add("pop-focus", (byte)7);
    }

    private static void addFunctionsrelatedtofilesandotherIO() {
        jessKeywords.add("close", (byte)8);
        jessKeywords.add("format", (byte)8);
        jessKeywords.add("get-multithreaded-io", (byte)8);
        jessKeywords.add("open", (byte)8);
        jessKeywords.add("printout", (byte)8);
        jessKeywords.add("read", (byte)8);
        jessKeywords.add("readline", (byte)8);
        jessKeywords.add("set-multithreaded-io", (byte)8);
        jessKeywords.add("socket", (byte)8);
    }

    private static void addFunctionsforworkingwithdefqueries() {
        jessKeywords.add("count-query-results", (byte)8);
        jessKeywords.add("run-query", (byte)8);
    }

    private static void addFunctionsforprettyprintingconstructs() {
        jessKeywords.add("ppdeffunction", (byte)8);
        jessKeywords.add("ppdefglobal", (byte)8);
        jessKeywords.add("ppdefquery", (byte)8);
        jessKeywords.add("ppdefrule", (byte)8);
        jessKeywords.add("ppdeffacts", (byte)8);
        jessKeywords.add("ppdeftemplate", (byte)8);
        jessKeywords.add("deffunction", (byte)8);
        jessKeywords.add("defglobal", (byte)8);
        jessKeywords.add("defquery", (byte)8);
        jessKeywords.add("defrule", (byte)8);
        jessKeywords.add("deffacts", (byte)8);
        jessKeywords.add("deftemplate", (byte)8);
        jessKeywords.add("rules", (byte)8);
        jessKeywords.add("show-deffacts", (byte)8);
        jessKeywords.add("show-deftemplates", (byte)8);
        jessKeywords.add("list-deftemplates", (byte)8);
    }

    private static void addFunctionsforworkingwithmultifields() {
        jessKeywords.add("complement$", (byte)8);
        jessKeywords.add("create$", (byte)8);
        jessKeywords.add("delete$", (byte)8);
        jessKeywords.add("explode$", (byte)8);
        jessKeywords.add("first$", (byte)8);
        jessKeywords.add("implode$", (byte)8);
        jessKeywords.add("insert$", (byte)8);
        jessKeywords.add("intersection$", (byte)8);
        jessKeywords.add("length$", (byte)8);
        jessKeywords.add("member$", (byte)8);
        jessKeywords.add("nth$", (byte)8);
        jessKeywords.add("replace$", (byte)8);
        jessKeywords.add("rest$", (byte)8);
        jessKeywords.add("subseq$", (byte)8);
        jessKeywords.add("union$", (byte)8);
    }

    private static void addFunctionsforworkingwithfacts() {
        jessKeywords.add("assert", (byte)8);
        jessKeywords.add("assert-string", (byte)8);
        jessKeywords.add("fact-id", (byte)8);
        jessKeywords.add("fact-slot-value", (byte)8);
        jessKeywords.add("facts", (byte)8);
        jessKeywords.add("load-facts", (byte)8);
        jessKeywords.add("modify", (byte)8);
        jessKeywords.add("duplicate", (byte)8);
        jessKeywords.add("retract", (byte)8);
        jessKeywords.add("retract-string", (byte)8);
        jessKeywords.add("save-facts", (byte)8);
    }

    private static void addLogicalfunctions() {
        jessKeywords.add("and", (byte)4);
        jessKeywords.add("bit-and", (byte)4);
        jessKeywords.add("bit-not", (byte)4);
        jessKeywords.add("bit-or", (byte)4);
        jessKeywords.add("not", (byte)4);
        jessKeywords.add("or", (byte)4);
        jessKeywords.add("t", (byte)4);
        jessKeywords.add("f", (byte)4);
        jessKeywords.add("true", (byte)4);
        jessKeywords.add("false", (byte)4);
        jessKeywords.add("crlf", (byte)4);
    }

    private static void addMathematicalfunctions() {
        jessKeywords.add("**", (byte)4);
        jessKeywords.add("+", (byte)4);
        jessKeywords.add("-", (byte)4);
        jessKeywords.add("/", (byte)4);
        jessKeywords.add("<", (byte)4);
        jessKeywords.add("<=", (byte)4);
        jessKeywords.add("<>", (byte)4);
        jessKeywords.add("=", (byte)4);
        jessKeywords.add(">", (byte)4);
        jessKeywords.add(">=", (byte)4);
        jessKeywords.add("abs", (byte)4);
        jessKeywords.add("div", (byte)4);
        jessKeywords.add("e", (byte)4);
        jessKeywords.add("eq", (byte)4);
        jessKeywords.add("eq*", (byte)4);
        jessKeywords.add("exp", (byte)4);
        jessKeywords.add("float", (byte)4);
        jessKeywords.add("integer", (byte)4);
        jessKeywords.add("log", (byte)4);
        jessKeywords.add("log10", (byte)4);
        jessKeywords.add("long", (byte)4);
        jessKeywords.add("max", (byte)4);
        jessKeywords.add("min", (byte)4);
        jessKeywords.add("mod", (byte)4);
        jessKeywords.add("neq", (byte)4);
        jessKeywords.add("pi", (byte)4);
        jessKeywords.add("random", (byte)4);
        jessKeywords.add("round", (byte)4);
        jessKeywords.add("sqrt", (byte)4);
        jessKeywords.add("*", (byte)4);
    }

    private static void addStringmanipulationfunctions() {
        jessKeywords.add("lowcase", (byte)4);
        jessKeywords.add("str-cat", (byte)4);
        jessKeywords.add("str-compare", (byte)4);
        jessKeywords.add("str-index", (byte)4);
        jessKeywords.add("str-length", (byte)4);
        jessKeywords.add("sub-string", (byte)4);
        jessKeywords.add("sym-cat", (byte)4);
        jessKeywords.add("upcase", (byte)4);
    }
}

