/*
 * Decompiled with CFR 0.152.
 */
package gnu.search;

import gnu.UUtilities;
import gnu.gui.JextCheckBox;
import gnu.gui.JextHighlightButton;
import gnu.gui.ModifiedCellRenderer;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import gnu.search.LiteralSearchMatcher;
import gnu.search.SearchHighlight;
import gnu.search.SearchResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import jedit.syntax.SyntaxDocument;
import jsynedit.AbstractDoc;
import jsynedit.AbstractEditorPanel;

public class FindAll
extends JPanel
implements ActionListener {
    private JList results;
    private AbstractEditorPanel parent;
    private JComboBox fieldSearch;
    private DefaultListModel resultModel;
    private JTextField fieldSearchEditor;
    private JextHighlightButton find;
    private JextHighlightButton unHighlight;
    private JextCheckBox useRegexp;
    private JextCheckBox ignoreCase;
    private JextCheckBox highlight;
    private JextCheckBox allFiles;

    public FindAll(AbstractEditorPanel abstractEditorPanel) {
        String string;
        this.parent = abstractEditorPanel;
        this.setLayout(new BorderLayout());
        this.fieldSearch = new JComboBox();
        this.fieldSearch.setRenderer(new ModifiedCellRenderer());
        this.fieldSearch.setEditable(true);
        this.fieldSearchEditor = (JTextField)this.fieldSearch.getEditor().getEditorComponent();
        this.fieldSearchEditor.addKeyListener(new KeyHandler());
        FontMetrics fontMetrics = this.getFontMetrics(this.fieldSearch.getFont());
        this.add((Component)this.fieldSearch, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 1));
        this.ignoreCase = new JextCheckBox("Ignore Case", true);
        jPanel.add(this.ignoreCase);
        this.useRegexp = new JextCheckBox("Use Extended RegExp", true);
        jPanel.add(this.useRegexp);
        this.highlight = new JextCheckBox("Highlight", true);
        jPanel.add(this.highlight);
        this.allFiles = new JextCheckBox("In All Files", false);
        jPanel.add(this.allFiles);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.find = new JextHighlightButton("Find All");
        jToolBar.add(this.find);
        this.unHighlight = new JextHighlightButton("Unhighlight");
        jToolBar.add(this.unHighlight);
        jPanel.add(jToolBar);
        this.find.addActionListener(this);
        this.unHighlight.addActionListener(this);
        this.add((Component)jPanel, "South");
        this.resultModel = new DefaultListModel();
        this.results = new JList();
        this.results.setCellRenderer(new ModifiedCellRenderer());
        this.results.addListSelectionListener(new ListHandler());
        this.results.setModel(this.resultModel);
        Dimension dimension = new Dimension(20 * fontMetrics.charWidth('m'), 10 * this.results.getFixedCellHeight());
        JScrollPane jScrollPane = new JScrollPane(this.results, 22, 32);
        jScrollPane.setMaximumSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        this.add((Component)jScrollPane, "Center");
        for (int i = 0; i < 25 && (string = AbstractEditorPanel.getProperty("search.all.history." + i)) != null; ++i) {
            this.fieldSearch.addItem(string);
        }
        string = AbstractEditorPanel.getProperty("find.all");
        this.addSearchHistory(string);
        this.fieldSearch.setSelectedItem(string);
    }

    public void exit() {
        int n;
        AbstractEditorPanel.setProperty("find.all", this.fieldSearchEditor.getText());
        for (n = 0; n < this.fieldSearch.getItemCount(); ++n) {
            AbstractEditorPanel.setProperty("search.all.history." + n, (String)this.fieldSearch.getItemAt(n));
        }
        for (n = this.fieldSearch.getItemCount(); n < 25; ++n) {
            AbstractEditorPanel.unsetProperty("search.all.history." + n);
        }
        AbstractEditorPanel.setProperty("useregexp.all", this.useRegexp.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("ignorecase.all", this.ignoreCase.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("highlight.all", this.highlight.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("allfiles.all", this.allFiles.isSelected() ? "on" : "off");
        this.removeHighlights();
        this.parent.getTextArea().repaint();
    }

    private void removeHighlights() {
        AbstractDoc[] abstractDocArray = this.parent.getTextAreas();
        for (int i = 0; i < abstractDocArray.length; ++i) {
            SearchHighlight searchHighlight = null;
            if (abstractDocArray[i] != null) {
                searchHighlight = abstractDocArray[i].getSearchHighlight();
            }
            if (searchHighlight == null) continue;
            searchHighlight.disable();
        }
    }

    private void addSearchHistory() {
        this.addSearchHistory(this.fieldSearchEditor.getText());
    }

    private void addSearchHistory(String string) {
        int n;
        if (string == null || string.equals("")) {
            return;
        }
        for (n = 0; n < this.fieldSearch.getItemCount(); ++n) {
            if (!((String)this.fieldSearch.getItemAt(n)).equals(string)) continue;
            this.fieldSearch.setSelectedIndex(n);
            return;
        }
        this.fieldSearch.insertItemAt(string, 0);
        this.fieldSearch.setSelectedIndex(0);
        if (this.fieldSearch.getItemCount() > 25) {
            for (n = 24; n < this.fieldSearch.getItemCount(); ++n) {
                this.fieldSearch.removeItemAt(n);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.find) {
            this.findAll();
        } else if (actionEvent.getSource() == this.unHighlight) {
            this.removeHighlights();
            this.parent.getTextArea().repaint();
        }
    }

    public void findText() {
        String string = this.parent.getTextArea().getSelectedText();
        this.fieldSearchEditor.setText(string);
        this.fieldSearchEditor.requestFocus();
        this.findAll();
        if (string != null && string.length() > 0) {
            ListModel listModel = this.results.getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                SearchResult searchResult = (SearchResult)listModel.getElementAt(i);
                int[] nArray = searchResult.getPos();
                if (this.parent.getTextArea().getSelectionStart() != nArray[0] || this.parent.getTextArea().getSelectionEnd() != nArray[1] || this.parent.getTextArea() != searchResult.getTextArea()) continue;
                this.results.setSelectedIndex(i);
                i = listModel.getSize() + 10;
                this.results.requestFocus();
            }
        }
        this.parent.getVerticalTabbedPane().setSelectedComponent(this);
        if (!"on".equals(AbstractEditorPanel.getProperty("leftPanel.show"))) {
            AbstractEditorPanel.setProperty("leftPanel.show", "on");
            this.parent.triggerTabbedPanes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAll() {
        String string = this.fieldSearchEditor.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        UUtilities.setCursorOnWait(this, true);
        this.addSearchHistory();
        this.resultModel.removeAllElements();
        AbstractDoc[] abstractDocArray = null;
        abstractDocArray = this.allFiles.isSelected() ? this.parent.getTextAreas() : new AbstractDoc[]{this.parent.getTextArea()};
        for (int i = 0; i < abstractDocArray.length; ++i) {
            SearchHighlight searchHighlight;
            AbstractDoc abstractDoc = abstractDocArray[i];
            ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
            SyntaxDocument syntaxDocument = abstractDoc.getDocument();
            Element element = syntaxDocument.getDefaultRootElement();
            int n = element.getElementCount();
            boolean bl = this.highlight.isSelected();
            boolean bl2 = this.useRegexp.isSelected();
            LiteralSearchMatcher literalSearchMatcher = null;
            if (!bl2) {
                literalSearchMatcher = new LiteralSearchMatcher(string, null, this.ignoreCase.isSelected());
            }
            try {
                for (int j = 1; j <= n; ++j) {
                    int[] nArray;
                    Element element2 = element.getElement(j - 1);
                    int n2 = element2.getStartOffset();
                    String string2 = syntaxDocument.getText(n2, element2.getEndOffset() - n2 - 1);
                    int n3 = 0;
                    do {
                        if ((nArray = bl2 ? this.nextMatch(string2, n3) : literalSearchMatcher.nextMatch(string2, n3)) == null) continue;
                        SearchResult searchResult = new SearchResult(abstractDoc, syntaxDocument.createPosition(n2 + nArray[0]), syntaxDocument.createPosition(n2 + nArray[1]));
                        this.resultModel.addElement(searchResult);
                        if (bl) {
                            arrayList.add(searchResult);
                        }
                        n3 = nArray[1];
                    } while (nArray != null);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                UUtilities.setCursorOnWait(this, false);
            }
            if (this.resultModel.isEmpty()) {
                abstractDoc.getToolkit().beep();
            }
            this.results.setModel(this.resultModel);
            if (bl) {
                abstractDoc.initSearchHighlight();
                searchHighlight = abstractDoc.getSearchHighlight();
                searchHighlight.trigger(true);
                searchHighlight.setMatches(arrayList);
            } else {
                searchHighlight = abstractDoc.getSearchHighlight();
                if (searchHighlight != null) {
                    searchHighlight.trigger(false);
                    searchHighlight.setMatches(null);
                }
            }
            abstractDoc.repaint();
        }
    }

    private int[] nextMatch(String string, int n) {
        try {
            if (string.equals("") || string == null) {
                return null;
            }
            RE rE = new RE((String)this.fieldSearch.getSelectedItem(), this.ignoreCase.isSelected() ? 2 : 0, RESyntax.RE_SYNTAX_PERL5);
            if (rE == null) {
                this.getToolkit().beep();
                return null;
            }
            REMatch rEMatch = rE.getMatch(string, n);
            if (rEMatch != null) {
                int[] nArray = new int[]{rEMatch.getStartIndex(), rEMatch.getEndIndex()};
                return nArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.results = null;
        this.parent = null;
        this.fieldSearch = null;
        this.resultModel = null;
        this.fieldSearchEditor = null;
        this.find = null;
        this.useRegexp = null;
        this.ignoreCase = null;
        this.highlight = null;
        this.allFiles = null;
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    FindAll.this.findAll();
                }
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (FindAll.this.results.isSelectionEmpty() || listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            SearchResult searchResult = (SearchResult)FindAll.this.results.getSelectedValue();
            if (FindAll.this.parent.getTextArea() != searchResult.getTextArea()) {
                FindAll.this.parent.getTabbedPane().setSelectedComponent(searchResult.getTextArea());
                FindAll.this.results.requestFocus();
            }
            int[] nArray = searchResult.getPos();
            searchResult.getTextArea().select(nArray[0], nArray[1]);
        }
    }
}

