/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import gnu.regexp.RETokenChar;
import java.util.Vector;

final class RETokenOneOf
extends REToken {
    private Vector options;
    private boolean negative;

    RETokenOneOf(int n, String string, boolean bl, boolean bl2) {
        super(n);
        this.options = new Vector();
        this.negative = bl;
        for (int i = 0; i < string.length(); ++i) {
            this.options.addElement(new RETokenChar(n, string.charAt(i), bl2));
        }
    }

    RETokenOneOf(int n, Vector vector, boolean bl) {
        super(n);
        this.options = vector;
        this.negative = bl;
    }

    int getMinimumLength() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.options.size(); ++i) {
            int n2 = ((REToken)this.options.elementAt(i)).getMinimumLength();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.negative && charIndexed.charAt(rEMatch.index) == '\uffff') {
            return false;
        }
        REMatch rEMatch2 = null;
        REMatch rEMatch3 = null;
        for (int i = 0; i < this.options.size(); ++i) {
            REMatch rEMatch4;
            REToken rEToken = (REToken)this.options.elementAt(i);
            if (!rEToken.match(charIndexed, rEMatch4 = (REMatch)rEMatch.clone())) continue;
            if (this.negative) {
                return false;
            }
            if (!this.next(charIndexed, rEMatch4)) continue;
            if (rEMatch3 == null) {
                rEMatch2 = rEMatch4;
                rEMatch3 = rEMatch4;
                continue;
            }
            rEMatch3.next = rEMatch4;
            rEMatch3 = rEMatch4;
        }
        if (rEMatch2 != null) {
            if (this.negative) {
                return false;
            }
            rEMatch.assignFrom(rEMatch2);
            return true;
        }
        if (this.negative) {
            ++rEMatch.index;
            return this.next(charIndexed, rEMatch);
        }
        return false;
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append(this.negative ? "[^" : "(?:");
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.negative && i > 0) {
                stringBuffer.append('|');
            }
            ((REToken)this.options.elementAt(i)).dumpAll(stringBuffer);
        }
        stringBuffer.append(this.negative ? (char)']' : ')');
    }
}

