/*
 * Decompiled with CFR 0.152.
 */
package gnu.options;

import gnu.gui.AbstractOptionPane;
import gnu.gui.FontSelector;
import gnu.gui.JextCheckBox;
import gnu.gui.ModifiedCellRenderer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import jsynedit.AbstractEditorPanel;

public class EditorOptions
extends AbstractOptionPane {
    private FontSelector fonts;
    private JTextField autoScroll = new JTextField(4);
    private JTextField linesInterval;
    private JTextField wrapGuide;
    private JComboBox newline;
    private JComboBox tabSize;
    private JComboBox modes;
    private JComboBox encoding;
    private JComboBox orientation;
    private JextCheckBox enterIndent;
    private JextCheckBox tabIndent;
    private JextCheckBox softTabs;
    private JextCheckBox blockCaret;
    private JextCheckBox selection;
    private JextCheckBox smartHomeEnd;
    private JextCheckBox splitArea;
    private JextCheckBox fullFileName;
    private JextCheckBox lineHighlight;
    private JextCheckBox eolMarkers;
    private JextCheckBox blinkCaret;
    private JextCheckBox tabStop;
    private JextCheckBox linesIntervalEnabled;
    private JextCheckBox wrapGuideEnabled;
    private JextCheckBox dirDefaultDialog;
    private JextCheckBox overSpace;
    private JextCheckBox addExtraLineFeed;
    private JextCheckBox preserveLineTerm;
    private String[] modeNames;

    public EditorOptions() {
        super("editor");
        this.addComponent("Auto scroll", this.autoScroll);
        this.autoScroll.setCursor(Cursor.getPredefinedCursor(2));
        this.linesInterval = new JTextField(4);
        this.addComponent("Interval highlight", this.linesInterval);
        this.linesInterval.setCursor(Cursor.getPredefinedCursor(2));
        this.wrapGuide = new JTextField(4);
        this.addComponent("Wrap guide offset", this.wrapGuide);
        this.wrapGuide.setCursor(Cursor.getPredefinedCursor(2));
        String[] stringArray = new String[]{"ASCII", "Cp850", "Cp1252", "iso-8859-1", "iso-8859-2", "KOI8_R", "MacRoman", "UTF8", "UTF16", "Unicode"};
        this.encoding = new JComboBox<String>(stringArray);
        this.encoding.setRenderer(new ModifiedCellRenderer());
        this.encoding.setEditable(true);
        this.addComponent("File encoding", this.encoding);
        this.fonts = new FontSelector("editor");
        this.addComponent("Font", this.fonts);
        String[] stringArray2 = new String[]{"2", "4", "8", "16"};
        this.tabSize = new JComboBox<String>(stringArray2);
        this.tabSize.setEditable(true);
        this.addComponent("Tabs size", this.tabSize);
        this.tabSize.setRenderer(new ModifiedCellRenderer());
        int n = 0;
        String[] stringArray3 = new String[n];
        this.modeNames = new String[n];
        this.modes = new JComboBox<String>(stringArray3);
        this.modes.setRenderer(new ModifiedCellRenderer());
        this.addComponent("Colorizing mode", this.modes);
        String[] stringArray4 = new String[]{"MacOS (\\r)", "Unix (\\n)", "Windows (\\r\\n)"};
        this.newline = new JComboBox<String>(stringArray4);
        this.newline.setRenderer(new ModifiedCellRenderer());
        this.addComponent("Line separator", this.newline);
        String[] stringArray5 = new String[]{"Vertical", "Horizontal"};
        this.orientation = new JComboBox<String>(stringArray5);
        this.orientation.setRenderer(new ModifiedCellRenderer());
        this.addComponent("Split orientation", this.orientation);
        this.linesIntervalEnabled = new JextCheckBox("Enable interval highlighting");
        this.addComponent(this.linesIntervalEnabled);
        this.wrapGuideEnabled = new JextCheckBox("Enable wrap guide");
        this.addComponent(this.wrapGuideEnabled);
        this.splitArea = new JextCheckBox("Splits editor");
        this.addComponent(this.splitArea);
        this.blockCaret = new JextCheckBox("Block caret");
        this.addComponent(this.blockCaret);
        this.blinkCaret = new JextCheckBox("Blinking caret");
        this.addComponent(this.blinkCaret);
        this.lineHighlight = new JextCheckBox("Line highlighting");
        this.addComponent(this.lineHighlight);
        this.eolMarkers = new JextCheckBox("End of line markers");
        this.addComponent(this.eolMarkers);
        this.softTabs = new JextCheckBox("Soft tabs");
        this.addComponent(this.softTabs);
        this.tabIndent = new JextCheckBox("Indent on TAB");
        this.addComponent(this.tabIndent);
        this.enterIndent = new JextCheckBox("Indent on ENTER");
        this.addComponent(this.enterIndent);
        this.tabStop = new JextCheckBox("Tab stops");
        this.addComponent(this.tabStop);
        this.overSpace = new JextCheckBox("Word jumping goes over spaces");
        this.addComponent(this.overSpace);
        this.smartHomeEnd = new JextCheckBox("Smart HOME/END");
        this.addComponent(this.smartHomeEnd);
        this.dirDefaultDialog = new JextCheckBox("Default dir from active file");
        this.addComponent(this.dirDefaultDialog);
        this.selection = new JextCheckBox("Use selection as search pattern");
        this.addComponent(this.selection);
        this.addExtraLineFeed = new JextCheckBox("Append an extra line feed on save");
        this.addComponent(this.addExtraLineFeed);
        this.preserveLineTerm = new JextCheckBox("Keep existing line separator on open");
        this.addComponent(this.preserveLineTerm);
        this.load();
    }

    public void load() {
        this.fonts.load();
    }

    public Component getComponent() {
        JScrollPane jScrollPane = new JScrollPane(this);
        Dimension dimension = this.getPreferredSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width, 410));
        jScrollPane.setBorder(LineBorder.createBlackLineBorder());
        return jScrollPane;
    }

    public void save() {
        System.out.println("--------- encoding == " + (String)this.encoding.getSelectedItem() + "  --- file encoding : " + System.getProperty("file.encoding") + "------------");
        AbstractEditorPanel.setProperty("blockCaret", this.blockCaret.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("blinkingCaret", this.blinkCaret.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("lineHighlight", this.lineHighlight.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("eolMarkers", this.eolMarkers.isSelected() ? "on" : "off");
        this.fonts.save();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.fonts = null;
        this.autoScroll = null;
        this.linesInterval = null;
        this.wrapGuide = null;
        this.newline = null;
        this.tabSize = null;
        this.modes = null;
        this.encoding = null;
        this.orientation = null;
        this.enterIndent = null;
        this.tabIndent = null;
        this.softTabs = null;
        this.blockCaret = null;
        this.selection = null;
        this.smartHomeEnd = null;
        this.splitArea = null;
        this.fullFileName = null;
        this.lineHighlight = null;
        this.eolMarkers = null;
        this.blinkCaret = null;
        this.tabStop = null;
        this.linesIntervalEnabled = null;
        this.wrapGuideEnabled = null;
        this.dirDefaultDialog = null;
        this.overSpace = null;
        this.modeNames = null;
        this.addExtraLineFeed = null;
        this.preserveLineTerm = null;
    }
}

