/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.jbrowser.PropertyAccessor;
import javax.swing.event.ChangeListener;

public class Options {
    private boolean showStatusBar;
    private Filter filterOpt = new Filter();
    private Display displayOpt = new Display();
    private ChangeListener listener;

    public ChangeListener getListener() {
        return this.listener;
    }

    public void load(PropertyAccessor propertyAccessor) {
        int n;
        int n2;
        int n3;
        this.setShowStatusBar(!"off".equals(propertyAccessor.getProperty("jbrowse.showStatusBar")));
        this.filterOpt.setShowAttributes("on".equals(propertyAccessor.getProperty("jbrowse.showAttr")));
        this.filterOpt.setShowPrimitives("on".equals(propertyAccessor.getProperty("jbrowse.showPrimAttr")));
        this.filterOpt.setShowGeneralizations("on".equals(propertyAccessor.getProperty("jbrowse.showGeneralizations")));
        this.filterOpt.setShowThrows("on".equals(propertyAccessor.getProperty("jbrowse.showThrows")));
        try {
            n3 = Integer.parseInt(propertyAccessor.getProperty("jbrowse.topLevelVisIndex"));
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 0;
        }
        if (n3 < 0 || n3 > 1) {
            n3 = 0;
        }
        this.filterOpt.setTopLevelVisIndex(n3);
        try {
            n2 = Integer.parseInt(propertyAccessor.getProperty("jbrowse.memberVisIndex"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        if (n2 < 0 || n2 > 3) {
            n2 = 0;
        }
        this.filterOpt.setMemberVisIndex(n2);
        this.displayOpt.setShowArguments("on".equals(propertyAccessor.getProperty("jbrowse.showArgs")));
        this.displayOpt.setShowArgumentNames("on".equals(propertyAccessor.getProperty("jbrowse.showArgNames")));
        this.displayOpt.setShowNestedName("on".equals(propertyAccessor.getProperty("jbrowse.showNestedName")));
        this.displayOpt.setShowIconKeywords("on".equals(propertyAccessor.getProperty("jbrowse.showIconKeywords")));
        this.displayOpt.setShowMiscMod("on".equals(propertyAccessor.getProperty("jbrowse.showMiscMod")));
        this.displayOpt.setAlphaSort("on".equals(propertyAccessor.getProperty("jbrowse.alphaSortMethods")));
        this.displayOpt.setShowLineNum("on".equals(propertyAccessor.getProperty("jbrowse.showLineNums")));
        try {
            n = Integer.parseInt(propertyAccessor.getProperty("jbrowse.displayStyle"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n < 0 || n > 2) {
            n = 0;
        }
        this.displayOpt.setStyleIndex(n);
        this.displayOpt.setVisSymbols("on".equals(propertyAccessor.getProperty("jbrowse.custVisAsSymbol")));
        this.displayOpt.setAbstractItalic("on".equals(propertyAccessor.getProperty("jbrowse.custAbsAsItalic")));
        this.displayOpt.setStaticUlined("on".equals(propertyAccessor.getProperty("jbrowse.custStaAsUlined")));
        this.displayOpt.setTypeIsSuffixed("on".equals(propertyAccessor.getProperty("jbrowse.custTypeIsSuffixed")));
    }

    public void save(PropertyAccessor propertyAccessor) {
        propertyAccessor.setProperty("jbrowse.showStatusBar", this.getShowStatusBar() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showAttr", this.filterOpt.getShowAttributes() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showPrimAttr", this.filterOpt.getShowPrimitives() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showGeneralizations", this.filterOpt.getShowGeneralizations() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showThrows", this.filterOpt.getShowThrows() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.topLevelVisIndex", String.valueOf(this.filterOpt.getTopLevelVisIndex()));
        propertyAccessor.setProperty("jbrowse.memberVisIndex", String.valueOf(this.filterOpt.getMemberVisIndex()));
        propertyAccessor.setProperty("jbrowse.showArgs", this.displayOpt.getShowArguments() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showArgNames", this.displayOpt.getShowArgumentNames() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showNestedName", this.displayOpt.getShowNestedName() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showIconKeywords", this.displayOpt.getShowIconKeywords() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showMiscMod", this.displayOpt.getShowMiscMod() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.alphaSortMethods", this.displayOpt.getAlphaSort() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.showLineNums", this.displayOpt.getShowLineNum() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.displayStyle", String.valueOf(this.displayOpt.getStyleIndex()));
        propertyAccessor.setProperty("jbrowse.custVisAsSymbol", this.displayOpt.getVisSymbols() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.custAbsAsItalic", this.displayOpt.getAbstractItalic() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.custStaAsUlined", this.displayOpt.getStaticUlined() ? "on" : "off");
        propertyAccessor.setProperty("jbrowse.custTypeIsSuffixed", this.displayOpt.getTypeIsSuffixed() ? "on" : "off");
    }

    public final boolean getShowStatusBar() {
        return this.showStatusBar;
    }

    public final void setShowStatusBar(boolean bl) {
        this.showStatusBar = bl;
    }

    public final Filter getFilterOptions() {
        return this.filterOpt;
    }

    public final Display getDisplayOptions() {
        return this.displayOpt;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
    }

    public final String toString() {
        return this.filterOpt.toString() + "\n" + this.displayOpt.toString();
    }

    public static interface FilterIro {
        public boolean getShowAttributes();

        public boolean getShowPrimitives();

        public boolean getShowGeneralizations();

        public boolean getShowThrows();

        public int getTopLevelVisIndex();

        public int getMemberVisIndex();
    }

    public static class Filter
    implements FilterIro {
        private boolean showAttributes;
        private boolean showPrimitives;
        private boolean showGeneralizations;
        private boolean showThrows;
        private int topLevelVisIndex = 0;
        private int memberVisIndex = 0;

        public final boolean getShowAttributes() {
            return this.showAttributes;
        }

        public final boolean getShowPrimitives() {
            return this.showPrimitives;
        }

        public final boolean getShowGeneralizations() {
            return this.showGeneralizations;
        }

        public final boolean getShowThrows() {
            return this.showThrows;
        }

        public final int getTopLevelVisIndex() {
            return this.topLevelVisIndex;
        }

        public final int getMemberVisIndex() {
            return this.memberVisIndex;
        }

        public final void setShowAttributes(boolean bl) {
            this.showAttributes = bl;
        }

        public final void setShowPrimitives(boolean bl) {
            this.showPrimitives = bl;
        }

        public final void setShowGeneralizations(boolean bl) {
            this.showGeneralizations = bl;
        }

        public final void setShowThrows(boolean bl) {
            this.showThrows = bl;
        }

        public final void setTopLevelVisIndex(int n) {
            this.topLevelVisIndex = n;
        }

        public final void setMemberVisIndex(int n) {
            this.memberVisIndex = n;
        }

        public String toString() {
            return "What to include:\n\tshowAttributes      = " + this.showAttributes + "\n\tshowPrimitives      = " + this.showPrimitives + "\n\tshowGeneralizations = " + this.showGeneralizations + "\n\tshowThrows          = " + this.showThrows + "\n\ttopLevelVisIndex    = " + this.topLevelVisIndex + "\n\tmemberVisIndex      = " + this.memberVisIndex;
        }
    }

    public static interface DisplayIro {
        public static final int STYLE_FIRST = 0;
        public static final int STYLE_UML = 0;
        public static final int STYLE_JAVA = 1;
        public static final int STYLE_CUSTOM = 2;
        public static final int STYLE_LAST = 2;

        public boolean getShowArguments();

        public boolean getShowArgumentNames();

        public boolean getShowNestedName();

        public boolean getShowIconKeywords();

        public boolean getShowMiscMod();

        public boolean getAlphaSort();

        public boolean getShowLineNum();

        public int getStyleIndex();

        public boolean getVisSymbols();

        public boolean getAbstractItalic();

        public boolean getStaticUlined();

        public boolean getTypeIsSuffixed();

        public DisplayIro getInverseOptions();
    }

    public static class Display
    implements DisplayIro {
        private boolean showArguments;
        private boolean showArgumentNames;
        private boolean showNestedName;
        private boolean showIconKeywords;
        private boolean showMiscMod;
        private boolean alphaSort;
        private boolean showLineNum;
        private int styleIndex = 0;
        private boolean visSymbols;
        private boolean abstractItalic;
        private boolean staticUlined;
        private boolean typeIsSuffixed;

        public final boolean getShowArguments() {
            return this.showArguments;
        }

        public final boolean getShowArgumentNames() {
            return this.showArgumentNames;
        }

        public final boolean getShowNestedName() {
            return this.showNestedName;
        }

        public final boolean getShowIconKeywords() {
            return this.showIconKeywords;
        }

        public final boolean getShowMiscMod() {
            return this.showMiscMod;
        }

        public final boolean getAlphaSort() {
            return this.alphaSort;
        }

        public final boolean getShowLineNum() {
            return this.showLineNum;
        }

        public final int getStyleIndex() {
            return this.styleIndex;
        }

        public final boolean getVisSymbols() {
            return this.visSymbols;
        }

        public final boolean getAbstractItalic() {
            return this.abstractItalic;
        }

        public final boolean getStaticUlined() {
            return this.staticUlined;
        }

        public final boolean getTypeIsSuffixed() {
            return this.typeIsSuffixed;
        }

        public final void setShowArguments(boolean bl) {
            this.showArguments = bl;
        }

        public final void setShowArgumentNames(boolean bl) {
            this.showArgumentNames = bl;
        }

        public final void setShowNestedName(boolean bl) {
            this.showNestedName = bl;
        }

        public final void setShowIconKeywords(boolean bl) {
            this.showIconKeywords = bl;
        }

        public final void setShowMiscMod(boolean bl) {
            this.showMiscMod = bl;
        }

        public final void setAlphaSort(boolean bl) {
            this.alphaSort = bl;
        }

        public final void setShowLineNum(boolean bl) {
            this.showLineNum = bl;
        }

        public final void setStyleIndex(int n) {
            this.styleIndex = n;
        }

        public final void setVisSymbols(boolean bl) {
            this.visSymbols = bl;
        }

        public final void setAbstractItalic(boolean bl) {
            this.abstractItalic = bl;
        }

        public final void setStaticUlined(boolean bl) {
            this.staticUlined = bl;
        }

        public final void setTypeIsSuffixed(boolean bl) {
            this.typeIsSuffixed = bl;
        }

        public final DisplayIro getInverseOptions() {
            Display display = new Display();
            display.showArguments = !this.showArguments;
            display.showArgumentNames = !this.showArgumentNames;
            display.showNestedName = !this.showNestedName;
            display.showIconKeywords = !this.showIconKeywords;
            display.showMiscMod = !this.showMiscMod;
            display.alphaSort = !this.alphaSort;
            display.showLineNum = !this.showLineNum;
            display.visSymbols = !this.visSymbols;
            display.abstractItalic = !this.abstractItalic;
            display.staticUlined = !this.staticUlined;
            boolean bl = display.typeIsSuffixed = !this.typeIsSuffixed;
            if (this.styleIndex == 0) {
                display.styleIndex = 1;
            } else if (this.styleIndex == 1) {
                display.styleIndex = 0;
            }
            return display;
        }

        public String toString() {
            return "How to display:\n\tshowArguments     = " + this.showArguments + "\n\tshowArgumentNames = " + this.showArgumentNames + "\n\tshowNestedName    = " + this.showNestedName + "\n\tshowIconKeywords  = " + this.showIconKeywords + "\n\tshowMiscMod       = " + this.showMiscMod + "\n\talphaSort         = " + this.alphaSort + "\n\tshowLineNum       = " + this.showLineNum + "\n\tstyleIndex        = " + this.styleIndex + "\n\tvisSymbols        = " + this.visSymbols + "\n\tabstractItalic    = " + this.abstractItalic + "\n\tstaticUlined      = " + this.staticUlined + "\n\ttypeIsSuffixed    = " + this.typeIsSuffixed;
        }
    }
}

