/*
 * Decompiled with CFR 0.152.
 */
package gnu.java;

import gnu.java.JSBeautifier;
import gnu.java.JSLineBreaker;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class JSFormatter {
    private static String[] headers = new String[]{"if", "else", "for", "while", "do", "try", "catch", "synchronized", "switch", "static"};
    private static String[] parenHeaders = new String[]{"if", "for", "while", "catch", "synchronized", "switch"};
    private static String[] nonParenHeaders = new String[]{"else", "do", "try", "static"};
    private static String[] statementHeaders = new String[]{"class", "interface", "throws"};
    private static String[] longOperators = new String[]{"==", "!=", ">=", "<=", "+=", "-=", "*=", "/=", "%=", "^=", "|=", "&=", "++", "--", "&&", "||", ".*"};
    private static Hashtable closingHeaders = new Hashtable();
    public JSBeautifier beautifier = new JSBeautifier();
    private JSLineBreaker lineBreaker = new JSLineBreaker();
    private StringBuffer outBuffer;
    private String tempLine = "";
    private Stack openingStack;
    private Stack parenDepthsStack;
    private Stack bracketBlockStateStack;
    private char quoteChar;
    private int parenDepth;
    private int leadingWhiteSpaces;
    private String currentHeader;
    private boolean isInHeader;
    private boolean isSpecialChar;
    private boolean isInQuote;
    private boolean isInComment;
    private boolean isBlockNeeded;
    private boolean isSpecialBlock;
    private boolean isCloseSpecialBlock;
    private boolean isParenNeeded;
    private boolean isNewLineNeeded;
    private boolean checkBlockOpen;
    private boolean checkBlockClose;
    private boolean checkIf;
    private boolean checkClosingHeader;
    private boolean foundOrigLineBreak;
    private boolean isInQuestion;
    private boolean isSummarized;
    private boolean isInBracketOpen;
    private boolean isInBracketClose;
    private boolean isInClassStatement;
    private boolean bracketBreak = false;
    private char prevNonSpaceCh;
    private char currentNonSpaceCh;

    public static void main(String[] stringArray) {
        String string;
        int n;
        JSFormatter jSFormatter = new JSFormatter();
        Vector<String> vector = new Vector<String>();
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            string = stringArray[n];
            if (string.equals("-b")) {
                jSFormatter.setBracketBreak(true);
                continue;
            }
            if ("-ib".equals(string)) {
                jSFormatter.setBracketBreak(true);
                jSFormatter.setBracketIndent(true);
                continue;
            }
            if ("-fs".equals(string)) {
                jSFormatter.setSwitchIndent(false);
                continue;
            }
            if (string.startsWith("-ll")) {
                n2 = 70;
                try {
                    n2 = Integer.valueOf(string.substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                jSFormatter.setPreferredLineLength(n2);
                continue;
            }
            if (string.startsWith("-ld")) {
                n2 = 5;
                try {
                    n2 = Integer.valueOf(string.substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                jSFormatter.setLineLengthDeviation(n2);
                continue;
            }
            if (string.equals("-nn")) {
                jSFormatter.setNestedConnection(false);
                continue;
            }
            if (string.startsWith("-") && !bl) {
                bl = true;
                System.err.println("");
                System.err.println("Usage  : java jstyle.JSFormatter [options] < Original.java > Formatted.java");
                System.err.println("         java jstyle.JSFormatter [options] Foo.java Bar.java  [...]");
                System.err.println("");
                System.err.println("When given a specific file, JSFormatter will create an output file with a");
                System.err.println("suffix of \".js\" added to the original filename, i.e: Foo.java --> Foo.java.js");
                System.err.println("");
                System.err.println("Options: -ll#  Set preferred line length to #");
                System.err.println("         -ld#  Set preferred upper line length deviation to #");
                System.err.println("         -b    Break lines BEFORE '{' brackets (ala C++ style)");
                System.err.println("         -ib   Same as '-b', but add extra indentation to brackets");
                System.err.println("         -fs   flush (i.e. don't indent) 'switch' blocks");
                System.err.println("         -h    Print this help message");
                System.err.println();
                System.exit(0);
                continue;
            }
            vector.addElement(string);
        }
        if (vector.isEmpty()) {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            printWriter = new PrintWriter(System.out);
            try {
                jSFormatter.format(bufferedReader, printWriter);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            printWriter.close();
        } else {
            for (n = 0; n < vector.size(); ++n) {
                try {
                    string = (String)vector.elementAt(n);
                    bufferedReader = new BufferedReader(new FileReader(string));
                    printWriter = new PrintWriter((Writer)new FileWriter(string + ".js"), true);
                    jSFormatter.format(bufferedReader, printWriter);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                printWriter.close();
                try {
                    bufferedReader.close();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public JSFormatter() {
        this.init();
    }

    public void init() {
        this.beautifier.init();
        this.lineBreaker.init();
        this.outBuffer = new StringBuffer();
        this.openingStack = new Stack();
        this.parenDepthsStack = new Stack();
        this.bracketBlockStateStack = new Stack();
        this.bracketBlockStateStack.push(new Boolean(true));
        this.tempLine = "";
        this.parenDepth = 0;
        this.isSpecialChar = false;
        this.isInQuote = false;
        this.isInComment = false;
        this.isBlockNeeded = false;
        this.isParenNeeded = false;
        this.isSpecialBlock = false;
        this.isCloseSpecialBlock = false;
        this.isNewLineNeeded = false;
        this.checkIf = false;
        this.checkBlockOpen = false;
        this.checkClosingHeader = false;
        this.checkBlockClose = false;
        this.foundOrigLineBreak = false;
        this.isInQuestion = false;
        this.isSummarized = false;
        this.isInBracketOpen = false;
        this.isInBracketClose = false;
        this.leadingWhiteSpaces = 0;
        this.isInHeader = false;
        this.isInClassStatement = false;
        this.prevNonSpaceCh = (char)123;
        this.currentNonSpaceCh = (char)123;
    }

    /*
     * Unable to fully structure code
     */
    public void format(BufferedReader var1_1, PrintWriter var2_2) throws IOException {
        var3_3 = null;
        this.init();
        try {
            block2: while (true) {
                if (!this.hasMoreFormattedLines()) {
                    var3_3 = var1_1.readLine();
                    if (var3_3 == null) {
                        throw new NullPointerException();
                    }
                    this.formatLine(var3_3);
                    continue;
                }
                while (true) {
                    if (this.hasMoreFormattedLines()) ** break;
                    continue block2;
                    var2_2.println(this.nextFormattedLine());
                }
                break;
            }
        }
        catch (NullPointerException var4_4) {
            this.summarize();
            while (this.hasMoreFormattedLines()) {
                var2_2.println(this.nextFormattedLine());
            }
            return;
        }
    }

    public boolean hasMoreFormattedLines() {
        if (this.lineBreaker.hasMoreBrokenLines()) {
            return true;
        }
        while (!this.isSummarized && !this.isNewLineRequested() || this.isSummarized && this.hasMoreSummarizedLines()) {
            String string = this.format(null);
            if (string == null) continue;
            this.lineBreaker.breakLine(string);
            return true;
        }
        return false;
    }

    public void formatLine(String string) {
        String string2 = this.format(string);
        if (string2 != null) {
            this.lineBreaker.breakLine(string2);
        }
    }

    public String nextFormattedLine() {
        return this.lineBreaker.nextBrokenLine();
    }

    public void summarize() {
        this.formatLine("");
        this.isSummarized = true;
    }

    public void setBracketBreak(boolean bl) {
        this.bracketBreak = bl;
    }

    public void setBracketIndent(boolean bl) {
        this.beautifier.setBracketIndent(bl);
    }

    public void setSwitchIndent(boolean bl) {
        this.beautifier.setSwitchIndent(bl);
    }

    public void setPreferredLineLength(int n) {
        this.lineBreaker.setPreferredLineLength(n);
    }

    public void setLineLengthDeviation(int n) {
        this.lineBreaker.setLineLengthDeviation(n);
    }

    public void setNestedConnection(boolean bl) {
        this.lineBreaker.setNestedConnection(bl);
    }

    private boolean isNewLineRequested() {
        return this.tempLine.indexOf("//") == -1 && this.tempLine.indexOf("/*") == -1 && this.tempLine.indexOf("*/") == -1;
    }

    private boolean hasMoreSummarizedLines() {
        return this.tempLine.length() != 0 && (this.tempLine.length() != 2 || this.tempLine.charAt(0) != '\r' || this.tempLine.charAt(1) != '\n');
    }

    public String format(String string) {
        int n;
        int n2;
        boolean bl = false;
        char c = ' ';
        char c2 = ' ';
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        this.currentHeader = null;
        if (string == null) {
            string = "";
        } else {
            if (!this.isInComment) {
                this.leadingWhiteSpaces = 0;
                while (this.leadingWhiteSpaces < string.length() && (string.charAt(this.leadingWhiteSpaces) == ' ' || string.charAt(this.leadingWhiteSpaces) == '\t')) {
                    ++this.leadingWhiteSpaces;
                }
                string = string.trim();
            } else {
                for (n2 = 0; n2 < string.length() && n2 < this.leadingWhiteSpaces && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t'); n2 += 1) {
                }
                string = string.substring(n2);
            }
            if ("".equals(string)) {
                string = "\n";
            }
        }
        string = this.tempLine + " \r" + string;
        for (n = 0; n < string.length(); ++n) {
            char c3;
            int n3;
            int n4;
            String string3;
            c2 = c;
            c = string.charAt(n);
            if (!this.isInComment && !bl && c == '\t') {
                c = ' ';
            }
            if (c == '\n') {
                bl3 = true;
                break;
            }
            if (c == '\r') {
                c = ' ';
                if (bl3) break;
                if (this.checkBlockClose) {
                    this.checkBlockClose = false;
                    bl3 = true;
                    break;
                }
                this.foundOrigLineBreak = true;
                continue;
            }
            if (!(c == ' ' || c == '\t' || this.isInComment || bl || this.isInQuote || string.regionMatches(false, n, "//", 0, 2) || string.regionMatches(false, n, "/*", 0, 2))) {
                this.prevNonSpaceCh = this.currentNonSpaceCh;
                this.currentNonSpaceCh = c;
            }
            if (!(this.isInComment || bl || this.isInQuote || c != ' ')) {
                if (this.currentNonSpaceCh == '(' || this.currentNonSpaceCh == ')' || this.currentNonSpaceCh == '[' || this.currentNonSpaceCh == ']') continue;
                this.appendSpace(this.outBuffer);
                continue;
            }
            bl2 = false;
            if (this.checkBlockClose) {
                this.checkBlockClose = false;
                if (c != '}') {
                    bl3 = true;
                }
            }
            if (!this.isInQuote && !this.isInComment && !bl && string.regionMatches(false, n, "//", 0, 2)) {
                if (this.foundOrigLineBreak) {
                    this.foundOrigLineBreak = false;
                    if (this.checkClosingHeader) {
                        this.checkClosingHeader = false;
                        --n;
                        bl3 = true;
                        break;
                    }
                }
                bl = true;
                this.checkClosingHeader = false;
                this.outBuffer.append("//");
                ++n;
                continue;
            }
            if (!this.isInQuote && !this.isInComment && !bl && string.regionMatches(false, n, "/*", 0, 2)) {
                if (this.foundOrigLineBreak) {
                    this.foundOrigLineBreak = false;
                    if (this.checkClosingHeader) {
                        this.checkClosingHeader = false;
                        --n;
                        bl3 = true;
                        break;
                    }
                }
                this.isInComment = true;
                this.outBuffer.append("/*");
                ++n;
                continue;
            }
            if (!this.isInQuote && (this.isInComment || bl) && string.regionMatches(false, n, "*/", 0, 2)) {
                this.isInComment = false;
                this.outBuffer.append("*/");
                bl2 = true;
                ++n;
                continue;
            }
            if (this.isInComment || bl) {
                this.outBuffer.append(c);
                if (!this.outBuffer.toString().regionMatches(false, 0, "/*", 0, 2)) continue;
                this.outBuffer.insert(0, ' ');
                continue;
            }
            if (this.isInHeader) {
                this.isInHeader = false;
                this.currentHeader = (String)this.openingStack.peek();
            } else {
                this.currentHeader = null;
            }
            this.foundOrigLineBreak = false;
            if (bl3) {
                --n;
                break;
            }
            if (this.checkClosingHeader) {
                this.checkClosingHeader = false;
                if (this.bracketBreak) {
                    if (c != ';') {
                        --n;
                        bl3 = true;
                        break;
                    }
                    --n;
                    continue;
                }
                while (!"{".equals(this.openingStack.pop())) {
                }
                if (!this.openingStack.isEmpty()) {
                    String string4 = (String)this.openingStack.peek();
                    string3 = (String)closingHeaders.get(string4);
                    if (string3 == null || !string.regionMatches(false, --n + 1, string3, 0, string3.length())) {
                        if (c != ';') {
                            string2 = this.outBuffer.toString();
                            this.outBuffer.setLength(0);
                            break;
                        }
                        ++n;
                    } else {
                        n4 = this.outBuffer.length() - 1;
                        if (n4 >= 0 && this.outBuffer.charAt(n4) != ' ') {
                            this.appendSpace(this.outBuffer);
                        }
                        c = ' ';
                        this.openingStack.pop();
                        continue;
                    }
                }
            }
            if (this.checkIf) {
                this.checkIf = false;
                if (string.regionMatches(false, n, "if", 0, 2)) {
                    this.isNewLineNeeded = false;
                }
            }
            if (!this.isParenNeeded && this.checkBlockOpen) {
                this.checkBlockOpen = false;
                if (c == '{' || "static".equals(this.currentHeader)) {
                    this.isNewLineNeeded = false;
                }
            }
            if (this.isNewLineNeeded && !this.isParenNeeded) {
                this.isNewLineNeeded = false;
                --n;
                bl3 = true;
                continue;
            }
            if (this.isSpecialChar) {
                this.outBuffer.append(c);
                this.isSpecialChar = false;
                continue;
            }
            if (!this.isInComment && !bl && string.regionMatches(false, n, "\\\\", 0, 2)) {
                this.outBuffer.append("\\\\");
                ++n;
                continue;
            }
            if (!this.isInComment && !bl && c == '\\') {
                this.isSpecialChar = true;
                this.outBuffer.append(c);
                continue;
            }
            if (c == '\"' || c == '\'') {
                if (!this.isInQuote) {
                    this.quoteChar = c;
                    this.isInQuote = true;
                } else if (this.quoteChar == c) {
                    this.isInQuote = false;
                    this.outBuffer.append(c);
                    continue;
                }
            }
            if (this.isInQuote) {
                this.outBuffer.append(c);
                continue;
            }
            if (c == '(' || c == '[' || c == ')' || c == ']') {
                if (c == '(' || c == '[') {
                    ++this.parenDepth;
                } else if (c == ')' || c == ']') {
                    --this.parenDepth;
                }
                if (this.parenDepth == 0 && this.isParenNeeded) {
                    this.isParenNeeded = false;
                    this.checkBlockOpen = true;
                }
            }
            if (c2 == ' ') {
                n2 = 0;
                block6: for (int i = 0; i < headers.length; ++i) {
                    if (!string.regionMatches(false, n, headers[i], 0, headers[i].length())) continue;
                    n4 = string.length();
                    n3 = n + headers[i].length();
                    c3 = '\u0000';
                    if (n3 < n4) {
                        c3 = string.charAt(n3);
                    }
                    if (n3 > n4 || c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9') break;
                    n2 = 1;
                    this.outBuffer.append(headers[i]);
                    n += headers[i].length() - 1;
                    if ("else".equals(headers[i])) {
                        this.checkIf = true;
                    }
                    this.checkBlockOpen = true;
                    this.isNewLineNeeded = true;
                    this.isBlockNeeded = false;
                    this.openingStack.push(headers[i]);
                    this.appendSpace(this.outBuffer);
                    c = ' ';
                    for (int j = 0; j < parenHeaders.length; ++j) {
                        if (!headers[i].equals(parenHeaders[j])) continue;
                        this.isParenNeeded = true;
                        break block6;
                    }
                    break;
                }
                if (n2) {
                    this.isInHeader = true;
                    continue;
                }
            }
            if (c == '?') {
                this.isInQuestion = true;
            }
            if (c == ':') {
                if (this.isInQuestion) {
                    this.isInQuestion = false;
                } else {
                    this.outBuffer.append(c);
                    bl3 = true;
                    continue;
                }
            }
            if (c == ';' && this.parenDepth == 0) {
                this.outBuffer.append(c);
                bl3 = true;
                continue;
            }
            if (c == '{') {
                if (!this.bracketBreak || !this.isInBracketOpen) {
                    n2 = 0;
                    n2 |= this.prevNonSpaceCh == '{' && (Boolean)this.bracketBlockStateStack.peek() != false ? 1 : 0;
                    n2 |= this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ';' ? 1 : 0;
                    n2 |= this.isInClassStatement;
                    int n5 = this.prevNonSpaceCh == ':' && !this.isInQuestion ? 1 : 0;
                    this.isInClassStatement = false;
                    if (!(n2 |= n5) && this.currentHeader != null) {
                        for (int i = 0; i < nonParenHeaders.length; ++i) {
                            if (!this.currentHeader.equals(nonParenHeaders[i])) continue;
                            n2 = 1;
                            break;
                        }
                    }
                    this.bracketBlockStateStack.push(new Boolean(n2 != 0));
                    if (!n2) {
                        this.outBuffer.append('{');
                        continue;
                    }
                }
                if (this.bracketBreak) {
                    if (this.isInBracketOpen) {
                        this.isInBracketOpen = false;
                    } else {
                        this.isInBracketOpen = true;
                        bl3 = true;
                        --n;
                        break;
                    }
                }
                this.checkBlockClose = true;
                n2 = this.outBuffer.length() - 1;
                if (n2 >= 0 && this.outBuffer.charAt(n2) != ' ') {
                    this.appendSpace(this.outBuffer);
                }
                this.outBuffer.append('{');
                this.openingStack.push("{");
                this.parenDepthsStack.push(new Integer(this.parenDepth));
                this.parenDepth = 0;
                continue;
            }
            if (c == '}') {
                if (!((Boolean)this.bracketBlockStateStack.pop()).booleanValue()) {
                    this.outBuffer.append(c);
                    continue;
                }
                if (!this.parenDepthsStack.isEmpty()) {
                    this.parenDepth = (Integer)this.parenDepthsStack.pop();
                }
                this.outBuffer.append(c);
                this.checkClosingHeader = true;
                continue;
            }
            if (c2 == ' ') {
                n2 = 0;
                for (int i = 0; i < statementHeaders.length; ++i) {
                    if (!string.regionMatches(false, n, statementHeaders[i], 0, statementHeaders[i].length())) continue;
                    n4 = string.length();
                    n3 = n + statementHeaders[i].length();
                    c3 = '\u0000';
                    if (n3 < n4) {
                        c3 = string.charAt(n3);
                    }
                    if (n3 > n4 || c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9') break;
                    this.isInClassStatement = true;
                    break;
                }
            }
            if (c2 == ' ' && string.regionMatches(false, n, "return", 0, 6)) {
                n2 = string.length();
                int n6 = n + 6;
                n4 = 0;
                if (n6 < n2) {
                    n4 = string.charAt(n6);
                }
                if (!(n6 > n2 || n4 >= 97 && n4 <= 122 || n4 >= 65 && n4 <= 90 || n4 >= 48 && n4 <= 57)) {
                    this.outBuffer.append("return");
                    n += 5;
                    this.currentNonSpaceCh = (char)45;
                    continue;
                }
            }
            if ((this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ']') && Character.isLetterOrDigit(c) && c != '.' && c != '_' && c != '$' && c != '(' && c != '[' && c != ')' && c != ']') {
                this.appendSpace(this.outBuffer);
            }
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '_' && c != '$' && c != '(' && c != '[' && c != ')' && c != ']' && (Character.isLetterOrDigit(this.prevNonSpaceCh) || this.prevNonSpaceCh == '.' || this.prevNonSpaceCh == '_' || this.prevNonSpaceCh == '$' || this.prevNonSpaceCh == ')' || this.prevNonSpaceCh == ']')) {
                n2 = 0;
                string3 = null;
                for (n4 = 0; n4 < longOperators.length; ++n4) {
                    if (!string.regionMatches(false, n, longOperators[n4], 0, longOperators[n4].length())) continue;
                    n2 = 1;
                    string3 = longOperators[n4];
                    break;
                }
                if (n2) {
                    if (!("--".equals(string3) || "++".equals(string3) || ".*".equals(string3))) {
                        this.appendSpace(this.outBuffer);
                        this.outBuffer.append(string3);
                        this.appendSpace(this.outBuffer);
                        c = ' ';
                    } else {
                        this.outBuffer.append(string3);
                        this.currentNonSpaceCh = (char)48;
                    }
                    ++n;
                    continue;
                }
                if (c != '*' || this.prevNonSpaceCh != '.') {
                    if (c != ',' && c != ';') {
                        this.appendSpace(this.outBuffer);
                    }
                    this.outBuffer.append(c);
                    this.appendSpace(this.outBuffer);
                    c = ' ';
                    continue;
                }
                this.outBuffer.append(c);
                continue;
            }
            if (c == ')' || c == ']') {
                this.clearPaddingSpace(this.outBuffer);
            }
            this.outBuffer.append(c);
        }
        try {
            this.tempLine = string.substring(n + (n < string.length() ? 1 : 0));
        }
        catch (Exception exception) {
            this.tempLine = "";
        }
        if (bl3 || this.isInComment || bl || bl2) {
            string2 = this.outBuffer.toString();
            this.outBuffer.setLength(0);
        }
        if (string2 != null && !"".equals(string2)) {
            string2 = this.beautifier.beautify(string2);
        } else if (c != '[' && c != ']' && c != '(' && c != ')' && c != '.' && c != '_' && c != '$') {
            this.appendSpace(this.outBuffer);
        }
        return string2;
    }

    private void appendSpace(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0 || stringBuffer.charAt(stringBuffer.length() - 1) != ' ') {
            stringBuffer.append(' ');
        }
    }

    private void clearPaddingSpace(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n != 0 && stringBuffer.charAt(n - 1) == ' ') {
            stringBuffer.setLength(n - 1);
        }
    }

    static {
        closingHeaders.put("if", "else");
        closingHeaders.put("do", "while");
        closingHeaders.put("try", "catch");
    }
}

