/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class SocketToPipe
implements PipeMsgListener,
Runnable {
    public static String CMD_NAMESPACE = "jxta";
    public static String CMD_TAG = "JxtaSocketToProxyCmd";
    public static String CONNECTED = "Connected";
    public static String CLOSED = "Closed";
    public static String BEAT = "Beat";
    private static long DEFAULT_TIMEOUT = 300000L;
    private static long DEFAULT_GRACE = 600000L;
    private String tagNameSpace = null;
    private String tagName = null;
    private MimeMediaType mediaType = null;
    private Socket socket = null;
    private InputStream ip = null;
    private OutputStream op = null;
    private Thread worker = null;
    private InputPipe dataIn = null;
    private OutputPipe dataOut = null;
    private PipeAdvertisement dataOutPipeAdv = null;
    private PeerAdvertisement peerAdv = null;
    private PeerGroup group = null;
    private boolean closed = false;
    private SocketToPipeListener listener = null;
    private long lastReceivedBeat = 0L;
    private long lastSentBeat = 0L;
    private long sentBeatPeriod = 0L;
    private long receivedBeatPeriod = 0L;
    private WatchDogTask task = null;
    private Timer timer = null;
    private boolean isTimerPrivate = false;

    public SocketToPipe(Socket socket) {
        this.socket = socket;
    }

    public SocketToPipe(InetAddress serverAddr, int port) throws IOException {
        this.socket = new Socket(serverAddr, port);
    }

    public void connect(PeerGroup group, PipeAdvertisement dataOutPipeAdv, PipeAdvertisement dataInPipeAdv, PeerAdvertisement peerAdv, SocketToPipeListener listener, String tagNameSpace, String tagName, MimeMediaType mediaType, Timer timer, long timerPeriod, long sentBeatPeriod, long receivedBeatPeriod) throws IOException {
        this.group = group;
        this.dataOutPipeAdv = dataOutPipeAdv;
        this.peerAdv = peerAdv;
        this.dataIn = group.getPipeService().createInputPipe(dataInPipeAdv, this);
        this.op = this.socket.getOutputStream();
        this.ip = this.socket.getInputStream();
        this.listener = listener;
        this.tagNameSpace = tagNameSpace;
        this.tagName = tagName;
        this.mediaType = mediaType;
        this.startWorkerThread();
        this.timer = timer;
        this.sentBeatPeriod = sentBeatPeriod;
        this.receivedBeatPeriod = receivedBeatPeriod;
        if (sentBeatPeriod > 0L || receivedBeatPeriod > 0L) {
            if (timer == null) {
                this.timer = new Timer();
                this.isTimerPrivate = true;
            }
            this.task = new WatchDogTask(this);
            try {
                timer.schedule((TimerTask)this.task, timerPeriod);
            }
            catch (Exception ez) {
                this.sendClosedMsg();
                this.close();
                throw new IOException("Cannot create timer " + ez);
            }
        }
    }

    public void connect(PeerGroup group, PipeAdvertisement dataOutPipeAdv, PipeAdvertisement dataInPipeAdv, PeerAdvertisement peerAdv, SocketToPipeListener listener, String tagNameSpace, String tagName, MimeMediaType mediaType) throws IOException {
        this.connect(group, dataOutPipeAdv, dataInPipeAdv, peerAdv, listener, tagNameSpace, tagName, mediaType, null, 0L, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SocketToPipe socketToPipe = this;
        synchronized (socketToPipe) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception ez1) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.dataIn != null) {
            this.dataIn.close();
            this.dataIn = null;
        }
        if (this.dataOut != null) {
            this.dataOut.close();
            this.dataOut = null;
        }
        if (this.listener != null) {
            try {
                this.listener.closed(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.timer != null) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            if (this.isTimerPrivate) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    public synchronized long getLastReceivedBeat() {
        return this.lastReceivedBeat;
    }

    public synchronized long getLastSentBeat() {
        return this.lastSentBeat;
    }

    public void beat() {
        this.sendBeatMsg();
    }

    private void setDataOut() throws IOException {
        if (this.dataOut != null) {
            return;
        }
        PipeService pipeService = this.group.getPipeService();
        this.dataOut = this.peerAdv != null ? pipeService.createOutputPipe(this.dataOutPipeAdv, this.peerAdv.getPeerID(), DEFAULT_TIMEOUT) : pipeService.createOutputPipe(this.dataOutPipeAdv, DEFAULT_TIMEOUT);
    }

    private void sendConnectedMsg() {
        Message msg = new Message();
        if (this.dataOut == null) {
            return;
        }
        msg.addMessageElement(CMD_NAMESPACE, new StringMessageElement(CMD_TAG, CONNECTED, null));
        try {
            this.setDataOut();
            this.dataOut.send(msg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendClosedMsg() {
        if (this.dataOut == null) {
            return;
        }
        Message msg = new Message();
        msg.addMessageElement(CMD_NAMESPACE, new StringMessageElement(CMD_TAG, CLOSED, null));
        try {
            this.setDataOut();
            this.dataOut.send(msg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendBeatMsg() {
        if (this.dataOut == null) {
            return;
        }
        Message msg = new Message();
        msg.addMessageElement(CMD_NAMESPACE, new StringMessageElement(CMD_TAG, BEAT, null));
        try {
            this.setDataOut();
            this.dataOut.send(msg);
            this.updateSentBeat();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processConnected() {
        if (this.listener != null) {
            try {
                this.listener.connected(this);
            }
            catch (Throwable ez1) {
                throw new RuntimeException("SocketToPipe failed calling listener.connected\n   " + ez1);
            }
        }
    }

    private void processClosed() {
        this.close();
    }

    private synchronized void updateReceivedBeat() {
        this.lastReceivedBeat = System.currentTimeMillis();
    }

    private synchronized void updateSentBeat() {
        this.lastSentBeat = System.currentTimeMillis();
    }

    private void startWorkerThread() {
        this.worker = new Thread((Runnable)this, "SocketToPipe worker thread");
        this.worker.start();
    }

    private void processIncomingData(byte[] buffer) {
        try {
            ByteArrayMessageElement el = new ByteArrayMessageElement(this.tagName, this.mediaType, buffer, null);
            Message msg = new Message();
            msg.addMessageElement(this.tagNameSpace, el);
            this.setDataOut();
            this.dataOut.send(msg);
            this.updateSentBeat();
        }
        catch (Exception ez1) {
            this.close();
        }
    }

    private void processOutgoingData(Message msg) throws IOException {
        MessageElement el = msg.getMessageElement(CMD_NAMESPACE, CMD_TAG);
        if (el != null) {
            String cmd = el.toString();
            if (cmd.equals(CONNECTED)) {
                this.processConnected();
            } else {
                if (cmd.equals(CLOSED)) {
                    this.processClosed();
                    return;
                }
                if (cmd.equals(BEAT)) {
                    this.updateReceivedBeat();
                }
            }
        } else {
            this.updateReceivedBeat();
        }
        el = msg.getMessageElement(this.tagNameSpace, this.tagName);
        if (el != null) {
            byte[] buffer = el.getBytes(true);
            if (this.op == null) {
                this.op = this.socket.getOutputStream();
                this.startWorkerThread();
            }
            this.op.write(buffer);
            this.op.flush();
        }
    }

    public void run() {
        if (this.ip == null) {
            try {
                this.ip = this.socket.getInputStream();
                this.sendConnectedMsg();
            }
            catch (IOException ez1) {
                this.sendClosedMsg();
                this.close();
                return;
            }
        }
        try {
            while (true) {
                byte[] tmp = new byte[1];
                int res = this.ip.read(tmp);
                if (this.closed) {
                    return;
                }
                if (res <= 0) {
                    this.sendClosedMsg();
                    this.close();
                    return;
                }
                byte[] buffer = null;
                int avail = this.ip.available();
                if (avail > 0) {
                    buffer = new byte[avail + 1];
                    buffer[0] = tmp[0];
                    res = this.ip.read(buffer, 1, avail);
                    if (res > 0) {
                        this.processIncomingData(buffer);
                        continue;
                    }
                    this.sendClosedMsg();
                    this.close();
                    return;
                }
                this.processIncomingData(tmp);
            }
        }
        catch (Exception ez1) {
            if (this.closed) {
                return;
            }
            this.sendClosedMsg();
            this.close();
            return;
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message msg = null;
        try {
            msg = event.getMessage();
            if (msg != null) {
                this.processOutgoingData(msg);
            }
        }
        catch (Exception e) {
            this.sendClosedMsg();
            this.close();
        }
    }

    private class WatchDogTask
    extends TimerTask {
        private SocketToPipe sp = null;

        public WatchDogTask(SocketToPipe sp) {
            this.sp = sp;
        }

        public void run() {
            long lastReceived = this.sp.getLastReceivedBeat();
            long lastSent = this.sp.getLastSentBeat();
            long currentTime = System.currentTimeMillis();
            if (SocketToPipe.this.receivedBeatPeriod > 0L && currentTime - lastReceived > SocketToPipe.this.receivedBeatPeriod + DEFAULT_GRACE) {
                this.sp.close();
                return;
            }
            if (SocketToPipe.this.sentBeatPeriod > 0L && currentTime - lastSent > SocketToPipe.this.sentBeatPeriod) {
                this.sp.sendBeatMsg();
                return;
            }
        }
    }

    public static interface SocketToPipeListener {
        public void closed(SocketToPipe var1);

        public void connected(SocketToPipe var1);
    }
}

