/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import net.jxta.util.WatchedStream;

public class WatchedInputStream
extends FilterInputStream
implements WatchedStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    Collection watchList = null;
    volatile boolean stalled = false;
    volatile boolean idle = true;
    boolean closed = false;
    final int chunkSize;
    InputStream in = null;

    public WatchedInputStream(InputStream in, int chunkSize) {
        super(in);
        this.in = in;
        this.chunkSize = chunkSize;
    }

    public WatchedInputStream(InputStream in) {
        this(in, 4096);
    }

    public String toString() {
        if (null == this.in) {
            return "closed/" + super.toString();
        }
        if (this.in instanceof ByteArrayInputStream) {
            return this.in.getClass().getName() + "@" + System.identityHashCode(this.in) + "/" + super.toString();
        }
        return this.in.toString() + "/" + super.toString();
    }

    public synchronized void setWatchList(Collection watchList) {
        if (this.watchList != null) {
            this.watchList.remove(this);
        }
        this.watchList = watchList;
        watchList.add(this);
    }

    public void watch() {
        if (this.idle) {
            return;
        }
        if (!this.stalled) {
            this.stalled = true;
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.idle = true;
        WatchedInputStream watchedInputStream = this;
        synchronized (watchedInputStream) {
            if (this.watchList != null) {
                this.watchList.remove(this);
                this.watchList = null;
            }
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        this.stalled = false;
        this.idle = false;
        try {
            int n = this.in.read();
            return n;
        }
        finally {
            this.idle = true;
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.stalled = false;
        this.idle = false;
        try {
            int left;
            int i = 0;
            for (left = len; left > this.chunkSize; left -= i) {
                i = this.in.read(b, off, this.chunkSize);
                this.stalled = false;
                if (i <= 0) {
                    if (left == len) {
                        int n = i;
                        return n;
                    }
                    int n = len - left;
                    return n;
                }
                off += i;
                if (this.in.available() != 0) continue;
                int n = len - left;
                return n;
            }
            i = this.in.read(b, off, left);
            if (i <= 0) {
                if (left == len) {
                    int n = i;
                    return n;
                }
                int n = len - left;
                return n;
            }
            int n = len - left + i;
            return n;
        }
        finally {
            this.idle = true;
        }
    }
}

