/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class IoUtilities {
    private static final int BLOCK_SIZE = 2048;

    private IoUtilities() {
    }

    public static byte[] streamToBytes(InputStream in) throws IOException {
        int nRead;
        byte[] buf = new byte[2048];
        int size = 0;
        while ((nRead = in.read(buf, size, 2048)) >= 0) {
            if ((size += nRead) + 2048 <= buf.length) continue;
            byte[] temp = new byte[2 * buf.length];
            System.arraycopy(buf, 0, temp, 0, buf.length);
            buf = temp;
        }
        in.close();
        if (size == buf.length) {
            return buf;
        }
        byte[] answer = new byte[size];
        System.arraycopy(buf, 0, answer, 0, size);
        return answer;
    }

    public static byte[] streamToBytes(InputStream in, int length) throws IOException {
        byte[] buf = new byte[length];
        int pos = 0;
        while (length > 0) {
            int n = in.read(buf, pos, length);
            pos += n;
            length -= n;
        }
        return buf;
    }

    public static InputStream bytesToStream(byte[] buf) {
        return new ByteArrayInputStream(buf);
    }
}

