/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.exception.JxtaException;

public final class DocumentUtilities {
    private DocumentUtilities() {
    }

    public static StructuredTextDocument createStructuredXmlDocument(String rootTagName) throws JxtaException {
        return (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, rootTagName);
    }

    public static StructuredTextDocument getStructuredXmlDocument(String buf) throws JxtaException {
        try {
            return (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(buf));
        }
        catch (IOException e) {
            throw new JxtaException("Error reading document", e);
        }
    }

    public static StructuredTextDocument getStructuredXmlDocument(byte[] buf) throws JxtaException {
        return DocumentUtilities.getStructuredXmlDocument(new ByteArrayInputStream(buf));
    }

    public static StructuredTextDocument getStructuredXmlDocument(InputStream in) throws JxtaException {
        try {
            return (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, in);
        }
        catch (IOException e) {
            throw new JxtaException("Error reading document", e);
        }
    }

    public static StructuredDocument createParamDocument() {
        return StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
    }

    public static Element getChild(Element root, Object key) {
        Enumeration e = root.getChildren(key);
        if (e == null) {
            return null;
        }
        return (Element)e.nextElement();
    }
}

