/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.protocol.PeerAdvertisement;

public abstract class DiscoveryResponseMsg {
    protected String attr = null;
    protected PeerAdvertisement peerAdvertisement = null;
    protected List responses = Collections.EMPTY_LIST;
    protected List advertisements = null;
    protected List expirations = Collections.EMPTY_LIST;
    protected int type = 0;
    protected String value = null;

    public static String getAdvertisementType() {
        return "jxta:DiscoveryResponse";
    }

    public abstract Enumeration getAdvertisements();

    public int getDiscoveryType() {
        return this.type;
    }

    public void setDiscoveryType(int type) {
        this.type = type;
    }

    public abstract Document getDocument(MimeMediaType var1);

    public String getPeerAdv() {
        if (null != this.peerAdvertisement) {
            return this.peerAdvertisement.toString();
        }
        return null;
    }

    public void setPeerAdv(String newAdv) {
        try {
            this.peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new StringReader(newAdv));
        }
        catch (IOException failed) {
            throw new IllegalArgumentException("Bad Peer Avertisement");
        }
    }

    public PeerAdvertisement getPeerAdvertisement() {
        return this.peerAdvertisement;
    }

    public void setPeerAdvertisement(PeerAdvertisement newAdv) {
        this.peerAdvertisement = newAdv;
    }

    public String getQueryAttr() {
        return this.attr;
    }

    public String getQueryValue() {
        return this.value;
    }

    public int getResponseCount() {
        if (0 == this.responses.size() && this.peerAdvertisement != null && this.type == 0) {
            return 1;
        }
        return this.responses.size();
    }

    public void setResponseCount(int count) {
    }

    public Enumeration getExpirations() {
        if (0 == this.expirations.size() && this.peerAdvertisement != null && this.type == 0) {
            this.expirations = Collections.singletonList(new Long(0x6DDD00L));
        }
        return Collections.enumeration(this.expirations);
    }

    public void setExpirations(Vector expirations) {
        this.expirations = new ArrayList(expirations);
    }

    public Enumeration getResponses() {
        if (0 == this.responses.size() && this.peerAdvertisement != null && this.type == 0) {
            this.responses = Collections.singletonList(this.peerAdvertisement.toString());
        }
        return Collections.enumeration(this.responses);
    }

    public void setResponses(Vector responses) {
        this.responses = new ArrayList(responses);
    }

    public void setQueryAttr(String attr) {
        this.attr = attr;
    }

    public void setQueryValue(String value) {
        this.value = value;
    }
}

