/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jxta.access.AccessService;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;

public interface PeerGroup
extends Service {
    public static final int Here = 0;
    public static final int FromParent = 1;
    public static final int Both = 2;
    public static final long DEFAULT_LIFETIME = 31536000000L;
    public static final long DEFAULT_EXPIRATION = 1209600000L;
    public static final String WK_ID_PREFIX = "urn:jxta:uuid-DeadBeefDeafBabaFeedBabe";
    public static final ModuleClassID peerGroupClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000105"));
    public static final ModuleClassID resolverClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000205"));
    public static final ModuleClassID discoveryClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000305"));
    public static final ModuleClassID pipeClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000405"));
    public static final ModuleClassID membershipClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000505"));
    public static final ModuleClassID rendezvousClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000605"));
    public static final ModuleClassID peerinfoClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000705"));
    public static final ModuleClassID endpointClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000805"));
    public static final ModuleClassID tcpProtoClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000905"));
    public static final ModuleClassID httpProtoClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000A05"));
    public static final ModuleClassID routerProtoClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000B05"));
    public static final ModuleClassID applicationClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000C05"));
    public static final ModuleClassID tlsProtoClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000D05"));
    public static final ModuleClassID proxyClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000E05"));
    public static final ModuleClassID relayProtoClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000F05"));
    public static final ModuleClassID accessClassID = (ModuleClassID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000001005"));
    public static final ModuleSpecID refPlatformSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000010106"));
    public static final ModuleSpecID refNetPeerGroupSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000010206"));
    public static final ModuleSpecID refResolverSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000020106"));
    public static final ModuleSpecID refDiscoverySpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000030106"));
    public static final ModuleSpecID refPipeSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000040106"));
    public static final ModuleSpecID refMembershipSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000050106"));
    public static final ModuleSpecID refRendezvousSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000060106"));
    public static final ModuleSpecID refPeerinfoSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000070106"));
    public static final ModuleSpecID refEndpointSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000080106"));
    public static final ModuleSpecID refTcpProtoSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000090106"));
    public static final ModuleSpecID refHttpProtoSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000A0106"));
    public static final ModuleSpecID refRouterProtoSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000B0106"));
    public static final ModuleSpecID refTlsProtoSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000D0106"));
    public static final ModuleSpecID allPurposePeerGroupSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000010306"));
    public static final ModuleSpecID refStartNetPeerGroupSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000C0106"));
    public static final ModuleSpecID refShellSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000C0206"));
    public static final ModuleSpecID refProxySpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000E0106"));
    public static final ModuleSpecID refRelayProtoSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe0000000F0106"));
    public static final ModuleSpecID refAccessSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000100106"));
    public static final GlobalRegistry globalRegistry = new GlobalRegistry();

    public ThreadGroup getHomeThreadGroup();

    public JxtaLoader getLoader();

    public boolean isRendezvous();

    public PeerGroupAdvertisement getPeerGroupAdvertisement();

    public PeerAdvertisement getPeerAdvertisement();

    public Service lookupService(ID var1) throws ServiceNotFoundException;

    public Service lookupService(ID var1, int var2) throws ServiceNotFoundException;

    public Iterator getRoleMap(ID var1);

    public boolean compatible(Element var1);

    public Module loadModule(ID var1, Advertisement var2) throws ProtocolNotSupportedException, PeerGroupException;

    public Module loadModule(ID var1, ModuleSpecID var2, int var3);

    public void publishGroup(String var1, String var2) throws IOException;

    public PeerGroup newGroup(Advertisement var1) throws PeerGroupException;

    public PeerGroup newGroup(PeerGroupID var1, Advertisement var2, String var3, String var4) throws PeerGroupException;

    public PeerGroup newGroup(PeerGroupID var1) throws PeerGroupException;

    public RendezVousService getRendezVousService();

    public EndpointService getEndpointService();

    public ResolverService getResolverService();

    public DiscoveryService getDiscoveryService();

    public PeerInfoService getPeerInfoService();

    public MembershipService getMembershipService();

    public PipeService getPipeService();

    public AccessService getAccessService();

    public PeerGroupID getPeerGroupID();

    public PeerID getPeerID();

    public String getPeerGroupName();

    public String getPeerName();

    public ConfigParams getConfigAdvertisement();

    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception;

    public void unref();

    public PeerGroup getWeakInterface();

    public PeerGroup getParentGroup();

    public static class GlobalRegistry {
        private Map registry = new HashMap(8);

        public synchronized boolean registerInstance(PeerGroupID gid, PeerGroup pg) {
            WeakReference ref = (WeakReference)this.registry.get(gid);
            if (ref != null && ref.get() != null) {
                return false;
            }
            this.registry.put(gid, new WeakReference<PeerGroup>(pg));
            return true;
        }

        public synchronized boolean unRegisterInstance(PeerGroupID gid, PeerGroup pg) {
            WeakReference ref = (WeakReference)this.registry.get(gid);
            if (ref == null) {
                return false;
            }
            PeerGroup found = (PeerGroup)ref.get();
            if (found == null) {
                this.registry.remove(gid);
                return false;
            }
            if (pg != found) {
                return false;
            }
            this.registry.remove(gid);
            return true;
        }

        public synchronized PeerGroup lookupInstance(PeerGroupID gid) {
            WeakReference ref = (WeakReference)this.registry.get(gid);
            if (ref == null) {
                return null;
            }
            PeerGroup pg = (PeerGroup)ref.get();
            if (pg == null) {
                this.registry.remove(gid);
                return null;
            }
            return (PeerGroup)pg.getInterface();
        }
    }
}

