/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xindice.core.indexer;

import java.io.File;
import java.io.IOException;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.filer.BTree;
import net.jxta.impl.xindice.core.filer.BTreeCorruptException;
import net.jxta.impl.xindice.core.filer.Paged;
import net.jxta.impl.xindice.core.indexer.Indexer;

public final class NameIndexer
extends BTree
implements Indexer {
    private static final short PAGESIZE = 4096;
    private static final short MAXKEYSIZE = 256;
    private Paged.FileHeader fileHeader = this.getFileHeader();

    public NameIndexer() {
        this.fileHeader.setPageSize(4096);
        this.fileHeader.setMaxKeySize((short)256);
    }

    public void setLocation(String dir, String file) {
        this.setFile(new File(dir, file + ".idx"));
    }

    public synchronized void remove(Key key) throws DBException {
        try {
            this.removeValue(key);
        }
        catch (IOException e) {
            throw new BTreeCorruptException("Corruption detected on remove");
        }
    }

    public synchronized void add(Key key, long pos) throws DBException {
        try {
            this.addValue(key, pos);
            this.flush();
        }
        catch (IOException e) {
            throw new BTreeCorruptException("Corruption detected on add");
        }
    }

    public synchronized void flush() throws DBException {
        super.flush();
    }
}

