/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

public final class TimeUtils {
    public static final long ZEROMILLISECONDS = 0L;
    public static final long AMILLISECOND = 1L;
    public static final long AHUNDREDTHOFASECOND = 10L;
    public static final long ATENTHOFASECOND = 100L;
    public static final long ASECOND = 1000L;
    public static final long AMINUTE = 60000L;
    public static final long ANHOUR = 3600000L;
    public static final long ADAY = 86400000L;
    public static final long AWEEK = 604800000L;
    public static final long AFORTNIGHT = 1209600000L;
    public static final long AJANUARY = 2678400000L;
    public static final long AFEBRUARY = 2419200000L;
    public static final long ALEAPFEBRUARY = 2505600000L;
    public static final long AMARCH = 2678400000L;
    public static final long ANAPRIL = 2592000000L;
    public static final long AMAY = 2678400000L;
    public static final long AJUNE = 2592000000L;
    public static final long AJULY = 2678400000L;
    public static final long ANAUGUST = 2678400000L;
    public static final long ASEPTEMBER = 2592000000L;
    public static final long ANOCTOBER = 2678400000L;
    public static final long ANOVEMBER = 2592000000L;
    public static final long ADECEMBER = 2678400000L;
    public static final long AYEAR = 31536000000L;
    public static final long ALEAPYEAR = 31622400000L;
    static volatile long TIMEWARP = 0L;
    static long WARPBEGAN = 0L;
    static double WARPFACTOR = 1.0;

    private TimeUtils() {
    }

    public static final long timeNow() {
        long now = System.currentTimeMillis();
        if (WARPFACTOR != 1.0) {
            long elapsed = now - WARPBEGAN;
            long dialation = (long)((double)elapsed * WARPFACTOR);
            TIMEWARP += dialation - elapsed;
        }
        return now + TIMEWARP;
    }

    public static final long toAbsoluteTimeMillis(long duration) {
        return TimeUtils.toAbsoluteTimeMillis(duration, TimeUtils.timeNow());
    }

    public static final long toAbsoluteTimeMillis(long duration, long fromWhen) {
        if (Long.MAX_VALUE == duration) {
            return Long.MAX_VALUE;
        }
        if (Long.MIN_VALUE == duration) {
            return Long.MIN_VALUE;
        }
        long whence = fromWhen + duration;
        if (duration > 0L) {
            if (whence < fromWhen) {
                whence = Long.MAX_VALUE;
            }
        } else if (whence > fromWhen) {
            whence = Long.MIN_VALUE;
        }
        return whence;
    }

    public static final long toRelativeTimeMillis(long whence) {
        return TimeUtils.toRelativeTimeMillis(whence, TimeUtils.timeNow());
    }

    public static final long toRelativeTimeMillis(long whence, long fromWhen) {
        if (Long.MAX_VALUE == whence) {
            return Long.MAX_VALUE;
        }
        if (Long.MIN_VALUE == whence) {
            return Long.MIN_VALUE;
        }
        return whence - fromWhen;
    }

    public static final void timeWarp(long advanceby) {
        if (0L != WARPBEGAN) {
            throw new IllegalStateException("auto time warping already initialized at warp factor " + WARPFACTOR);
        }
        TIMEWARP += advanceby;
    }

    public static final void autoWarp(double warpfactor) {
        if (0L != WARPBEGAN) {
            throw new IllegalStateException("auto time warping already initialized at warp factor " + WARPFACTOR);
        }
        if (warpfactor <= 0.0) {
            throw new IllegalArgumentException("Time should not stand still or run backwards, its unnatural.");
        }
        if (warpfactor != 1.0) {
            WARPFACTOR = warpfactor;
            WARPBEGAN = System.currentTimeMillis();
        }
    }

    public static final long warpedRelativeTime(long initial) {
        if (0L == initial) {
            return 0L;
        }
        long adjusted = (long)((double)initial * WARPFACTOR);
        return 0L != adjusted ? adjusted : 1L;
    }
}

