/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.impl.util.Dlink;
import net.jxta.impl.util.Dlist;
import net.jxta.impl.util.ResourceAccount;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ResourceDispatcher {
    private static final Logger LOG = Logger.getLogger((String)ResourceDispatcher.class.getName());
    private long extraItems;
    private long reservedItems;
    private long maxReservedPerAccount;
    private long minReservedPerAccount;
    private long maxExtraPerAccount;
    private long minExtraPoolSize;
    private int nbEligibles;
    private String myName = null;
    private Dlist eligibles;

    public ResourceDispatcher(long minAccounts, long minReservedPerAccount, long maxReservedPerAccount, long extraItems, long maxExtraPerAccount, long minExtraPoolSize, boolean roundRobin, String dispatcherName) {
        if (minAccounts < 0L) {
            minAccounts = 0L;
        }
        if (minReservedPerAccount < 0L) {
            minReservedPerAccount = 0L;
        }
        if (maxReservedPerAccount < minReservedPerAccount) {
            maxReservedPerAccount = minReservedPerAccount;
        }
        if (extraItems < 0L) {
            extraItems = 0L;
        }
        if (minExtraPoolSize < 0L) {
            minExtraPoolSize = 0L;
        }
        if (maxExtraPerAccount < 0L || maxExtraPerAccount > extraItems) {
            maxExtraPerAccount = extraItems;
        }
        this.extraItems = extraItems;
        this.minExtraPoolSize = minExtraPoolSize;
        this.maxReservedPerAccount = maxReservedPerAccount;
        this.minReservedPerAccount = minReservedPerAccount;
        this.reservedItems = minAccounts * minReservedPerAccount;
        this.maxExtraPerAccount = maxExtraPerAccount;
        this.nbEligibles = 0;
        if (roundRobin) {
            this.eligibles = new Dlist();
        }
        this.myName = dispatcherName;
    }

    private long holdReserved(long req) {
        if (req > this.reservedItems) {
            req = this.reservedItems;
        }
        this.reservedItems -= req;
        return req;
    }

    private void releaseReserved(long nb) {
        this.reservedItems += nb;
    }

    private long holdExtra(long req) {
        if (req > this.extraItems) {
            req = this.extraItems;
        }
        this.extraItems -= req;
        return req;
    }

    private long holdExtraKeepSome(long req) {
        if (this.extraItems <= this.minExtraPoolSize) {
            return 0L;
        }
        long allowed = this.extraItems - this.minExtraPoolSize;
        if (req > allowed) {
            req = allowed;
        }
        this.extraItems -= req;
        return req;
    }

    private void releaseExtra(long nb) {
        this.extraItems += nb;
    }

    private void newEligible(ClientAccount account) {
        ++this.nbEligibles;
        this.eligibles.putLast(account);
    }

    private ClientAccount mostEligible() {
        if (this.nbEligibles == 0) {
            return null;
        }
        return (ClientAccount)this.eligibles.getFirst();
    }

    private void unEligible(ClientAccount account) {
        --this.nbEligibles;
        account.unlink();
    }

    public int getNbEligibles() {
        return this.nbEligibles;
    }

    public ResourceAccount newAccount(long nbReq, long maxExtra, Object userObject) {
        long extra = 0L;
        long reserved = 0L;
        if (nbReq > this.maxReservedPerAccount) {
            nbReq = this.maxReservedPerAccount;
        }
        if (nbReq > this.minReservedPerAccount) {
            extra = this.holdExtraKeepSome(nbReq - this.minReservedPerAccount);
            nbReq = this.minReservedPerAccount;
        }
        if ((nbReq -= (reserved = this.holdReserved(nbReq))) > 0L) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Accepting extra account on a best effort basis.");
            }
            if ((extra += this.holdExtraKeepSome(nbReq)) + reserved < this.minReservedPerAccount && LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("[" + this.myName + "] Accepting extra account with below-minimal commitement:[" + userObject + "]"));
            }
        }
        if (maxExtra > this.maxExtraPerAccount || maxExtra < 0L) {
            maxExtra = this.maxExtraPerAccount;
        }
        return new ClientAccount(reserved, extra, maxExtra, userObject);
    }

    class ClientAccount
    extends Dlink
    implements ResourceAccount {
        private boolean needs;
        private long nbReserved;
        private long fromReservedItems;
        private long fromExtraItems;
        private long extraLimit;
        private Object userObject;

        ClientAccount(long fromReservedItems, long fromExtraItems, long extraLimit, Object userObject) {
            this.nbReserved = fromReservedItems + fromExtraItems;
            this.fromReservedItems = fromReservedItems;
            this.fromExtraItems = fromExtraItems;
            this.extraLimit = -extraLimit;
            this.userObject = userObject;
            this.needs = false;
        }

        public void close() {
            this.notEligible();
            this.userObject = null;
            if (this.nbReserved == 0L && this.fromReservedItems == 0L && this.fromExtraItems == 0L) {
                return;
            }
            if (this.nbReserved < this.fromReservedItems + this.fromExtraItems) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"An account was abandonned with resources still allocated.");
                }
                if (this.nbReserved >= this.fromReservedItems) {
                    ResourceDispatcher.this.releaseExtra(this.nbReserved - this.fromReservedItems);
                    ResourceDispatcher.this.releaseReserved(this.fromReservedItems);
                } else if (this.nbReserved > 0L) {
                    ResourceDispatcher.this.releaseReserved(this.nbReserved);
                }
            } else {
                ResourceDispatcher.this.releaseReserved(this.fromReservedItems);
                ResourceDispatcher.this.releaseExtra(this.fromExtraItems);
            }
            this.fromExtraItems = 0L;
            this.fromReservedItems = 0L;
            this.nbReserved = 0L;
        }

        public void finalize() {
            this.close();
        }

        public boolean isIdle() {
            return this.nbReserved == this.fromExtraItems + this.fromReservedItems;
        }

        public boolean isEligible() {
            return this.isLinked();
        }

        public void beEligible() {
            if (ResourceDispatcher.this.eligibles != null && !this.isEligible()) {
                ResourceDispatcher.this.newEligible(this);
            }
        }

        public void notEligible() {
            if (ResourceDispatcher.this.eligibles != null && this.isEligible()) {
                ResourceDispatcher.this.unEligible(this);
            }
        }

        private void granted() {
            if (LOG.isEnabledFor((Priority)Level.WARN) && this.nbReserved <= this.extraLimit) {
                LOG.warn((Object)"An account that should not get an item was found in the eligibles list");
            }
            --this.nbReserved;
            this.notEligible();
        }

        public boolean obtainQuantity(long quantity) {
            long toAsk;
            long res;
            if (this.nbReserved - quantity < this.extraLimit) {
                return false;
            }
            if (quantity > this.nbReserved && (res = ResourceDispatcher.this.holdExtra(toAsk = this.nbReserved > 0L ? quantity - this.nbReserved : quantity)) != toAsk) {
                ResourceDispatcher.this.releaseExtra(res);
                return false;
            }
            this.nbReserved -= quantity;
            if (LOG.isEnabledFor((Priority)Level.ERROR) && this.nbReserved > this.fromReservedItems + this.fromExtraItems) {
                LOG.error((Object)("Incorrect values after obtaining " + quantity + " : [" + this.toString() + "]"));
            }
            return true;
        }

        public boolean obtainItem() {
            this.needs = true;
            if (this.nbReserved > 0L) {
                this.notEligible();
                --this.nbReserved;
                return true;
            }
            if (this.nbReserved <= this.extraLimit) {
                this.notEligible();
                return false;
            }
            if (ResourceDispatcher.this.holdExtra(1L) == 1L) {
                this.notEligible();
                --this.nbReserved;
                return true;
            }
            this.beEligible();
            return false;
        }

        public void releaseQuantity(long quantity) {
            if (this.nbReserved < 0L) {
                ResourceDispatcher.this.releaseExtra(quantity < -this.nbReserved ? quantity : -this.nbReserved);
            }
            this.nbReserved += quantity;
            if (LOG.isEnabledFor((Priority)Level.ERROR) && this.nbReserved > this.fromReservedItems + this.fromExtraItems) {
                LOG.error((Object)("Incorrect values after releasing " + quantity + " : [" + this.toString() + "]"));
            }
        }

        public ResourceAccount releaseItem() {
            if (this.nbReserved < 0L) {
                ClientAccount next;
                if (ResourceDispatcher.this.eligibles == null) {
                    if (this.needs) {
                        return this;
                    }
                    ++this.nbReserved;
                    ResourceDispatcher.this.releaseExtra(1L);
                    return null;
                }
                ++this.nbReserved;
                if (this.nbReserved > this.extraLimit && this.needs) {
                    this.beEligible();
                }
                if ((next = ResourceDispatcher.this.mostEligible()) == null) {
                    ResourceDispatcher.this.releaseExtra(1L);
                } else {
                    next.granted();
                }
                return next;
            }
            this.notEligible();
            if (this.needs) {
                return this;
            }
            ++this.nbReserved;
            return null;
        }

        public void inNeed(boolean needs) {
            this.needs = needs;
            if (this.nbReserved < 0L && this.nbReserved > this.extraLimit && needs) {
                this.beEligible();
            } else {
                this.notEligible();
            }
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object obj) {
            this.userObject = obj;
        }

        public long getNbReserved() {
            return this.nbReserved;
        }

        public String toString() {
            return super.toString() + " : needs=" + this.needs + " nbReserved=" + this.nbReserved + " fromReservedItems=" + this.fromReservedItems + " fromExtraItems=" + this.fromExtraItems + " extraLimit=" + this.extraLimit;
        }
    }
}

