/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.impl.util.JxtaTimerHandler;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JxtaTimer
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)JxtaTimer.class.getName());
    private JxtaTimerHandler handler = null;
    private Thread thread = null;
    private long delay = 0L;
    private boolean repeat = false;
    private boolean finish = false;

    public JxtaTimer(JxtaTimerHandler handler, long delay, boolean repeat) {
        this.handler = handler;
        this.delay = delay;
        this.repeat = repeat;
        if (delay < 1L) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"delay must be > 0");
            }
            throw new IllegalArgumentException("delay must be > 0");
        }
        String threadName = null;
        threadName = repeat ? "JxtaTimerThread repeat=" + delay + ", handler=" + handler.getClass().getName() : "JxtaTimerThread delay=" + delay + ", handler=" + handler.getClass().getName();
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.start();
    }

    public long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long delay) {
        if (delay <= 0L) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"delay must be > 0");
            }
            throw new IllegalArgumentException("delay must be > 0");
        }
        this.delay = delay;
        this.thread.interrupt();
    }

    public boolean isRepeating() {
        return this.repeat;
    }

    public synchronized boolean isCancelled() {
        return this.finish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        JxtaTimer jxtaTimer = this;
        synchronized (jxtaTimer) {
            this.finish = true;
        }
        try {
            this.thread.setDaemon(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread.interrupt();
    }

    public void run() {
        block9: {
            try {
                long startedWaiting = System.currentTimeMillis();
                while (!this.isCancelled()) {
                    long beenWaiting = System.currentTimeMillis() - startedWaiting;
                    try {
                        long waitRemaining = this.delay - beenWaiting;
                        if (waitRemaining > 0L) {
                            Thread.sleep(waitRemaining);
                        }
                        this.handler.signal(this);
                        if (this.repeat) {
                            startedWaiting = System.currentTimeMillis();
                            continue;
                        }
                        break;
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                    catch (Exception thrown) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Terminating due to exception : " + Thread.currentThread().getName()), (Throwable)thrown);
                        }
                        break;
                    }
                }
            }
            catch (Throwable everything) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block9;
                LOG.error((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), everything);
            }
        }
        this.handler = null;
    }
}

