/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class BASE64OutputStream
extends OutputStream {
    private Writer sendTo = null;
    private final int columnWidth;
    private int column = 0;
    private byte[] buffer = new byte[]{0, 0, 0};
    private boolean closed = false;
    private byte inBuffer = 0;
    static final char[] encode = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public BASE64OutputStream(Writer sendTo) {
        this(sendTo, -1);
    }

    public BASE64OutputStream(Writer sendTo, int columnWidth) {
        this.sendTo = sendTo;
        this.columnWidth = columnWidth;
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream closed.");
        }
        byte by = this.inBuffer;
        this.inBuffer = (byte)(by + 1);
        this.buffer[by] = (byte)b;
        if (this.buffer.length == this.inBuffer) {
            this.writeBuffer();
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.writeBuffer();
    }

    private void writeBuffer() throws IOException {
        if (0 == this.inBuffer) {
            return;
        }
        int val = ((this.buffer[0] & 0xFF) << 16) + ((this.buffer[1] & 0xFF) << 8) + (this.buffer[2] & 0xFF);
        int c0 = val >> 18 & 0x3F;
        int c1 = val >> 12 & 0x3F;
        int c2 = val >> 6 & 0x3F;
        int c3 = val & 0x3F;
        if (this.columnWidth > 0 && this.column > this.columnWidth) {
            this.sendTo.write(10);
            this.column = 0;
        }
        this.sendTo.write(BASE64OutputStream.encodeSixBits(c0));
        this.sendTo.write(BASE64OutputStream.encodeSixBits(c1));
        if (this.inBuffer > 1) {
            this.sendTo.write(BASE64OutputStream.encodeSixBits(c2));
        } else {
            this.sendTo.write(61);
        }
        if (this.inBuffer > 2) {
            this.sendTo.write(BASE64OutputStream.encodeSixBits(c3));
        } else {
            this.sendTo.write(61);
        }
        this.buffer[0] = 0;
        this.buffer[1] = 0;
        this.buffer[2] = 0;
        this.inBuffer = 0;
        this.column += 4;
    }

    private static char encodeSixBits(int b) {
        char c = b < 0 || b > 63 ? (char)'?' : encode[b];
        return c;
    }
}

