/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.impl.resolver.resolverMeter.QueryDestinationMeter;
import net.jxta.impl.resolver.resolverMeter.QueryDestinationMetric;
import net.jxta.impl.resolver.resolverMeter.QueryHandlerMetric;
import net.jxta.impl.resolver.resolverMeter.ResolverServiceMonitor;
import net.jxta.peer.PeerID;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;

public class QueryHandlerMeter {
    private static final int QUERY_CULLING_INTERVAL = 300000;
    private ResolverServiceMonitor resolverServiceMonitor;
    private String handlerName;
    private QueryHandlerMetric cumulativeMetrics;
    private QueryHandlerMetric deltaMetrics;
    private Hashtable queryDestinationMeters = new Hashtable();
    private Hashtable queryMetricsTable = null;
    private static LinkedList queryMetricsTables = new LinkedList();

    public QueryHandlerMeter(String handlerName, ResolverServiceMonitor resolverServiceMonitor) {
        this.handlerName = handlerName;
        this.cumulativeMetrics = new QueryHandlerMetric(handlerName);
        this.resolverServiceMonitor = resolverServiceMonitor;
    }

    public QueryHandlerMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public synchronized QueryHandlerMetric collectMetrics() {
        QueryHandlerMetric prevDelta = this.deltaMetrics;
        Enumeration e = this.queryDestinationMeters.elements();
        while (e.hasMoreElements()) {
            QueryDestinationMeter queryDestinationMeter = (QueryDestinationMeter)e.nextElement();
            QueryDestinationMetric queryDestinationMetric = queryDestinationMeter.collectMetrics();
            if (queryDestinationMetric == null) continue;
            if (prevDelta == null) {
                this.createDeltaMetric();
                prevDelta = this.deltaMetrics;
            }
            prevDelta.addQueryDestinationMetric(queryDestinationMetric);
        }
        this.deltaMetrics = null;
        return prevDelta;
    }

    public synchronized QueryDestinationMeter getQueryDestinationMeter(EndpointAddress endpointAddress) {
        PeerID peerID = MetricUtilities.getPeerIdFromEndpointAddress(endpointAddress);
        return this.getQueryDestinationMeter(peerID);
    }

    public synchronized QueryDestinationMeter getQueryDestinationMeter(String peerIdString) {
        PeerID peerID = MetricUtilities.getPeerIdFromString(peerIdString);
        return this.getQueryDestinationMeter(peerID);
    }

    public synchronized QueryDestinationMeter getQueryDestinationMeter(PeerID peerID) {
        QueryDestinationMeter queryDestinationMeter = (QueryDestinationMeter)this.queryDestinationMeters.get(peerID);
        if (queryDestinationMeter == null) {
            queryDestinationMeter = new QueryDestinationMeter(peerID);
            this.queryDestinationMeters.put(peerID, queryDestinationMeter);
            this.cumulativeMetrics.addQueryDestinationMetric(queryDestinationMeter.getCumulativeMetrics());
        }
        return queryDestinationMeter;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new QueryHandlerMetric(this.handlerName);
    }

    public String toString() {
        return "ResolverHandlerMeter(" + this.handlerName + ")";
    }

    public void setRegistered(boolean registered) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.setRegistered(registered);
        this.cumulativeMetrics.setRegistered(registered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryMetric getQueryMetric(int queryId) {
        Integer key = new Integer(queryId);
        LinkedList linkedList = queryMetricsTables;
        synchronized (linkedList) {
            QueryMetric queryMetric;
            if (this.queryMetricsTable == null) {
                this.queryMetricsTable = new QueryMetricsTable();
                queryMetricsTables.add(this.queryMetricsTable);
            }
            if ((queryMetric = (QueryMetric)this.queryMetricsTable.get(key)) == null) {
                queryMetric = new QueryMetric(queryId);
                this.queryMetricsTable.put(key, queryMetric);
            }
            return queryMetric;
        }
    }

    public void querySentInGroup(ResolverQueryMsg query) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.getQueryMetric(query.getQueryId());
        this.deltaMetrics.querySentInGroup();
        this.cumulativeMetrics.querySentInGroup();
    }

    public void querySentViaWalker(ResolverQueryMsg query) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.getQueryMetric(query.getQueryId());
        this.deltaMetrics.querySentViaWalker();
        this.cumulativeMetrics.querySentViaWalker();
    }

    public void querySentViaUnicast(String peer, ResolverQueryMsg query) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.getQueryMetric(query.getQueryId());
        this.deltaMetrics.querySentViaUnicast(peer);
        this.cumulativeMetrics.querySentViaUnicast(peer);
        QueryDestinationMeter destinationMeter = this.getQueryDestinationMeter(peer);
        destinationMeter.querySentViaUnicast();
    }

    public void querySendError() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.querySendError();
        this.cumulativeMetrics.querySendError();
    }

    public void queryPropagateError() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.queryPropagateError();
        this.cumulativeMetrics.queryPropagateError();
    }

    public void queryHopCountDropped() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.queryHopCountDropped();
        this.cumulativeMetrics.queryHopCountDropped();
    }

    public void unableToPropagate() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.unableToPropagate();
        this.cumulativeMetrics.unableToPropagate();
    }

    public void queryPropagatedInGroup() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.queryPropagatedInGroup();
        this.cumulativeMetrics.queryPropagatedInGroup();
    }

    public void queryPropagatedViaWalker() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.queryPropagatedViaWalker();
        this.cumulativeMetrics.queryPropagatedViaWalker();
    }

    public void propagationQueryDropped() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.propagationQueryDropped();
        this.cumulativeMetrics.propagationQueryDropped();
    }

    public void responseSentViaUnicast(String peer, ResolverResponseMsg response) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responseSentViaUnicast();
        this.cumulativeMetrics.responseSentViaUnicast();
        QueryDestinationMeter destinationMeter = this.getQueryDestinationMeter(peer);
        destinationMeter.responseSentViaUnicast();
    }

    public void responseSentViaWalker(ResolverResponseMsg response) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responseSentViaWalker();
        this.cumulativeMetrics.responseSentViaWalker();
    }

    public void responseSentInGroup(ResolverResponseMsg response) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responseSentInGroup();
        this.cumulativeMetrics.responseSentInGroup();
    }

    public void responseSendError() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responseSendError();
        this.cumulativeMetrics.responseSendError();
    }

    public void responsePropagateError() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responsePropagateError();
        this.cumulativeMetrics.responsePropagateError();
    }

    public void responseProcessed(ResolverResponseMsg response, long processTime, EndpointAddress srcAddr) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        QueryMetric queryMetric = this.getQueryMetric(response.getQueryId());
        long now = System.currentTimeMillis();
        long responseTime = now - queryMetric.querySentTime;
        queryMetric.lastResponseTime = now;
        ++queryMetric.numResponsesReceived;
        this.deltaMetrics.responseProcessed(responseTime, processTime);
        this.cumulativeMetrics.responseProcessed(responseTime, processTime);
        QueryDestinationMeter destinationMeter = this.getQueryDestinationMeter(srcAddr);
        destinationMeter.responseProcessed();
    }

    public void responseToUnregisteredHandler(EndpointAddress src) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.responseToUnregisteredHandler();
        this.cumulativeMetrics.responseToUnregisteredHandler();
        QueryDestinationMeter destinationMeter = this.getQueryDestinationMeter(src);
        destinationMeter.responseToUnregisteredHandler();
    }

    public void errorWhileProcessingResponse(EndpointAddress srcAddr) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorWhileProcessingResponse();
        this.cumulativeMetrics.errorWhileProcessingResponse();
        QueryDestinationMeter destinationMeter = this.getQueryDestinationMeter(srcAddr);
        destinationMeter.errorWhileProcessingResponse();
    }

    public void queryProcessed(ResolverQueryMsg query, int result, long processTime) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.queryProcessed(result, processTime);
        this.cumulativeMetrics.queryProcessed(result, processTime);
        QueryDestinationMeter destinationMeter = this.getQueryDestinationMeter(query.getSrc());
        destinationMeter.queryProcessed();
    }

    public void queryToUnregisteredHandler(ResolverQueryMsg query) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.queryToUnregisteredHandler();
        this.cumulativeMetrics.queryToUnregisteredHandler();
        QueryDestinationMeter destinationMeter = this.getQueryDestinationMeter(query.getSrc());
        destinationMeter.queryToUnregisteredHandler();
    }

    public void errorWhileProcessingQuery(ResolverQueryMsg query) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorWhileProcessingQuery();
        this.cumulativeMetrics.errorWhileProcessingQuery();
        QueryDestinationMeter destinationMeter = this.getQueryDestinationMeter(query.getSrc());
        destinationMeter.errorWhileProcessingQuery();
    }

    public Enumeration getQueryDestinationMeters() {
        return this.queryDestinationMeters.elements();
    }

    public int getQueryDestinationCount() {
        return this.queryDestinationMeters.size();
    }

    static {
        Thread cullQueries = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    long dormantTime = System.currentTimeMillis() - 300000L;
                    LinkedList linkedList = queryMetricsTables;
                    synchronized (linkedList) {
                        LinkedList<Integer> keysToRemove = new LinkedList<Integer>();
                        Iterator i = queryMetricsTables.iterator();
                        while (i.hasNext()) {
                            QueryMetricsTable queryMetricsTable = (QueryMetricsTable)i.next();
                            keysToRemove.clear();
                            QueryMetricsTable queryMetricsTable2 = queryMetricsTable;
                            synchronized (queryMetricsTable2) {
                                Integer key;
                                Enumeration e = queryMetricsTable.keys();
                                while (e.hasMoreElements()) {
                                    key = (Integer)e.nextElement();
                                    QueryMetric queryMetric = (QueryMetric)queryMetricsTable.get(key);
                                    if (queryMetric.lastResponseTime >= dormantTime) continue;
                                    keysToRemove.add(key);
                                }
                                Iterator k = keysToRemove.iterator();
                                while (k.hasNext()) {
                                    key = (Integer)k.next();
                                    queryMetricsTable.deReference();
                                    queryMetricsTable.remove(key);
                                }
                                if (queryMetricsTable.size() == 0) {
                                    i.remove();
                                }
                            }
                        }
                    }
                }
            }
        }, "Resolver Query Metrics Culling Thread");
        cullQueries.setDaemon(true);
        cullQueries.start();
    }

    private class QueryMetric {
        int queryId;
        long querySentTime = System.currentTimeMillis();
        int numResponsesReceived = 0;
        long lastResponseTime = 0L;

        QueryMetric(int queryId) {
            this.queryId = queryId;
        }
    }

    private class QueryMetricsTable
    extends Hashtable {
        private QueryMetricsTable() {
        }

        void deReference() {
            QueryHandlerMeter.this.queryMetricsTable = null;
        }

        public String toString() {
            return QueryHandlerMeter.this.handlerName;
        }
    }
}

