/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rpv;

import java.io.IOException;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewDestination;
import net.jxta.impl.util.TimeUtils;
import net.jxta.protocol.RdvAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PeerViewElement
extends PeerViewDestination
implements OutgoingMessageEventListener {
    private static final transient Logger LOG = Logger.getLogger((String)PeerViewElement.class.getName());
    private EndpointService endpoint = null;
    private long created = 0L;
    private long lastUpdate = 0L;
    private RdvAdvertisement radv = null;
    private boolean alive = true;
    private volatile boolean throttling = false;
    private PeerView peerview = null;
    private Messenger cachedMessenger = null;

    PeerViewElement(EndpointService endpoint, RdvAdvertisement radv) {
        super(radv.getPeerID());
        this.endpoint = endpoint;
        this.radv = radv;
        this.lastUpdate = this.created = TimeUtils.timeNow();
    }

    public String toString() {
        StringBuffer asString = new StringBuffer();
        asString.append('\"');
        asString.append(this.radv.getName());
        asString.append('\"');
        asString.append(this.alive ? " A " : " a ");
        asString.append(this.isInPeerView() ? " P " : " p ");
        asString.append(this.throttling ? " T " : " t ");
        asString.append(" [");
        asString.append(TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), this.created) / 1000L);
        asString.append("/");
        asString.append(TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), this.lastUpdate) / 1000L);
        asString.append("]");
        return asString.toString();
    }

    public void messageSendSucceeded(OutgoingMessageEvent e) {
        this.setAlive(true);
        this.throttling = false;
    }

    public void messageSendFailed(OutgoingMessageEvent e) {
        this.setAlive(e.getFailure() == null);
        this.throttling = e.getFailure() == null;
    }

    boolean isAlive() {
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAlive(boolean live) {
        PeerView temp;
        boolean mustNotify;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            mustNotify = this.alive && !live;
            this.alive = live;
        }
        if (mustNotify && null != (temp = this.peerview)) {
            temp.notifyFailure(this, true);
        }
    }

    boolean isInPeerView() {
        return null != this.peerview;
    }

    synchronized void setPeerView(PeerView pv) {
        if (null != this.peerview && null != pv) {
            throw new IllegalStateException("Element already in " + this.peerview);
        }
        this.peerview = pv;
    }

    long getLastUpdateTime() {
        return this.lastUpdate;
    }

    void setLastUpdateTime(long last) {
        this.lastUpdate = last;
    }

    public boolean sendMessage(Message msg, String serviceName, String serviceParam) {
        if (this.throttling) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Declining to send -- throttling on " + this));
            }
            return false;
        }
        Messenger sendVia = this.getCachedMessenger();
        if (null == sendVia) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not get messenger for " + this.getDestAddress()));
            }
            OutgoingMessageEvent event = new OutgoingMessageEvent(msg, new IOException("Couldn't get messenger for " + this.getDestAddress()));
            this.messageSendFailed(event);
            return false;
        }
        sendVia.sendMessage(msg, serviceName, serviceParam, this);
        return true;
    }

    public RdvAdvertisement getRdvAdvertisement() {
        return this.radv;
    }

    RdvAdvertisement setRdvAdvertisement(RdvAdvertisement adv) {
        if (!this.radv.getPeerID().equals(adv.getPeerID())) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"adv refers to a different peer");
            }
            throw new IllegalArgumentException("adv refers to a different peer");
        }
        RdvAdvertisement old = this.radv;
        this.radv = adv;
        this.setLastUpdateTime(TimeUtils.timeNow());
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Messenger getCachedMessenger() {
        boolean updateAlive = false;
        PeerViewElement peerViewElement = this;
        synchronized (peerViewElement) {
            if (null == this.cachedMessenger || this.cachedMessenger.isClosed()) {
                this.cachedMessenger = null;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Getting cached Messenger for " + this.radv.getName()));
                }
                updateAlive = true;
                this.cachedMessenger = this.endpoint.getMessenger(this.getDestAddress(), this.radv.getRouteAdv());
            }
        }
        if (updateAlive) {
            this.setAlive(null != this.cachedMessenger);
        }
        return this.cachedMessenger;
    }
}

