/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import net.jxta.impl.rendezvous.rendezvousMeter.ClientConnectionMetric;
import net.jxta.peer.PeerID;

public class ClientConnectionMeter {
    private PeerID peerID;
    private ClientConnectionMetric cumulativeMetrics;
    private ClientConnectionMetric deltaMetrics;
    private long transitionTime = 0L;
    private long lastLeaseRenewalTime = 0L;

    public ClientConnectionMeter(PeerID peerID) {
        this.peerID = peerID;
        this.cumulativeMetrics = new ClientConnectionMetric(peerID);
    }

    public ClientConnectionMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    public synchronized ClientConnectionMetric collectMetrics() {
        ClientConnectionMetric prevDelta = this.deltaMetrics;
        this.deltaMetrics = null;
        return prevDelta;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new ClientConnectionMetric(this.cumulativeMetrics);
    }

    public void clientConnectionEstablished(long lease) {
        this.transitionTime = System.currentTimeMillis();
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.clientConnectionEstablished(this.transitionTime, lease);
        this.cumulativeMetrics.clientConnectionEstablished(this.transitionTime, lease);
    }

    public void clientLeaseRenewed(long lease) {
        this.lastLeaseRenewalTime = System.currentTimeMillis();
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.clientLeaseRenewed(this.lastLeaseRenewalTime, lease);
        this.cumulativeMetrics.clientLeaseRenewed(this.lastLeaseRenewalTime, lease);
    }

    public void errorAddingClient() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorAddingClient();
        this.cumulativeMetrics.errorAddingClient();
    }

    public void clientConnectionDisconnected(boolean normal) {
        this.transitionTime = System.currentTimeMillis();
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.clientConnectionDisconnected(normal, this.transitionTime);
        this.cumulativeMetrics.clientConnectionDisconnected(normal, this.transitionTime);
    }

    public void unableToRespondToConnectRequest() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.unableToRespondToConnectRequest();
        this.cumulativeMetrics.unableToRespondToConnectRequest();
    }

    public void clientConnectionRefused() {
        this.transitionTime = System.currentTimeMillis();
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.clientConnectionRefused(this.transitionTime);
        this.cumulativeMetrics.clientConnectionRefused(this.transitionTime);
    }

    public String toString() {
        return "ClientConnectionMeter(" + this.peerID + ")";
    }
}

