/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.limited;

import java.io.IOException;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.impl.protocol.LimitedRangeRdvMsg;
import net.jxta.impl.rendezvous.RdvWalker;
import net.jxta.impl.rendezvous.limited.LimitedRangeWalk;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.LimitedRangeRdvMessage;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LimitedRangeWalker
implements RdvWalker {
    private static final transient Logger LOG = Logger.getLogger((String)LimitedRangeWalker.class.getName());
    private LimitedRangeWalk walk = null;
    private PeerGroup group = null;
    private EndpointService endpoint = null;
    private PeerView rpv = null;
    private final String svcName;
    private final String svcParam;

    public LimitedRangeWalker(PeerGroup group, LimitedRangeWalk walk) {
        this.walk = walk;
        this.group = group;
        this.endpoint = group.getEndpointService();
        this.rpv = walk.getPeerView();
        this.svcName = "LR-Greeter" + group.getPeerGroupID().toString();
        this.svcParam = walk.getServiceName() + walk.getServiceParam();
    }

    public synchronized void stop() {
        this.walk = null;
        this.group = null;
        this.endpoint = null;
        this.rpv = null;
    }

    public void resendMessage(Message msg) throws IOException {
        LimitedRangeRdvMessage rdvMsg = this.getRdvMessage(msg);
        if (rdvMsg == null) {
            throw new IOException("No LimitedRangeRdvMessage in " + msg);
        }
        this.walkMessage(msg, rdvMsg);
    }

    private void walkMessage(Message msg, LimitedRangeRdvMessage rdvMsg) throws IOException {
        PeerViewElement downPeer;
        Message newMsg;
        PeerViewElement upPeer;
        int dir = rdvMsg.getDirection();
        if ((dir == 3 || dir == 1) && (upPeer = this.rpv.getUpPeer()) != null) {
            newMsg = (Message)msg.clone();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sending " + newMsg + " [UP] to " + upPeer));
            }
            rdvMsg.setDirection(1);
            this.updateRdvMessage(newMsg, rdvMsg);
            upPeer.sendMessage(newMsg, this.svcName, this.svcParam);
        }
        if ((dir == 3 || dir == 2) && (downPeer = this.rpv.getDownPeer()) != null) {
            newMsg = (Message)msg.clone();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sending " + newMsg + " [DOWN] to " + downPeer));
            }
            rdvMsg.setDirection(2);
            this.updateRdvMessage(newMsg, rdvMsg);
            downPeer.sendMessage(newMsg, this.svcName, this.svcParam);
        }
    }

    public void sendMessage(PeerID destination, Message msg, String srcSvcName, String srcSvcParam, int ttl, RouteAdvertisement srcRouteAdv) throws IOException {
        LimitedRangeRdvMessage rdvMsg;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Sending " + msg + " to " + srcSvcName + "/" + srcSvcParam));
        }
        if ((rdvMsg = this.getRdvMessage(msg)) == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Creating new RDV message for " + msg));
            }
            rdvMsg = new LimitedRangeRdvMsg();
            rdvMsg.setTTL(ttl);
            rdvMsg.setDirection(3);
            rdvMsg.setSrcPeerID(this.group.getPeerID().toString());
            rdvMsg.setSrcSvcName(srcSvcName);
            rdvMsg.setSrcSvcParams(srcSvcParam);
            if (null != srcRouteAdv) {
                rdvMsg.setSrcRouteAdv(srcRouteAdv.toString());
            }
        }
        int useTTL = Math.min(ttl, rdvMsg.getTTL());
        if ((useTTL = Math.min(useTTL, this.rpv.getView().size() + 1)) <= 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("No TTL remaining for " + msg));
            }
            return;
        }
        rdvMsg.setTTL(useTTL);
        if (null != destination) {
            Message tmp = (Message)msg.clone();
            this.updateRdvMessage(tmp, rdvMsg);
            this.sendToPeer(destination, this.svcName, this.svcParam, tmp);
        } else {
            this.walkMessage(msg, rdvMsg);
        }
    }

    private void updateRdvMessage(Message msg, LimitedRangeRdvMessage rdvMsg) throws IOException {
        XMLDocument asDoc = (XMLDocument)rdvMsg.getDocument(MimeMediaType.XMLUTF8);
        TextDocumentMessageElement el = new TextDocumentMessageElement("LimitedRangeRdvMessage", asDoc, null);
        msg.replaceMessageElement("jxta", el);
    }

    private void sendToPeer(PeerID dest, String svcName, String svcParam, Message msg) throws IOException {
        PeerViewElement pve = this.rpv.getPeerViewElement(dest);
        if (null == pve) {
            throw new IOException("LimitedRangeWalker was not able to send message: no pve");
        }
        if (!pve.sendMessage(msg, svcName, svcParam)) {
            throw new IOException("LimitedRangeWalker was not able to send message: send failed");
        }
    }

    private LimitedRangeRdvMessage getRdvMessage(Message msg) {
        LimitedRangeRdvMsg rdvMsg = null;
        MessageElement el = msg.getMessageElement("jxta", "LimitedRangeRdvMessage");
        try {
            if (el == null) {
                return null;
            }
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(el.getMimeType(), el.getStream());
            rdvMsg = new LimitedRangeRdvMsg(asDoc);
        }
        catch (Exception ez) {
            return null;
        }
        return rdvMsg;
    }
}

