/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.edge;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.StdRendezVousService;
import net.jxta.impl.rendezvous.edge.RdvConnection;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.impl.rendezvous.rpv.PeerViewEvent;
import net.jxta.impl.rendezvous.rpv.PeerViewListener;
import net.jxta.impl.util.TimeUtils;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.rendezvous.RendezVousMonitor;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EdgePeerRdvService
extends StdRendezVousService
implements PeerViewListener {
    private static final transient Logger LOG = Logger.getLogger((String)EdgePeerRdvService.class.getName());
    private static final long MONITOR_INTERVAL = 20000L;
    private static final long ADDEVENT_DELAY = 3000L;
    private static final long CHALLENGE_TIMEOUT = 90000L;
    private final int MAX_RDV_CONNECTIONS = 1;
    private boolean useOnlySeeds = false;
    private long LEASE_MARGIN = 300000L;
    private long maxChoiceDelay = 3000L;
    private long monitorStartAt = -1L;
    private long monitorNotBefore = -1L;
    private Map rendezVous = Collections.synchronizedMap(new HashMap());
    private Set disconnectedRendezVous = Collections.synchronizedSet(new HashSet());

    public EdgePeerRdvService(PeerGroup group, RendezVousServiceImpl rdvService) {
        super(group, rdvService);
        ConfigParams confAdv = group.getConfigAdvertisement();
        if (confAdv != null) {
            Advertisement adv = null;
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(rdvService.getAssignedID());
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
                // empty catch block
            }
            if (adv instanceof RdvConfigAdv) {
                RdvConfigAdv rdvConfigAdv = (RdvConfigAdv)adv;
                if (-1 != rdvConfigAdv.getMaxTTL()) {
                    this.MAX_TTL = rdvConfigAdv.getMaxTTL();
                }
                this.useOnlySeeds = rdvConfigAdv.getUseOnlySeeds();
                if (0L != rdvConfigAdv.getLeaseMargin()) {
                    this.LEASE_MARGIN = rdvConfigAdv.getLeaseMargin();
                }
                this.maxChoiceDelay = (long)rdvConfigAdv.getMinHappyPeerView() * 3000L;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("RendezVous Service is initialized for " + group.getPeerGroupID() + " as an Edge peer."));
        }
    }

    protected int startApp(String[] arg) {
        long choiceDelay;
        super.startApp(arg, new StdRdvEdgeProtocolListener());
        this.rdvService.setMonitor(null);
        this.rdvService.generateEvent(9, this.group.getPeerID());
        if (this.useOnlySeeds) {
            choiceDelay = 0L;
        } else {
            Vector rpv = this.rdvService.getLocalWalkView();
            int rpvSize = rpv.size();
            choiceDelay = Math.max(0L, this.maxChoiceDelay - (long)rpvSize * 3000L);
        }
        this.monitorStartAt = TimeUtils.toAbsoluteTimeMillis(choiceDelay);
        this.timer.schedule((TimerTask)new MonitorTask(), choiceDelay, 20000L);
        this.rdvService.rpv.addListener(this);
        this.timer.scheduleAtFixedRate((TimerTask)new GCTask(), 120000L, 120000L);
        return 0;
    }

    protected synchronized void stopApp() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.disconnectFromAllRendezVous();
        this.rdvService.setMonitor(null);
        this.rdvService.rpv.removeListener(this);
        super.stopApp();
    }

    public Vector getConnectedPeerIDs() {
        return new Vector();
    }

    public Enumeration getConnectedPeers() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public boolean isConnectedToRendezVous() {
        return !this.rendezVous.isEmpty();
    }

    public Enumeration getConnectedRendezVous() {
        return Collections.enumeration(Arrays.asList(this.rendezVous.keySet().toArray()));
    }

    public Enumeration getDisconnectedRendezVous() {
        List<Object> result = Arrays.asList(this.disconnectedRendezVous.toArray());
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)(result.size() + " rendezvous disconnections."));
        }
        return Collections.enumeration(result);
    }

    public void challengeRendezVous(ID peerid, long delay) {
        if (delay <= 0L) {
            this.removeRdv((PeerID)peerid);
            return;
        }
        RdvConnection pConn = (RdvConnection)this.rendezVous.get(peerid);
        if (null != pConn) {
            long adjusted_delay = Math.max(0L, Math.min(TimeUtils.toRelativeTimeMillis(pConn.getLeaseEnd()), delay));
            pConn.setLease(adjusted_delay, adjusted_delay);
        }
    }

    public void disconnectFromRendezVous(ID peerId) {
        this.removeRdv((PeerID)peerId);
    }

    public void propagate(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.sendToEachConnection(msg, propHdr);
            this.sendToNetwork(msg, propHdr);
        } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Declining to propagate " + msg + " (" + propHdr.getMsgId() + ")"));
        }
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.sendToEachConnection(msg, propHdr);
        } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Declining to propagate " + msg + " (" + propHdr.getMsgId() + ")"));
        }
    }

    protected void repropagate(Message msg, RendezVousPropagateMessage propHdr, String serviceName, String serviceParam) {
        block5: {
            try {
                propHdr = this.updatePropHeader(msg, propHdr, serviceName, serviceParam, this.MAX_TTL);
                if (null != propHdr) {
                    this.sendToEachConnection(msg, propHdr);
                    this.sendToNetwork(msg, propHdr);
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Declining to repropagate " + msg + " (" + propHdr.getMsgId() + ")"));
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)("Could not repropagate " + msg + " (" + propHdr.getMsgId() + ")"), (Throwable)ez1);
            }
        }
    }

    public void walk(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        this.propagateInGroup(msg, serviceName, serviceParam, ttl);
    }

    public void walk(Vector destPeerIDs, Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        this.propagate(destPeerIDs.elements(), msg, serviceName, serviceParam, ttl);
    }

    public PeerConnection getPeerConnection(ID peer) {
        return (PeerConnection)this.rendezVous.get(peer);
    }

    protected PeerConnection[] getPeerConnections() {
        return this.rendezVous.values().toArray(new PeerConnection[0]);
    }

    private void sendLeaseRequest(EndpointAddress dest, RouteAdvertisement radv) throws IOException {
        Messenger msngr = this.rdvService.endpoint.getMessenger(dest, radv);
        if (null == msngr) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not connect to " + dest));
            }
            throw new IOException("Could not connect to " + dest);
        }
        this.sendLeaseRequest(msngr);
    }

    private void reconnectToRendezVous(RdvConnection pConn) {
        block4: {
            try {
                Messenger msngr;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Reconnect to " + pConn));
                }
                if (null == (msngr = pConn.getCachedMessenger())) {
                    pConn.disconnect();
                    this.rdvService.generateEvent(5, pConn.getPeerID());
                    this.disconnectFromRendezVous(pConn.getPeerID());
                    return;
                }
                this.sendLeaseRequest(msngr);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block4;
                LOG.debug((Object)"reconnectToRendezVous failed ", (Throwable)e);
            }
        }
    }

    private void disconnectFromAllRendezVous() {
        Iterator<Object> eachRendezvous = Arrays.asList(this.rendezVous.values().toArray()).iterator();
        while (eachRendezvous.hasNext()) {
            try {
                RdvConnection pConn = (RdvConnection)eachRendezvous.next();
                this.disconnectFromRendezVous(pConn.getPeerID());
            }
            catch (Exception failed) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"disconnectFromRendezVous failed ", (Throwable)failed);
            }
        }
    }

    private void processDisconnectRequest(Message msg) {
        block6: {
            try {
                MessageElement elem = msg.getMessageElement("jxta", "Disconnect");
                if (null != elem) {
                    InputStream is = elem.getStream();
                    PeerAdvertisement adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(elem.getMimeType(), is);
                    RdvConnection rdvConnection = (RdvConnection)this.rendezVous.get(adv.getPeerID());
                    if (null != rdvConnection) {
                        rdvConnection.disconnect();
                        this.rdvService.generateEvent(4, rdvConnection.getPeerID());
                        this.removeRdv(adv.getPeerID());
                    } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Ignoring disconnect request from " + adv.getPeerID()));
                    }
                }
            }
            catch (Exception failure) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)"Failure procressing disconnect request", (Throwable)failure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRdv(PeerAdvertisement padv, long lease) {
        int eventType;
        RdvConnection rdvConnection;
        Map map = this.rendezVous;
        synchronized (map) {
            rdvConnection = (RdvConnection)this.rendezVous.get(padv.getPeerID());
            if (null == rdvConnection) {
                rdvConnection = new RdvConnection(this.group, this.rdvService, padv.getPeerID());
                this.rendezVous.put(padv.getPeerID(), rdvConnection);
                this.disconnectedRendezVous.remove(padv.getPeerID());
                eventType = 0;
            } else {
                eventType = 1;
            }
        }
        if (1 == eventType) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Renewed RDV lease from " + rdvConnection));
            }
        } else if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("New RDV lease from " + rdvConnection));
        }
        rdvConnection.connect(padv, lease, Math.min(this.LEASE_MARGIN, lease / 2L));
        this.connected(padv.getPeerID(), lease);
        this.rdvService.generateEvent(eventType, padv.getPeerID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRdv(ID rdvid) {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Disconnect from RDV " + rdvid));
        }
        PeerConnection rdvConnection = null;
        EdgePeerRdvService edgePeerRdvService = this;
        synchronized (edgePeerRdvService) {
            rdvConnection = (PeerConnection)this.rendezVous.remove(rdvid);
            this.disconnectedRendezVous.add(rdvid);
        }
        if (null != rdvConnection) {
            if (rdvConnection.isConnected()) {
                Message msg = new Message();
                TextDocumentMessageElement me = new TextDocumentMessageElement("Disconnect", this.getPeerAdvertisementDoc(), null);
                msg.replaceMessageElement("jxta", me);
                rdvConnection.sendMessage(msg, this.pName, this.pParam);
                rdvConnection.disconnect();
                this.rdvService.generateEvent(4, rdvid);
            }
        } else {
            this.rdvService.generateEvent(4, rdvid);
        }
        this.rdvService.rpv.notifyFailure((PeerID)rdvid, false);
        this.disconnected((PeerID)rdvid);
    }

    private void sendLeaseRequest(Messenger msngr) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Sending Lease request to " + msngr.getDestinationAddress()));
        }
        Object rendezvousConnectionMeter = null;
        Message msg = new Message();
        msg.replaceMessageElement("jxta", new TextDocumentMessageElement("Connect", this.getPeerAdvertisementDoc(), null));
        msngr.sendMessage(msg, this.pName, this.pParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processConnectedReply(Message msg) {
        ID pId;
        long lease;
        PeerAdvertisement padv;
        block33: {
            IOException ignored2222;
            Object var7_8;
            InputStream is;
            block32: {
                block31: {
                    MessageElement elem = msg.getMessageElement("jxta", "RdvAdvReply");
                    if (null == elem) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"missing rendezvous peer advertisement");
                        }
                        return;
                    }
                    is = null;
                    padv = null;
                    is = elem.getStream();
                    padv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(elem.getMimeType(), is);
                    DiscoveryService discovery = this.group.getDiscoveryService();
                    if (null == discovery) break block31;
                    discovery.publish(padv, 0x6DDD00L, 0x6DDD00L);
                }
                var7_8 = null;
                if (null == is) break block32;
                try {
                    is.close();
                }
                catch (IOException ignored2222) {
                    // empty catch block
                }
            }
            is = null;
            {
                break block33;
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"failed to publish Rendezvous Advertisement", (Throwable)e);
                    }
                    var7_8 = null;
                    if (null != is) {
                        try {
                            is.close();
                        }
                        catch (IOException ignored2222) {
                            // empty catch block
                        }
                    }
                    is = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException ignored2222) {
                        // empty catch block
                    }
                }
                is = null;
                throw throwable;
            }
        }
        if (null == padv) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"missing rendezvous peer advertisement");
            }
            return;
        }
        try {
            MessageElement el = msg.getMessageElement("jxta", "ConnectedLease");
            if (el == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"missing lease");
                }
                return;
            }
            lease = Long.parseLong(el.toString());
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"parse lease failed with ", (Throwable)e);
            }
            return;
        }
        MessageElement el = msg.getMessageElement("jxta", "ConnectedPeer");
        if (el == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"missing rdv peer");
            }
            return;
        }
        try {
            pId = IDFactory.fromURI(new URI(el.toString()));
        }
        catch (URISyntaxException badID) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Bad RDV peer ID");
            }
            return;
        }
        String rdvName = padv.getName();
        if (null == padv.getName()) {
            rdvName = pId.toString();
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("RDV Connect Response : peer=" + rdvName + " lease=" + lease + "ms"));
        }
        if (lease <= 0L) {
            this.removeRdv(pId);
        } else if (this.rendezVous.containsKey(pId) || this.rendezVous.size() < 1 && this.rdvService.rpv.getPeerViewElement(pId) != null) {
            this.addRdv(padv, lease);
        } else {
            LOG.debug((Object)("Ignoring lease offer from " + rdvName));
        }
    }

    private void disconnected(ID pid) {
        block3: {
            RendezVousMonitor monitor = this.rdvService.getMonitor();
            if (monitor != null) {
                try {
                    monitor.disconnected((PeerID)pid);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                    LOG.error((Object)("Uncaught Throwable during callback of (" + monitor + ") to " + pid), ignored);
                }
            }
        }
    }

    private void connected(ID pid, long lease) {
        block3: {
            RendezVousMonitor monitor = this.rdvService.getMonitor();
            if (monitor != null) {
                try {
                    monitor.connected((PeerID)pid, lease);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                    LOG.error((Object)("Uncaught Throwable during callback of (" + monitor + ") to " + pid), ignored);
                }
            }
        }
    }

    public void setChoiceDelay(long delay) {
        this.monitorStartAt = TimeUtils.toAbsoluteTimeMillis(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerViewEvent(PeerViewEvent event) {
        int theEventType = event.getType();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.group.getPeerGroupName() + "] Processing " + event));
        }
        switch (theEventType) {
            case 10: {
                EdgePeerRdvService edgePeerRdvService = this;
                synchronized (edgePeerRdvService) {
                    try {
                        long choiceDelay;
                        if (!this.rendezVous.isEmpty()) {
                            break;
                        }
                        if (this.monitorStartAt == -1L) {
                            choiceDelay = this.maxChoiceDelay;
                            this.monitorStartAt = TimeUtils.toAbsoluteTimeMillis(choiceDelay);
                        } else {
                            choiceDelay = TimeUtils.toRelativeTimeMillis(this.monitorStartAt);
                        }
                        if (choiceDelay <= 0L) {
                            if (TimeUtils.toRelativeTimeMillis(this.monitorNotBefore) > 0L) {
                                break;
                            }
                            this.monitorNotBefore = TimeUtils.toAbsoluteTimeMillis(3000L);
                            choiceDelay = 0L;
                        } else {
                            this.monitorStartAt -= 3000L;
                        }
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Scheduling rdv monitor in " + choiceDelay + "ms."));
                        }
                        this.timer.schedule((TimerTask)new MonitorTask(), choiceDelay);
                    }
                    catch (Exception anything) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break;
                        LOG.warn((Object)"Event could not be processed", (Throwable)anything);
                    }
                    break;
                }
            }
            case 11: 
            case 12: {
                PeerViewElement pve = event.getPeerViewElement();
                PeerID failedPVE = pve.getRdvAdvertisement().getPeerID();
                RdvConnection pConn = (RdvConnection)this.rendezVous.get(failedPVE);
                if (null == pConn) break;
                pConn.disconnect();
                this.rdvService.generateEvent(5, pConn.getPeerID());
                this.disconnectFromRendezVous(pConn.getPeerID());
                break;
            }
        }
    }

    private void checkRdvs() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.group.getPeerGroupID() + "] Periodic rendezvous check"));
        }
        Iterator<Object> eachRendezvous = Arrays.asList(this.rendezVous.values().toArray()).iterator();
        while (eachRendezvous.hasNext()) {
            RdvConnection pConn = (RdvConnection)eachRendezvous.next();
            try {
                if (TimeUtils.toRelativeTimeMillis(pConn.getLeaseEnd()) <= 0L) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.debug((Object)("[" + this.group.getPeerGroupID() + "] Lease expired. Disconnected from " + pConn));
                    }
                    pConn.disconnect();
                    this.rdvService.generateEvent(5, pConn.getPeerID());
                    this.removeRdv(pConn.getPeerID());
                    continue;
                }
                if (pConn.peerAdvertisementHasChanged()) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("[" + this.group.getPeerGroupID() + "] Local PeerAdvertisement changed. Challenging " + pConn));
                    }
                    this.challengeRendezVous(pConn.getPeerID(), 90000L);
                    continue;
                }
                if (TimeUtils.toRelativeTimeMillis(pConn.getRenewal()) > 0L) continue;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("[" + this.group.getPeerGroupID() + "] Attempting lease renewal for " + pConn));
                }
                this.reconnectToRendezVous(pConn);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("[" + this.group.getPeerGroupID() + "] Failure while checking " + pConn), (Throwable)e);
            }
        }
    }

    private void connectToRandomRdv() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Periodic rendezvous connect attempt for " + this.group.getPeerGroupID()));
        }
        ArrayList<Object> currentView = new ArrayList<Object>(Arrays.asList(this.rdvService.rpv.getView().toArray()));
        Collections.shuffle(currentView);
        while (!currentView.isEmpty()) {
            PeerViewElement pve = (PeerViewElement)currentView.remove(0);
            RdvAdvertisement rdv = pve.getRdvAdvertisement();
            if (null == rdv) continue;
            EndpointAddress destaddr = EdgePeerRdvService.mkAddress(rdv.getPeerID(), this.pName, this.pParam);
            try {
                this.sendLeaseRequest(destaddr, rdv.getRouteAdv());
                break;
            }
            catch (IOException ez) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"rdv connection failed.", (Throwable)ez);
            }
        }
    }

    private class MonitorTask
    extends TimerTask {
        private MonitorTask() {
        }

        public void run() {
            block3: {
                try {
                    EdgePeerRdvService.this.checkRdvs();
                    if (EdgePeerRdvService.this.rendezVous.size() < 1) {
                        EdgePeerRdvService.this.connectToRandomRdv();
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                    LOG.warn((Object)("Uncaught throwable in thread :" + Thread.currentThread().getName()), t);
                }
            }
        }
    }

    private class GCTask
    extends TimerTask {
        private GCTask() {
        }

        public void run() {
            block6: {
                try {
                    Iterator<Object> eachRendezvous = Arrays.asList(EdgePeerRdvService.this.rendezVous.values().toArray()).iterator();
                    while (eachRendezvous.hasNext()) {
                        RdvConnection pConn = (RdvConnection)eachRendezvous.next();
                        try {
                            if (pConn.isConnected()) continue;
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("GC RDV: dropping " + pConn));
                            }
                            EdgePeerRdvService.this.rdvService.generateEvent(5, pConn.getPeerID());
                            EdgePeerRdvService.this.removeRdv(pConn.getPeerID());
                        }
                        catch (Exception e) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                            LOG.warn((Object)("GC failed for " + pConn), (Throwable)e);
                        }
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block6;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }

    private class StdRdvEdgeProtocolListener
    implements StdRendezVousService.StdRdvProtocolListener {
        private StdRdvEdgeProtocolListener() {
        }

        public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + EdgePeerRdvService.this.group.getPeerGroupID() + "] processing " + msg));
            }
            if (msg.getMessageElement("jxta", "RdvAdv") != null) {
                EdgePeerRdvService.this.processRdvAdvReply(msg);
            }
            if (msg.getMessageElement("jxta", "ConnectedPeer") != null || msg.getMessageElement("jxta", "RdvAdvReply") != null) {
                EdgePeerRdvService.this.processConnectedReply(msg);
            }
            if (msg.getMessageElement("jxta", "Disconnect") != null) {
                EdgePeerRdvService.this.processDisconnectRequest(msg);
            }
        }
    }
}

