/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Arrays;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TCPAdv
extends TransportAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)TCPAdv.class.getName());
    private static final String[] CONFIGMODES = new String[]{"auto", "manual"};
    private static final String[] INDEXFIELDS = new String[0];
    private static final String PORT_ELEMENT = "Port";
    private static final String ClientOffTag = "ClientOff";
    private static final String ServerOffTag = "ServerOff";
    private static final String MULTICAST_OFF_TAG = "MulticastOff";
    private static final String FlagsTag = "Flags";
    private static final String PublicAddressOnlyAttr = "PublicAddressOnly";
    private String configMode = CONFIGMODES[0];
    private String interfaceAddress = null;
    private int startPort = -1;
    private int listenPort = -1;
    private int endPort = -1;
    private String server = null;
    private String multicastaddr = null;
    private int multicastport = -1;
    private int multicastsize = -1;
    private boolean clientEnabled = true;
    private boolean serverEnabled = true;
    private boolean multicastEnabled = true;
    private boolean publicAddressOnly = false;

    public static String getAdvertisementType() {
        return "jxta:TCPTransportAdvertisement";
    }

    private TCPAdv() {
    }

    private TCPAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(TCPAdv.getAdvertisementType()) && !TCPAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Attribute attr = doc.getAttribute(FlagsTag);
        if (attr != null) {
            String options = attr.getValue();
            this.publicAddressOnly = options.indexOf(PublicAddressOnlyAttr) != -1;
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Unhandled Element: " + elem));
        }
        if (this.listenPort < -1 || this.listenPort > 65535) {
            throw new IllegalArgumentException("Illegal Listen Port Value");
        }
        if (this.startPort < -1 || this.startPort > 65535) {
            throw new IllegalArgumentException("Illegal Start Port Value");
        }
        if (this.endPort < -1 || this.endPort > 65535) {
            throw new IllegalArgumentException("Illegal End Port Value");
        }
        if (0 == this.startPort && this.endPort != 0 || 0 != this.startPort && this.endPort == 0) {
            throw new IllegalArgumentException("Port ranges must both be 0 or non-0");
        }
        if (-1 == this.startPort && this.endPort != -1 || -1 != this.startPort && this.endPort == -1) {
            throw new IllegalArgumentException("Port ranges must both be -1 or not -1");
        }
    }

    public String getAdvType() {
        return TCPAdv.getAdvertisementType();
    }

    public String getInterfaceAddress() {
        return this.interfaceAddress;
    }

    public void setInterfaceAddress(String ia) {
        this.interfaceAddress = ia;
    }

    public int getPort() {
        return this.listenPort;
    }

    public void setPort(int port) {
        this.listenPort = port;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public void setStartPort(int start) {
        this.startPort = start;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public void setEndPort(int end) {
        this.endPort = end;
    }

    public boolean getMulticastState() {
        return this.multicastEnabled;
    }

    public void setMulticastState(boolean newState) {
        this.multicastEnabled = newState;
    }

    public String getMulticastAddr() {
        return this.multicastaddr;
    }

    public void setMulticastAddr(String multicastaddr) {
        this.multicastaddr = multicastaddr;
    }

    public int getMulticastPort() {
        return this.multicastport;
    }

    public void setMulticastPort(int multicastport) {
        this.multicastport = multicastport;
    }

    public int getMulticastSize() {
        return this.multicastsize;
    }

    public void setMulticastSize(int multicastsize) {
        this.multicastsize = multicastsize;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String a) {
        this.server = a;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public void setClientEnabled(boolean enabled) {
        this.clientEnabled = enabled;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public void setServerEnabled(boolean enabled) {
        this.serverEnabled = enabled;
    }

    public String getConfigMode() {
        return this.configMode;
    }

    public void setConfigMode(String mode) {
        if (!Arrays.asList(CONFIGMODES).contains(mode)) {
            throw new IllegalArgumentException("Unsupported configuration mode.");
        }
        this.configMode = mode;
    }

    public boolean getPublicAddressOnly() {
        return this.publicAddressOnly;
    }

    public void setPublicAddressOnly(boolean only) {
        this.publicAddressOnly = only;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(MULTICAST_OFF_TAG)) {
            this.setMulticastState(false);
            return true;
        }
        if (elem.getName().equals(ClientOffTag)) {
            this.clientEnabled = false;
            return true;
        }
        if (elem.getName().equals(ServerOffTag)) {
            this.serverEnabled = false;
            return true;
        }
        String value = elem.getTextValue();
        if (elem.getName().equals("Protocol") && null != value) {
            this.setProtocol(value.trim());
            return true;
        }
        if (PORT_ELEMENT.equals(elem.getName()) && null != value) {
            try {
                int thePort = Integer.parseInt(value.trim());
                if (thePort < -1 || thePort > 65535) {
                    throw new IllegalArgumentException("Illegal port value : " + thePort);
                }
                this.setPort(thePort);
                Attribute startAttr = elem.getAttribute("start");
                Attribute endAttr = elem.getAttribute("end");
                if (null != startAttr && null != endAttr) {
                    this.setStartPort(Integer.parseInt(startAttr.getValue().trim()));
                    this.setEndPort(Integer.parseInt(endAttr.getValue().trim()));
                }
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal port value : " + value);
            }
            return true;
        }
        if (elem.getName().equals("MulticastAddr") && null != value) {
            this.setMulticastAddr(value.trim());
            return true;
        }
        if (elem.getName().equals("MulticastPort") && null != value) {
            try {
                int thePort = Integer.parseInt(value.trim());
                if (thePort < 1 || thePort > 65535) {
                    throw new IllegalArgumentException("Illegal port value : " + thePort);
                }
                this.setMulticastPort(thePort);
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal port value : " + value);
            }
            return true;
        }
        if (elem.getName().equals("MulticastSize") && null != value) {
            try {
                int theMulticastSize = Integer.parseInt(value.trim());
                if (theMulticastSize < 0 || theMulticastSize > 1048575) {
                    throw new IllegalArgumentException("Illegal multicast datagram size : " + theMulticastSize);
                }
                this.setMulticastSize(theMulticastSize);
            }
            catch (NumberFormatException badPort) {
                throw new IllegalArgumentException("Illegal multicast datagram size : " + value);
            }
            return true;
        }
        if (elem.getName().equals("Server") && null != value) {
            this.setServer(value.trim());
            return true;
        }
        if (elem.getName().equals("InterfaceAddress") && null != value) {
            this.setInterfaceAddress(value.trim());
            return true;
        }
        if (elem.getName().equals("ConfigMode") && null != value) {
            this.setConfigMode(value.trim());
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        String interfaceAddr;
        if (this.listenPort < -1 || this.listenPort > 65535) {
            throw new IllegalStateException("Illegal Listen Port Value");
        }
        if (this.startPort < -1 || this.startPort > 65535) {
            throw new IllegalStateException("Illegal Start Port Value");
        }
        if (this.endPort < -1 || this.endPort > 65535) {
            throw new IllegalStateException("Illegal End Port Value");
        }
        if (0 == this.startPort && this.endPort != 0 || 0 != this.startPort && this.endPort == 0) {
            throw new IllegalStateException("Port ranges must both be 0 or non-0");
        }
        if (-1 == this.startPort && this.endPort != -1 || -1 != this.startPort && this.endPort == -1) {
            throw new IllegalStateException("Port ranges must both be -1 or not -1");
        }
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (adv instanceof Attributable && this.publicAddressOnly) {
            ((Attributable)((Object)adv)).addAttribute(FlagsTag, PublicAddressOnlyAttr);
        }
        Element e11 = adv.createElement("Protocol", this.getProtocol());
        adv.appendChild(e11);
        Element e12 = adv.createElement(PORT_ELEMENT, Integer.toString(this.listenPort));
        adv.appendChild(e12);
        if (adv instanceof Attributable) {
            Attributable attrElem = (Attributable)((Object)e12);
            if (-1 != this.startPort && -1 != this.endPort) {
                attrElem.addAttribute("start", Integer.toString(this.startPort));
                attrElem.addAttribute("end", Integer.toString(this.endPort));
            }
        }
        if (!this.getMulticastState()) {
            Element e19 = adv.createElement(MULTICAST_OFF_TAG);
            adv.appendChild(e19);
        }
        Element e13 = adv.createElement("MulticastAddr", this.getMulticastAddr());
        adv.appendChild(e13);
        Element e14 = adv.createElement("MulticastPort", Integer.toString(this.getMulticastPort()));
        adv.appendChild(e14);
        Element e15 = adv.createElement("MulticastSize", Integer.toString(this.getMulticastSize()));
        adv.appendChild(e15);
        String serverAddr = this.getServer();
        if (null != serverAddr && (serverAddr = serverAddr.trim()).length() > 0) {
            Element e16 = adv.createElement("Server", serverAddr);
            adv.appendChild(e16);
        }
        if (null != (interfaceAddr = this.getInterfaceAddress()) && (interfaceAddr = interfaceAddr.trim()).length() > 0) {
            Element e17 = adv.createElement("InterfaceAddress", interfaceAddr);
            adv.appendChild(e17);
        }
        if (this.getConfigMode() != null) {
            Element e18 = adv.createElement("ConfigMode", this.getConfigMode());
            adv.appendChild(e18);
        }
        if (!this.isClientEnabled()) {
            Element e19 = adv.createElement(ClientOffTag);
            adv.appendChild(e19);
        }
        if (!this.isServerEnabled()) {
            Element e20 = adv.createElement(ServerOffTag);
            adv.appendChild(e20);
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return INDEXFIELDS;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return TCPAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new TCPAdv();
        }

        public Advertisement newInstance(Element root) {
            return new TCPAdv(root);
        }
    }
}

