/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.SrdiMessage;
import org.apache.log4j.Logger;

public class SrdiMessageImpl
extends SrdiMessage {
    private static final Logger LOG = Logger.getLogger((String)SrdiMessageImpl.class.getName());
    public static final String pidTag = "PID";
    public static final String ttlTag = "ttl";
    public static final String entryTag = "Entry";
    public static final String pKeyTag = "PKey";
    public static final String sKeyTag = "SKey";
    public static final String valTag = "Value";
    public static final String expirationTag = "Expiration";

    public SrdiMessageImpl() {
        this.setTTL(0);
    }

    public SrdiMessageImpl(InputStream stream) throws IOException {
        XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.readIt(doc);
    }

    public SrdiMessageImpl(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(SrdiMessageImpl.getMessageType()) && !SrdiMessageImpl.getMessageType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    public SrdiMessageImpl(PeerID peerid, int ttl, String pKey, List entries) {
        this.setPeerID(peerid);
        this.setTTL(ttl);
        this.setPrimaryKey(pKey);
        this.setEntries(entries);
    }

    public SrdiMessageImpl(PeerID peerid, int ttl, String pKey, String key, String value, long expiration) {
        this.setPeerID(peerid);
        this.setTTL(ttl);
        this.setPrimaryKey(pKey);
        this.addEntry(key, value, expiration);
    }

    public SrdiMessageImpl(String peerid, int ttl, String pKey, List entries) {
        PeerID pid;
        try {
            pid = (PeerID)IDFactory.fromURI(new URI(peerid));
        }
        catch (URISyntaxException badID) {
            throw new IllegalArgumentException("Invalid PeerID ID in message");
        }
        this.setPeerID(pid);
        this.setTTL(ttl);
        this.setPrimaryKey(pKey);
        this.setEntries(entries);
    }

    public void readIt(XMLElement doc) {
        String key = null;
        String value = null;
        long expiration = 0L;
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (elem.getName().equals(pidTag)) {
                try {
                    URI pID = new URI(elem.getTextValue());
                    this.setPeerID((PeerID)IDFactory.fromURI(pID));
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Invalid PeerID ID in message");
                }
            }
            if (elem.getName().equals(pKeyTag)) {
                this.setPrimaryKey(elem.getTextValue());
            }
            if (elem.getName().equals(ttlTag)) {
                this.setTTL(Integer.parseInt(elem.getTextValue()));
            }
            if (!elem.getName().equals(entryTag)) continue;
            Attribute keyEl = elem.getAttribute(sKeyTag);
            key = keyEl == null ? "NA" : keyEl.getValue();
            value = elem.getTextValue();
            Attribute expAttr = elem.getAttribute(expirationTag);
            if (expAttr != null) {
                String expstr = expAttr.getValue();
                expiration = Long.parseLong(expstr);
            } else {
                expiration = -1L;
            }
            SrdiMessage.Entry entry = new SrdiMessage.Entry(key, value, expiration);
            this.addEntry(entry);
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        TextElement e;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, SrdiMessageImpl.getMessageType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Iterator eachEntry = this.getEntries().iterator();
        PeerID peerid = this.getPeerID();
        if (peerid != null) {
            e = adv.createElement(pidTag, peerid.toString());
            adv.appendChild((Element)e);
        }
        if (this.getPrimaryKey() != null) {
            e = adv.createElement(pKeyTag, this.getPrimaryKey());
            adv.appendChild((Element)e);
        }
        if (this.getTTL() > 0) {
            e = adv.createElement(ttlTag, Integer.toString(this.getTTL()));
            adv.appendChild((Element)e);
        }
        while (eachEntry.hasNext()) {
            SrdiMessage.Entry entry = (SrdiMessage.Entry)eachEntry.next();
            if (entry.key == null && entry.value == null) continue;
            e = adv.createElement(entryTag, entry.value);
            adv.appendChild((Element)e);
            ((Attributable)((Object)e)).addAttribute(expirationTag, Long.toString(entry.expiration));
            ((Attributable)((Object)e)).addAttribute(sKeyTag, entry.key);
        }
        return adv;
    }

    public String toString() {
        StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
        return doc.toString();
    }
}

