/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.protocol.RouteResponseMsg;

public class RouteResponse
extends RouteResponseMsg {
    private static final String destRouteTag = "Dst";
    private static final String srcRouteTag = "Src";

    public RouteResponse() {
    }

    public RouteResponse(Element root) {
        String doctype;
        Attribute itsType;
        if (!TextElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String typedoctype = "";
        if (doc instanceof Attributable && null != (itsType = ((Attributable)((Object)doc)).getAttribute("type"))) {
            typedoctype = itsType.getValue();
        }
        if (!((doctype = doc.getName()).equals(RouteResponse.getAdvertisementType()) || doctype.equals(RouteResponseMsg.getAdvertisementType()) && RouteResponse.getAdvertisementType().equals(typedoctype))) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    private void readIt(TextElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            RouteAdvertisement route;
            TextElement aXpt;
            Enumeration eachXpt;
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(destRouteTag)) {
                eachXpt = elem.getChildren();
                while (eachXpt.hasMoreElements()) {
                    aXpt = (TextElement)eachXpt.nextElement();
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                    this.setDestRoute(route);
                }
                continue;
            }
            if (!elem.getName().equals(srcRouteTag)) continue;
            eachXpt = elem.getChildren();
            while (eachXpt.hasMoreElements()) {
                aXpt = (TextElement)eachXpt.nextElement();
                route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                this.setSrcRoute(route);
            }
        }
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredTextDocument xptDoc;
        Element e;
        RouteAdvertisement route;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, RouteResponse.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        if ((route = this.getDestRoute()) != null) {
            e = adv.createElement((Object)destRouteTag);
            adv.appendChild(e);
            xptDoc = (StructuredTextDocument)route.getDocument(asMimeType);
            StructuredDocumentUtils.copyElements(adv, e, xptDoc);
        }
        if ((route = this.getSrcRoute()) != null) {
            e = adv.createElement((Object)srcRouteTag);
            adv.appendChild(e);
            xptDoc = (StructuredTextDocument)route.getDocument(asMimeType);
            StructuredDocumentUtils.copyElements(adv, e, xptDoc);
        }
        return adv;
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }
}

