/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLElement;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Logger;

public class ResolverQuery
extends ResolverQueryMsg
implements Cloneable {
    private static final Logger LOG = Logger.getLogger((String)ResolverQuery.class.getName());
    private static final String handlernameTag = "HandlerName";
    private static final String credentialTag = "jxta:Cred";
    private static final String queryIdTag = "QueryID";
    private static final String hopCountTag = "HC";
    private static final String srcPeerIdTag = "SrcPeerID";
    private static final String srcRouteTag = "SrcPeerRoute";
    private static final String queryTag = "Query";

    public ResolverQuery() {
    }

    public ResolverQuery(String HandlerName, StructuredDocument Credential2, String pId, String Query, int qid) {
        this();
        this.setHandlerName(HandlerName);
        this.setCredential(Credential2);
        this.setQueryId(qid);
        this.setSrc(pId);
        this.setQuery(Query);
    }

    public ResolverQuery(Element root) {
        this();
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        if (!ResolverQuery.getAdvertisementType().equals(doctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
        }
        this.readIt(doc);
        if (null == this.getHandlerName()) {
            throw new IllegalArgumentException("Query message does not contain a handler name");
        }
        if (null == this.getQuery()) {
            throw new IllegalArgumentException("Query message does not contain a query");
        }
    }

    public void readIt(XMLElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(handlernameTag)) {
                this.setHandlerName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(credentialTag)) {
                this.setCredential(StructuredDocumentUtils.copyAsDocument(elem));
                continue;
            }
            if (elem.getName().equals(queryIdTag)) {
                this.queryid = Integer.parseInt(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(srcRouteTag)) {
                Enumeration eachXpt = elem.getChildren();
                while (eachXpt.hasMoreElements()) {
                    TextElement aXpt = (TextElement)eachXpt.nextElement();
                    RouteAdvertisement routeAdv = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                    this.setSrcPeerRoute(routeAdv);
                    this.setSrc(routeAdv.getDestPeerID().toString());
                }
                continue;
            }
            if (elem.getName().equals(hopCountTag)) {
                this.setHopCount(Integer.parseInt(elem.getTextValue()));
                continue;
            }
            if (elem.getName().equals(srcPeerIdTag)) {
                this.setSrc(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals(queryTag)) continue;
            this.setQuery(elem.getTextValue());
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, ResolverQuery.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        TextElement e = adv.createElement(handlernameTag, this.getHandlerName());
        adv.appendChild((Element)e);
        if (this.getCredential() != null) {
            StructuredDocumentUtils.copyElements(adv, adv, this.getCredential());
        }
        e = adv.createElement(queryIdTag, Integer.toString(this.queryid));
        adv.appendChild((Element)e);
        e = adv.createElement(hopCountTag, Integer.toString(this.hopcount));
        adv.appendChild((Element)e);
        e = adv.createElement(srcPeerIdTag, this.getSrc());
        adv.appendChild((Element)e);
        e = adv.createElement(srcRouteTag);
        adv.appendChild((Element)e);
        RouteAdvertisement radv = this.getSrcPeerRoute();
        if (radv != null) {
            StructuredTextDocument xptDoc = (StructuredTextDocument)radv.getDocument(encodeAs);
            StructuredDocumentUtils.copyElements(adv, e, xptDoc);
        }
        e = adv.createElement(queryTag, this.getQuery());
        adv.appendChild((Element)e);
        return adv;
    }

    public String toString() {
        return this.getDocument(MimeMediaType.XMLUTF8).toString();
    }

    public Object clone() {
        ResolverQuery tmp = new ResolverQuery(this.getHandlerName(), this.getCredential(), this.getSrc(), this.getQuery(), this.getQueryId());
        tmp.hopcount = this.hopcount;
        return tmp;
    }

    public ResolverResponseMsg makeResponse() {
        ResolverResponse res = new ResolverResponse();
        res.setHandlerName(this.getHandlerName());
        res.setQueryId(this.getQueryId());
        res.setSrcPeerRoute(this.getSrcPeerRoute());
        return res;
    }
}

