/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RdvAdv
extends RdvAdvertisement {
    private static final transient Logger LOG = Logger.getLogger((String)RdvAdv.class.getName());
    private static final String[] INDEX_FIELDS = new String[]{"RdvPeerId", "RdvServiceName", "RdvGroupId"};

    private RdvAdv() {
    }

    private RdvAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(RdvAdv.getAdvertisementType()) && !RdvAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
        if (null == this.getGroupID()) {
            throw new IllegalArgumentException("Missing peer group ID");
        }
        if (null == this.getPeerID()) {
            throw new IllegalArgumentException("Missing peer ID");
        }
        if (null == this.getServiceName()) {
            throw new IllegalArgumentException("Missing service name");
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals("RdvGroupId")) {
            try {
                URI groupID = new URI(elem.getTextValue().trim());
                this.setGroupID((PeerGroupID)IDFactory.fromURI(groupID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad group ID in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("ID is not a group ID");
            }
            return true;
        }
        if (elem.getName().equals("RdvPeerId")) {
            try {
                URI peerID = new URI(elem.getTextValue().trim());
                this.setPeerID((PeerID)IDFactory.fromURI(peerID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad group ID in advertisement");
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("ID is not a group ID");
            }
            return true;
        }
        if (elem.getName().equals("RdvServiceName")) {
            this.setServiceName(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals("RdvRoute")) {
            Enumeration eachXpt = elem.getChildren();
            while (eachXpt.hasMoreElements()) {
                XMLElement aXpt = (XMLElement)eachXpt.nextElement();
                RouteAdvertisement xptAdv = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                this.setRouteAdv(xptAdv);
            }
            return true;
        }
        if (elem.getName().equals("Name")) {
            this.setName(elem.getTextValue());
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        if (null == this.getGroupID()) {
            throw new IllegalStateException("Missing peer group ID");
        }
        if (null == this.getPeerID()) {
            throw new IllegalStateException("Missing peer ID");
        }
        if (null == this.getServiceName()) {
            throw new IllegalStateException("Missing service name");
        }
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Element e = adv.createElement("RdvGroupId", this.getGroupID().toString());
        adv.appendChild(e);
        e = adv.createElement("RdvPeerId", this.getPeerID().toString());
        adv.appendChild(e);
        e = adv.createElement("RdvServiceName", this.getServiceName());
        adv.appendChild(e);
        String peerName = this.getName();
        if (null != peerName) {
            e = adv.createElement("Name", this.getName());
            adv.appendChild(e);
        }
        if (this.getRouteAdv() != null) {
            Element el = adv.createElement("RdvRoute");
            adv.appendChild(el);
            StructuredTextDocument xptDoc = (StructuredTextDocument)this.getRouteAdv().getDocument(encodeAs);
            StructuredDocumentUtils.copyElements(adv, el, xptDoc);
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return INDEX_FIELDS;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return RdvAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new RdvAdv();
        }

        public Advertisement newInstance(Element root) {
            return new RdvAdv(root);
        }
    }
}

